/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import DrawTop.SelectionEvent;
import DrawTop.SelectionLS;
import DrawTop.SelectionListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.CutShapeAction;
import shapeUtil.MouseHitShape;
import textBox.TextBox;
import util.ContainerManager;

public class CutShape
extends JDialog
implements SelectionListener {
    CutShapeAction action = null;
    JLabel messageLabel1;
    JLabel messageLabel2;
    JButton goButton = null;
    JButton repeatButton = null;
    JButton cancelButton = null;
    JPanel selectPanel = null;
    JRadioButton yesButton = null;
    JRadioButton noButton = null;
    Vector shapeVector = new Vector();
    int debug = 0;

    public CutShape() {
        super((Frame)ObjectTable.getDrawMain(), "cut shape");
        this.setName("cut shape");
        this.action = new CutShapeAction(this);
        this.createDialog();
    }

    public void createDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 10, owner.getY() + 80);
        this.setLocation(centerP);
        this.addWindowListener(this.action);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("CutShape");
        selectionLS.addSelectionListener(this);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Dimension messagePanelSize = new Dimension(300, 80);
        messagePanel.setPreferredSize(messagePanelSize);
        GridLayout basePanelLayout = new GridLayout(3, 1);
        basePanelLayout.setHgap(20);
        basePanelLayout.setVgap(5);
        messagePanel.setLayout(basePanelLayout);
        JLabel instructionLabel = new JLabel(" Click two shapes i.e. target and cutter !");
        this.messageLabel1 = new JLabel(" ");
        this.messageLabel2 = new JLabel(" ");
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        Dimension messageDimension = new Dimension(300, 14);
        this.messageLabel1.setPreferredSize(messageDimension);
        this.messageLabel2.setPreferredSize(messageDimension);
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        JPanel buttonPanel = new JPanel();
        this.goButton = new JButton("GO !");
        this.repeatButton = new JButton("Repeat");
        this.cancelButton = new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.repeatButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.repeatButton.setActionCommand("Repeat");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.repeatButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.repeatButton);
        buttonPanel.add(this.cancelButton);
        this.selectPanel = new JPanel();
        GridLayout selectPanelLayout = new GridLayout(1, 2);
        selectPanelLayout.setHgap(20);
        selectPanelLayout.setVgap(5);
        this.selectPanel.setLayout(selectPanelLayout);
        ButtonGroup group = new ButtonGroup();
        this.yesButton = new JRadioButton("yes");
        this.noButton = new JRadioButton("no");
        group.add(this.yesButton);
        group.add(this.noButton);
        this.noButton.setSelected(true);
        this.selectPanel.add(this.yesButton);
        this.selectPanel.add(this.noButton);
        this.setSelectPanelEnable(false);
        this.selectPanel.setMaximumSize(new Dimension(150, 40));
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(this.selectPanel);
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
        this.showMessage("  Click target shape!", Color.BLUE);
        ContainerManager containerManager = ObjectTable.getContainerManager("CutShape");
        this.shapeVector.clear();
        ShapeContainer[] containers = containerManager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    protected void setSelectPanelEnable(boolean enable) {
        TitledBorder selectPanelBorder = BorderFactory.createTitledBorder("Cut both shapes ?");
        if (enable) {
            selectPanelBorder.setTitleColor(Color.BLACK);
        } else {
            selectPanelBorder.setTitleColor(Color.LIGHT_GRAY);
        }
        this.selectPanel.setBorder(selectPanelBorder);
        this.yesButton.setEnabled(enable);
        this.noButton.setEnabled(enable);
        this.selectPanel.revalidate();
    }

    public void showMessage(String message, Color color) {
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index = message.indexOf("\n");
        String str1 = message;
        String str2 = "";
        if (index > 0) {
            str1 = message.substring(0, index);
            if (index + 1 < message.length()) {
                str2 = message.substring(index + 1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

    public MouseHitShape[] getClickedShapes() {
        int size = this.shapeVector.size();
        MouseHitShape[] shapes = new MouseHitShape[size];
        for (int i = 0; i < size; ++i) {
            shapes[i] = (MouseHitShape)this.shapeVector.get(i);
        }
        return shapes;
    }

    @Override
    public void selected(SelectionEvent event) {
        Point2D point = event.getClickedPoint();
        ShapeContainer[] containers = event.getSelectedContainers();
        int len = containers.length;
        if (len > 1) {
            this.showMessage(" Error.  Select one by one!.", Color.RED);
            return;
        }
        ShapeContainer container = containers[0];
        if (this.debug > 0) {
            System.out.println("CutShape.selected  container=" + container + ", point=" + point);
        }
        if (!this.isSuitable(container)) {
            return;
        }
        if (this.shapeVector.size() == 0) {
            this.showMessage(" Target accepted =>Click cutter.", Color.BLUE);
            DrawShapeUtil.drawTempShape("CutShape", point, 4, "target", Color.RED);
        }
        if (this.shapeVector.size() == 1) {
            if (this.isDuplicated(container) >= 0) {
                this.showMessage(" Error! selected cutter equals target. \n Select other shape for cutter !", Color.RED);
                return;
            }
            this.showMessage(" Cutter accepted => Go ! or Cancel", Color.BLUE);
            DrawShapeUtil.drawTempShape("CutShape", point, 4, "cutter", Color.RED);
            this.goButton.setEnabled(true);
            this.setSelectPanelEnable(true);
        }
        if (this.shapeVector.size() >= 2) {
            this.showMessage(" Target and cutter are selected. \n  Press Go ! or Cancel.", Color.BLUE);
            return;
        }
        MouseHitShape clickedShape = new MouseHitShape(container, point);
        this.shapeVector.add(clickedShape);
    }

    private boolean isSuitable(ShapeContainer container) {
        boolean suitable = true;
        if (container.getContainerType() == ShapeContainer.GROUP) {
            this.showMessage(" Error: Clicked shape is group, Click single shape !", Color.RED);
            suitable = false;
            return suitable;
        }
        ShapeContainer shapeContainer = container;
        int type = shapeContainer.getElement().getTypeE();
        if (type < 41 || type > 57) {
            this.showMessage(" Error: Not shape, Click again !", Color.RED);
            suitable = false;
            return suitable;
        }
        if (shapeContainer.isCommittedText()) {
            this.showMessage(" Error: Clicked shape has comitted text. Repeat this process?", Color.RED);
            int returnCode = JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(), "Clicked shape has comitted text.\n Remove the text and\ncontinue this process?", "", 0);
            if (returnCode == 1) {
                suitable = false;
                return false;
            }
            suitable = true;
            TextBox textBox = shapeContainer.getTextBox();
            shapeContainer.deleteTextBox();
            textBox.setShapeContainer(null);
        }
        return suitable;
    }

    private int isDuplicated(ShapeContainer container) {
        int size = this.shapeVector.size();
        int isave = -1;
        for (int i = 0; i < size; ++i) {
            MouseHitShape clickedShape = (MouseHitShape)this.shapeVector.get(i);
            String id = clickedShape.getShapeContainer().getShapeId();
            if (!container.getShapeId().equals(id)) continue;
            isave = i;
            break;
        }
        return isave;
    }

    private void closeDialog() {
        this.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearAllTempShapes();
        drawPanel.repaint();
        this.setVisible(false);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.debug > 0) {
            System.out.println("CutShape windowClosing");
        }
        this.closeDialog();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

