/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import shape.CubicCurveElement;
import shape.GeneralCurveElement;
import shape.LineElement;
import shape.PaintStyle;
import shape.PolylineElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.ExtendCurve;
import shapeUtil.MouseHitShape;
import util.ContainerManager;
import util.Util;

class ExtCurveAction
extends AbstractAction
implements WindowListener {
    ExtendCurve dialog = null;
    int debug = 0;

    public ExtCurveAction(ExtendCurve dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int debug = 0;
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (debug > 0) {
            System.out.println("- ExtCurveAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("Go")) {
            this.extendCurve();
            ObjectTable.getDrawPanel().repaint("extend curve");
            return;
        }
        if (commandName.equals("Cancel")) {
            this.dialog.closeDialog();
            return;
        }
    }

    public void extendCurve() {
        ShapeContainer targetCurve;
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = new ShapeContainer[1];
        MouseHitShape mouseHitShape = this.dialog.getMouseHitShape();
        containers[0] = targetCurve = mouseHitShape.getShapeContainer();
        containerManager.undoSetupStart(containers);
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setChangeCode(4);
        }
        ShapeContainer extContainer = this.extendCurveExec(targetCurve, this.dialog.getClickedPoint());
        if (extContainer != null) {
            targetCurve.setChangeCode(4);
            containerManager.deleteContainer(targetCurve);
            containerManager.addContainer(extContainer);
            containerManager.undoSetupEnd();
        }
        extContainer.setSelected(true);
        this.dialog.closeDialog();
    }

    public ShapeContainer extendCurveExec(ShapeContainer container, Point2D PT) {
        Curve2D extCurve;
        if (this.debug > 0) {
            System.out.println("extendCurveExec container=" + container.getShapeId() + ", point=" + Util.Pt(PT));
        }
        int type = container.getElement().getTypeE();
        Curve2D curve = container.getElement().getCurve2D();
        int numseg = curve.getNumOfSegments();
        Point2D p0 = curve.getP(0.0);
        Point2D p1 = curve.getP(numseg);
        boolean pos = false;
        if (Vector2D.dist(PT, p0) > Vector2D.dist(PT, p1)) {
            pos = true;
        }
        if ((extCurve = Curve2DUtil.extendCurve2DByPT(curve, PT)) == null) {
            String str = "   Selected curve can't be extended.\n   The clicked target position is bad !";
            this.dialog.showMessage(str, Color.RED);
            this.dialog.getGoButton().setEnabled(false);
            return null;
        }
        ShapeElement extElement = null;
        if (type == 51) {
            extElement = new LineElement();
        }
        if (type == 54) {
            extElement = new PolylineElement();
        }
        if (type == 55) {
            extElement = new CubicCurveElement();
        }
        if (type == 56) {
            extElement = new GeneralCurveElement();
        }
        ShapeContainer extContainer = new ShapeContainer();
        extElement.setCurve2D(extCurve);
        if (this.debug > 0) {
            System.out.println("ExtendCurve extElement:" + extElement.toString());
        }
        extContainer.setElement(extElement);
        extElement.setShapeContainer(extContainer);
        PaintStyle paintStyle = container.getPaintStyle();
        extContainer.setPaintStyle((PaintStyle)paintStyle.clone());
        ContainerManager manager = ObjectTable.getContainerManager();
        extContainer.setNewShapeId(manager, false);
        extContainer.setSelected(true);
        if (this.debug > 0) {
            System.out.println("extContainer:" + extContainer.toString());
        }
        return extContainer;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dialog.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

