/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import DrawTop.SelectionEvent;
import DrawTop.SelectionLS;
import DrawTop.SelectionListener;
import geomExtension.Curve2D;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.ExtCurveAction;
import shapeUtil.ExtendCurveLS;
import shapeUtil.MouseHitShape;
import util.ContainerManager;
import util.Util;

public class ExtendCurve
extends JDialog
implements SelectionListener {
    ExtendCurveLS extendCurveLS = null;
    ExtCurveAction action = null;
    JLabel messageLabel1 = new JLabel(" ");
    JLabel messageLabel2 = new JLabel(" ");
    Dimension messageDimension = new Dimension(250, 14);
    JButton goButton = null;
    JButton cancelButton = null;
    Point2D clickedPoint = null;
    MouseHitShape mouseHitShape = null;
    Point dialogLocation = new Point(500, 90);
    int debug = 0;

    public ExtendCurve() {
        super((Frame)ObjectTable.getDrawMain(), "Extend curve");
        this.setName("Extend curve");
        this.action = new ExtCurveAction(this);
        this.createDialog();
        this.extendCurveLS = new ExtendCurveLS(this);
    }

    public void createDialog() {
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Box messageBox = Box.createVerticalBox();
        messagePanel.add(messageBox);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel1);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel2);
        messageBox.add(Box.createVerticalStrut(0));
        this.messageLabel1.setPreferredSize(this.messageDimension);
        this.messageLabel2.setPreferredSize(this.messageDimension);
        JPanel buttonPanel = new JPanel();
        this.goButton = new JButton("GO !");
        this.cancelButton = new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.cancelButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }

    public void showDialog() {
        Window owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)this.dialogLocation.getX(), owner.getY() + (int)this.dialogLocation.getY());
        this.setLocation(pos);
        this.pack();
        this.setVisible(true);
        ContainerManager containerManager = ObjectTable.getContainerManager();
        this.mouseHitShape = null;
        ShapeContainer[] containers = containerManager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        if (size > 0) {
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    containers[i].setSelected(false);
                }
            }
            if (this.isSuitable(containers[0])) {
                containers[0].setSelected(true);
                Curve2D curve = containers[0].getElement().getCurve2D();
                Point2D point = curve.getP(0.5 * (double)curve.getNumOfSegments());
                if (this.debug > 0) {
                    System.out.println("-- ExtendCurve.showDialog calls receive");
                }
            }
        } else {
            this.showMessage("  Click target curve !", Color.BLUE);
            SelectionLS selectionLS = ObjectTable.getSelectionLS();
            selectionLS.addSelectionListener(this);
        }
    }

    private boolean isSuitable(ShapeContainer container) {
        ShapeContainer shapeContainer = container;
        int type = shapeContainer.getElement().getTypeE();
        if (type < 41 || type > 57) {
            this.showMessage("  Error: Not curve, Click again !", Color.RED);
            return false;
        }
        if (container.getElement().isClosed()) {
            this.showMessage("  Error: Closed Curve !", Color.RED);
            return false;
        }
        if (container.getContainerType() == ShapeContainer.GROUP) {
            this.showMessage("  Error: Clicked shape is group, Click single shape !", Color.RED);
            return false;
        }
        return true;
    }

    @Override
    public void selected(SelectionEvent event) {
        Point2D point = event.getClickedPoint();
        ShapeContainer[] containers = event.getSelectedContainers();
        if (!this.isSuitable(containers[0])) {
            return;
        }
        if (this.mouseHitShape == null) {
            DrawShapeUtil.drawTempShape("ExtendCureve", point, 4, "target", Color.RED);
            this.mouseHitShape = new MouseHitShape(containers[0], point);
            this.showMessage("  Click extending target position !", Color.BLUE);
            this.extendCurveLS.start();
        }
    }

    public void receivePoint(Point2D point) {
        this.clickedPoint = point;
        this.drawMark(point);
        if (this.debug > 0) {
            System.out.println("-- ExtendCurve.receive(point)  point=" + Util.Pt(point));
        }
        if (this.mouseHitShape != null) {
            this.showMessage("  Go or Cancel", Color.BLUE);
            this.goButton.setEnabled(true);
        }
        this.extendCurveLS.end();
    }

    public void showMessage(String message, Color color) {
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index = message.indexOf("\n");
        String str1 = message;
        String str2 = "";
        if (index >= 0) {
            str1 = message.substring(0, index);
            if (index + 1 < message.length()) {
                str2 = message.substring(index + 1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

    public JButton getGoButton() {
        return this.goButton;
    }

    public MouseHitShape getMouseHitShape() {
        return this.mouseHitShape;
    }

    protected ExtendCurveLS getExtendCurveLS() {
        return this.extendCurveLS;
    }

    public Point2D getClickedPoint() {
        return this.clickedPoint;
    }

    public void drawMark(Point2D PT) {
        DrawShapeUtil.clearTempShape("ExtendCurevePT");
        ObjectTable.getDrawPanel().repaint();
        DrawShapeUtil.drawTempShape("ExtendCurvePT", PT, 4, "clicked point", Color.RED);
    }

    protected void closeDialog() {
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearAllTempShapes();
        drawPanel.repaint();
        this.extendCurveLS.end();
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this);
        selectionLS.start();
        Window owner = this.getOwner();
        Point dialogPT = this.getLocation();
        this.dialogLocation = new Point((int)dialogPT.getX() - owner.getX(), (int)dialogPT.getY() - owner.getY());
        this.setVisible(false);
    }
}

