/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import menu.MenuConstants;
import shape.ShapeContainer;
import shapeUtil.FlipAction;
import util.ContainerManager;

public class Flip
extends JDialog {
    FlipAction action = null;
    JLabel messageLabel = null;
    Dimension panelSize = new Dimension(220, 44);
    JRadioButton hButton = null;
    JRadioButton vButton = null;
    JRadioButton copyButton = null;
    JButton goButton = null;
    JButton cancelButton = null;
    Vector shapesVector = new Vector();

    public Flip() {
        super((Frame)ObjectTable.getDrawMain(), "flip");
        this.setName("flip");
        this.action = new FlipAction(this);
        this.createDialog();
    }

    public void createDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + owner.getSize().width - 250, owner.getY() + 100);
        this.setLocation(centerP);
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new FlowLayout(3));
        this.messageLabel = new JLabel(" ");
        messagePanel.add(this.messageLabel);
        JPanel inputPanel = new JPanel();
        GridLayout inputPanelLayout = new GridLayout(2, 1);
        inputPanelLayout.setHgap(20);
        inputPanelLayout.setVgap(10);
        inputPanel.setLayout(inputPanelLayout);
        JPanel flipPanel = new JPanel();
        flipPanel.setPreferredSize(this.panelSize);
        TitledBorder frameBorder = BorderFactory.createTitledBorder("flip");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        flipPanel.setBorder(frameBorder);
        GridLayout flipPanelLayout = new GridLayout(1, 2);
        flipPanelLayout.setHgap(20);
        flipPanelLayout.setVgap(5);
        flipPanel.setLayout(flipPanelLayout);
        ButtonGroup flipGroup = new ButtonGroup();
        this.hButton = new JRadioButton("holizontally");
        this.hButton.setSelected(true);
        flipGroup.add(this.hButton);
        flipPanel.add(this.hButton);
        this.vButton = new JRadioButton("vertically");
        flipGroup.add(this.vButton);
        flipPanel.add(this.vButton);
        inputPanel.add(flipPanel);
        JPanel copyPanel = new JPanel();
        copyPanel.setPreferredSize(this.panelSize);
        frameBorder = BorderFactory.createTitledBorder("copy");
        copyPanel.setBorder(frameBorder);
        GridLayout copyPanelLayout = new GridLayout(1, 2);
        copyPanel.setLayout(copyPanelLayout);
        ButtonGroup copyGroup = new ButtonGroup();
        this.copyButton = new JRadioButton("yes");
        JRadioButton noCopyButton = new JRadioButton("no");
        copyGroup.add(this.copyButton);
        this.copyButton.setSelected(true);
        copyGroup.add(noCopyButton);
        copyPanel.add(this.copyButton);
        copyPanel.add(noCopyButton);
        inputPanel.add(copyPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(this.panelSize);
        this.goButton = new JButton("GO !");
        this.cancelButton = new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.cancelButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(inputPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("flip");
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = containerManager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        if (size > 0) {
            this.shapesVector.clear();
            for (int i = 0; i < size; ++i) {
                this.shapesVector.add(containers[i]);
            }
        }
        if (this.shapesVector.size() > 0) {
            this.goButton.setEnabled(true);
        } else {
            this.showMessage("Select shapes before this command !", Color.RED);
            this.shapesVector.clear();
        }
    }

    protected void showMessage(String message, Color color) {
        this.messageLabel.setForeground(color);
        this.messageLabel.setFont(DrawParameters.Font12Bold);
        this.messageLabel.setText(message);
    }

    public ShapeContainer[] getSelectedContainers() {
        int size = this.shapesVector.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            containers[i] = (ShapeContainer)this.shapesVector.get(i);
        }
        return containers;
    }

    public JRadioButton getHorizontalButton() {
        return this.hButton;
    }

    public JRadioButton getCopyButton() {
        return this.copyButton;
    }

    public Vector getShapeVector() {
        return this.shapesVector;
    }
}

