/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import geomExtension.Matrix2D;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JRadioButton;
import shape.DrawShapeUtil;
import shape.GroupElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import shapeUtil.Flip;
import util.ContainerManager;

class FlipAction
extends AbstractAction
implements WindowListener {
    Flip dialog = null;
    int debug = 0;

    public FlipAction(Flip dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- FlipAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("Go")) {
            JRadioButton hButton = this.dialog.getHorizontalButton();
            String dir = "Horizontally";
            if (!hButton.isSelected()) {
                dir = "Vertically";
            }
            JRadioButton copyButton = this.dialog.getCopyButton();
            boolean copy = copyButton.isSelected();
            Vector shapesVector = this.dialog.getShapeVector();
            int size = shapesVector.size();
            if (size == 0) {
                return;
            }
            ShapeContainer[] containers = new ShapeContainer[size];
            ShapeContainer[] newContainers = new ShapeContainer[size];
            ContainerManager containerManager = ObjectTable.getContainerManager("");
            for (int i = 0; i < size; ++i) {
                containers[i] = (ShapeContainer)shapesVector.get(i);
            }
            Rectangle2D box = ShapeElementUtil.getBoundingBox(containers);
            int direction = 0;
            double center = box.getX() + box.getWidth() / 2.0;
            if (dir.startsWith("V")) {
                direction = 1;
                center = box.getY() + box.getHeight() / 2.0;
            }
            if (copy) {
                center += 10.0;
            }
            Matrix2D matrix = Matrix2D.getFlipMatrix(direction, center);
            containerManager.undoSetupStart(containers);
            for (int i = 0; i < size; ++i) {
                newContainers[i] = this.flipContainer(matrix, containers[i], copy);
                containers[i].setSelected(false);
                if (copy) {
                    newContainers[i].setSelected(true);
                    newContainers[i].setNewShapeId(containerManager, true);
                    containerManager.addContainer(newContainers[i]);
                } else {
                    newContainers[i].setChangeCode(3);
                }
                if (this.debug <= 0) continue;
                System.out.println("++ flipContainer container=" + containers[i] + "\n   newContainer=" + newContainers[i]);
            }
            containerManager.undoSetupEnd();
            shapesVector.clear();
            this.closeDialog();
            ObjectTable.getDrawPanel().repaint("flip");
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
        }
    }

    private ShapeContainer flipContainer(Matrix2D flipMatrix, ShapeContainer container, boolean copy) {
        ShapeContainer newContainer = container;
        if (copy) {
            newContainer = (ShapeContainer)container.clone();
        }
        if (newContainer.getContainerType() == ShapeContainer.SHAPE) {
            ShapeElement element = newContainer.getElement();
            element.transform(flipMatrix);
        } else {
            GroupElement groupElement = (GroupElement)newContainer.getElement();
            ShapeContainer[] children = groupElement.getGroupedSingleShapeContainers();
            for (int j = 0; j < children.length; ++j) {
                ShapeElement element = children[j].getElement();
                element.transform(flipMatrix);
            }
        }
        return newContainer;
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("Flip");
        drawPanel.repaint();
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

