/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.ListenerPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import shape.GeneralCurveElement;
import shape.PaintStyle;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.ConnectionUtil;
import shapeUtil.DiscreteAngledLine;
import util.ContainerManager;

public class ModifyShapeLS
implements MouseListener,
MouseMotionListener {
    ShapeContainer shapeContainer = null;
    ConnectionUtil connectionUtil = new ConnectionUtil();
    int command = 81;
    Point2D startPoint = null;
    Point2D endPoint = null;
    Point2D oldPoint = null;
    DiscreteAngledLine angledLine = null;
    Vector workVector = new Vector();
    public int debug = 0;

    public void start(ShapeContainer shapeContainer) {
        DrawParameters.MODE = 5;
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        this.shapeContainer = shapeContainer;
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("ModifyShapeLS");
        listenerPanel = ObjectTable.getListenerPanel("ModifyShapeLS");
        listenerPanel.addMouseListener(this);
        listenerPanel.addMouseMotionListener(this);
        SelectionLS selectionLS = ObjectTable.getSelectionLS();
        selectionLS.end();
        int type = shapeContainer.getElement().getTypeE();
        if (type != 44) {
            ShapeElement element = shapeContainer.getElement();
            GeneralCurveElement gelement = element.getGeneralCurveElement();
            this.shapeContainer.setElement(gelement);
            this.shapeContainer.setNewShapeId(containerManager, true);
            if (this.debug > 0) {
                String str = "\n - ModifyShapeLS start shapeContainer:" + this.shapeContainer.toString();
                System.out.println(str);
            }
        }
        ShapeContainer[] targetContainers = new ShapeContainer[]{this.shapeContainer};
        this.connectionUtil.setTargets(targetContainers);
        ShapeContainer[] containers = this.connectionUtil.getTargetsAndConnectors();
        containerManager.undoSetupStart(containers);
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setChangeCode(4);
        }
        this.command = 81;
    }

    public void end() {
        if (this.debug > 0) {
            System.out.println(" - ModifyShapeLS end");
        }
        DrawParameters.MODE = 0;
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("ModifyShapeLS");
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        SelectionLS selectionLS = ObjectTable.getSelectionLS();
        selectionLS.start();
        if (this.debug > 0) {
            String str = "\n - ModifyShapeLS end shapeContainer:" + this.shapeContainer.toString();
            System.out.println(str);
        }
        this.connectionUtil.end();
        boolean formalVersion = ObjectTable.formalVersion;
        if (formalVersion) {
            GeneralCurveElement gelement = (GeneralCurveElement)this.shapeContainer.getElement();
            int index = this.shapeContainer.getContainerIndex();
            PaintStyle paintStyle = this.shapeContainer.getPaintStyle();
            String str = "** Test Changing to SimpleElements containerIndex=" + index;
            ShapeElement[] elements = gelement.getSimpleShapeElements();
            if (elements.length > 0) {
                int i;
                ShapeContainer[] newContainers = new ShapeContainer[elements.length];
                for (i = 0; i < elements.length; ++i) {
                    newContainers[i] = new ShapeContainer();
                    newContainers[i].setElement(elements[i]);
                    newContainers[i].setNewShapeId(containerManager, false);
                    newContainers[i].setPaintStyle((PaintStyle)paintStyle.clone());
                    str = str + "\n - newContainer[" + i + "]: " + newContainers[i].toShortString();
                }
                if (this.debug > 0) {
                    System.out.println(str);
                }
                containerManager.deleteContainer(this.shapeContainer);
                for (i = 0; i < elements.length; ++i) {
                    containerManager.addContainer(index, newContainers[i]);
                }
            }
        }
        containerManager.undoSetupEnd();
    }

    public void setCommand(int command) {
        this.command = command;
        ContainerManager containerManager = ObjectTable.getContainerManager();
        containerManager.undoSetupEnd();
        ShapeContainer[] containers = this.connectionUtil.getTargetsAndConnectors();
        containerManager.undoSetupStart(containers);
        for (int i = 0; i < containers.length; ++i) {
            containers[i].setChangeCode(4);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x800) != 0) {
            ctrl = 3;
        }
        if ((key & 0x1000) != 0) {
            ctrl = 3;
        }
        this.startPoint = new Point2D.Double(X, Y);
        this.oldPoint = new Point2D.Double(X, Y);
        this.shapeContainer.getElement().mouseStart(ctrl, this.startPoint);
        this.angledLine = new DiscreteAngledLine(0.0, 90.0, this.startPoint);
        this.connectionUtil.getTargetsAndConnectors();
        ObjectTable.getDrawPanel().repaint("ModifyShape");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.command != 81) {
            return;
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        this.endPoint = new Point2D.Double(X, Y);
        ShapeElement shapeElement = this.shapeContainer.getElement();
        Point2D oldPT = this.angledLine.getControlledPT(ctrl, this.oldPoint);
        Point2D endPT = this.angledLine.getControlledPT(ctrl, this.endPoint);
        shapeElement.modify(ctrl, oldPT, endPT);
        int connectorResizeOption = DrawParameters.AUTO_TRACKING_OPTION;
        if (this.debug > 0) {
            System.out.println("** connectorResizeOption=" + connectorResizeOption);
        }
        this.connectionUtil.resizeConnectors(connectorResizeOption);
        this.oldPoint = (Point2D)this.endPoint.clone();
        ObjectTable.getDrawPanel().repaint("ModifyShape");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startPoint = null;
        this.endPoint = null;
        this.oldPoint = null;
        this.shapeContainer.getElement().mouseEnd();
        ObjectTable.getDrawPanel().repaint("ModifyShape");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int connectorResizeOption;
        if (this.debug > 0) {
            System.out.println("** ModifyShapeLS mouseClicked this.command=" + Command.getCommandString(this.command));
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        Point2D.Double point = new Point2D.Double(X, Y);
        ShapeElement shapeElement = this.shapeContainer.getElement();
        int type = shapeElement.getTypeE();
        if (this.command == 105) {
            shapeElement.modifyPoint(point, "add_point");
        }
        if (this.command == 106) {
            shapeElement.modifyPoint(point, "delete_point");
            connectorResizeOption = 116;
            if (this.debug > 0) {
                System.out.println("** connectorResizeOption=" + connectorResizeOption);
            }
            this.connectionUtil.resizeConnectors(connectorResizeOption);
        }
        if (this.command == 107) {
            shapeElement.modifyPoint(point, "smooth");
        }
        if (this.command == 108) {
            shapeElement.modifyPoint(point, "cusp");
        }
        if (this.command == 109) {
            System.out.println("ModifyLS disconnect");
            shapeElement.modifyPoint(point, "disconnect");
            connectorResizeOption = 116;
            if (this.debug >= 0) {
                System.out.println("** connectorResizeOption=" + Command.getCommandString(connectorResizeOption));
            }
            this.connectionUtil.resizeConnectors(connectorResizeOption);
        }
        ObjectTable.getDrawPanel().repaint("ModifyShape");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

