/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.Translate;
import util.ContainerManager;

class TranslateAction
extends AbstractAction
implements WindowListener {
    Translate dialog = null;
    int debug = 0;

    public TranslateAction(Translate dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- TranslateAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("click")) {
            JCheckBox checkBox = this.dialog.checkBox;
            DrawShapeUtil.clearTempShape("Translate");
            ObjectTable.getDrawPanel().repaint();
            if (checkBox.isSelected()) {
                this.dialog.addConnectionListener();
            } else {
                this.dialog.removeConnectionListener();
                ObjectTable.getSelectionLS().start();
            }
        }
        if (commandName.equals("pixel") || commandName.equals("mm")) {
            this.dialog.setValuesToTranslateSpinners();
        }
        if (commandName.equals("Go")) {
            int i;
            JRadioButton copyButton = this.dialog.getCopyButton();
            boolean copy = copyButton.isSelected();
            Vector shapesVector = this.dialog.getShapeVector();
            int size = shapesVector.size();
            if (size == 0) {
                return;
            }
            ShapeContainer[] containers = new ShapeContainer[size];
            for (int i2 = 0; i2 < size; ++i2) {
                containers[i2] = (ShapeContainer)shapesVector.get(i2);
            }
            ShapeContainer[] newContainers = new ShapeContainer[size];
            ContainerManager containerManager = ObjectTable.getContainerManager("");
            Vector2D translateVec = this.dialog.translateVec;
            if (Vector2D.length(translateVec) == 0.0) {
                this.dialog.showMessage("** Error: specify non-zero (x,y) !!", Color.RED);
                return;
            }
            containerManager.undoSetupStart(containers);
            for (i = 0; i < size; ++i) {
                newContainers[i] = this.translateContainer(containers[i], translateVec, copy);
                containers[i].setSelected(false);
                if (copy) {
                    newContainers[i].setSelected(true);
                    newContainers[i].setNewShapeId(containerManager, true);
                    containerManager.addContainer(newContainers[i]);
                    continue;
                }
                newContainers[i].setChangeCode(3);
            }
            containerManager.undoSetupEnd();
            shapesVector.clear();
            for (i = 0; i < newContainers.length; ++i) {
                shapesVector.add(newContainers[i]);
            }
            ObjectTable.getDrawPanel().repaint("translate");
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
        }
    }

    private ShapeContainer translateContainer(ShapeContainer container, Vector2D translateVec, boolean copy) {
        ShapeContainer newContainer = container;
        if (copy) {
            newContainer = (ShapeContainer)container.clone();
        }
        ShapeElement element = newContainer.getElement();
        Rectangle2D oldBox = element.getBoundingBox();
        Rectangle2D.Double newBox = new Rectangle2D.Double(oldBox.getX() + translateVec.getX(), oldBox.getY() + translateVec.getY(), oldBox.getWidth(), oldBox.getHeight());
        element.moveResize(oldBox, newBox, true);
        return newContainer;
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("Translate");
        drawPanel.repaint();
        SelectionLS selectionLS = ObjectTable.getSelectionLS();
        selectionLS.removeSelectionListener();
        this.dialog.removeConnectionListener();
        ObjectTable.getSelectionLS().start();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

