/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import shape.SerializableElement;
import shape.SerializableElementUtil;
import shape.ShapeContainer;
import util.Edit;
import util.ScreenImage;

public class TransferableShapeContainer
implements Transferable {
    SerializableElement[] sElements = null;
    private Image image;
    public static int debug = Edit.debug;

    public TransferableShapeContainer(ShapeContainer[] containers) {
        this.sElements = new SerializableElement[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            SerializableElement sElm;
            this.sElements[i] = sElm = SerializableElementUtil.convertShapeContainer(containers[i]);
        }
        ScreenImage screenImage = new ScreenImage(containers);
        this.image = screenImage.getImage();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor == Edit.DrawShapeFlavor || flavor.equals(Edit.DrawShapeFlavor)) {
            return this.sElements;
        }
        if (flavor.equals(DataFlavor.imageFlavor)) {
            return this.image;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{Edit.DrawShapeFlavor, DataFlavor.imageFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean supported = false;
        if (flavor == Edit.DrawShapeFlavor) {
            supported = true;
        }
        if (flavor == DataFlavor.imageFlavor) {
            supported = true;
        }
        return supported;
    }
}

