package DrawTop;


import java.awt.geom.*;
import java.io.*;
import javax.swing.border.Border.*;
import shape.*;
import textBox.*;
import geomExtension.*;


public class MousePositionInfo implements Serializable{
    ShapeContainer container=null;
    ShapeContainer shapeContainerInGroup=null;
    TextBox textBox=null;
    String mouseStatus="";
    boolean rightButtonPressed=false;
    int position=0;
    Point2D point=null;
    String information="";
    
    public MousePositionInfo(){
        this.setPositionString();
    }
    
    public void setContainer(ShapeContainer container){
        this.container=container;
    }
    
    public void setShapeContainerInGroup(ShapeContainer shapeContainerInGroup){
        this.shapeContainerInGroup=shapeContainerInGroup;
    }
    
    public void setTextBox(TextBox textBox){
        this.textBox=textBox;
    }
    
    public void setMouseStatus(String mouseStatus){
        this.mouseStatus=mouseStatus;
    }
    
    public void setRightButtonPressed(boolean pressed){
        this.rightButtonPressed=pressed;
    }
    
    public void setPosition(int position){
        this.position=position;
    }
    
    public void setPoint(Point2D point){
        this.point=point;
    }
    
    public void setInformation(String inf) {
        this.information=inf;
    }

    public ShapeContainer getContainer(){
        return this.container;
    }
    
    public ShapeContainer getShapeContainerInGroup(){
        return this.shapeContainerInGroup;
    }
    

    public TextBox getTextBox(){
        return this.textBox;
    }
    
    public String getMouseStatus(){
        return this.mouseStatus;
    }
    
    public boolean isRightButtonPressed(){
        return this.rightButtonPressed;
    }
    
    public int getPosition(){
        return this.position;
    }
    
    public Point2D getPoint(){
        return this.point;
    }

    public String getInformation() {
        return this.information;
    }

    public int getEndPTindex(){
        int index=-1;
        if(this.onEndPoint()){
            index=0;
            Point2D[] PTs=this.container.getElement().getEndPTs();
            double d0=Vector2D.dist(this.point, PTs[0]);
            double d1=Vector2D.dist(this.point, PTs[1]);
            if(d0>d1) index=1;
        }
        return index;
    }
    
    public Point2D getEndPT(){
        Point2D endPT=null;
        if(this.onEndPoint()){
            Point2D[] PTs=this.container.getElement().getEndPTs();
            int index=this.getEndPTindex();
            endPT=PTs[index];
        }
        return endPT;
    }
    
    public boolean onResizeMark(){
        return (this.position>=NW_RESIZE&&this.position<=W_RESIZE);
    }
    
    public boolean onEndPoint(){
        return (this.position==this.END_POINT);
    }
    
    public boolean onControlPoint(){
        return (this.position==this.CONTROL_POINT);
    }

    public Object clone(){
        if(this==null) return null;
        MousePositionInfo info=new MousePositionInfo();
        info.container=this.container;
        info.shapeContainerInGroup=this.shapeContainerInGroup;
        info.textBox=this.textBox;
        info.mouseStatus=this.mouseStatus;
        info.rightButtonPressed=this.rightButtonPressed;
        info.position=this.position;
        info.point=(Point2D)this.point;
        info.information=this.information;
        return info;
/*
        if(this==null) return null;
        MousePositionInfo info=new MousePositionInfo();
        info.container=(ShapeContainer)this.container.clone();
        if(this.shapeContainerInGroup!=null){
            info.shapeContainerInGroup=(ShapeContainer)this.shapeContainerInGroup.clone();
        }
        if(this.textBox!=null){
            info.textBox=(TextBox)this.textBox.clone();
        }
        info.mouseStatus=this.mouseStatus;
        info.rightButtonPressed=this.rightButtonPressed;
        info.position=this.position;
        info.point=(Point2D)this.point.clone();
        info.information=this.information;
        return info;
 */
    }
    
    public String toString(){
        String str="";
            double X=this.point.getX();
            double Y=this.point.getY();
        str+=" "+this.getPositionStringInDetail(this.position);
        if(this.container!=null) str+=",  shape="+this.container.getShapeId();
        if(this.shapeContainerInGroup!=null)
            str+=",  shape in group="+this.shapeContainerInGroup.getShapeId();
        str +="  x,y=" + (int) X + "," + (int) Y;
        if(this.rightButtonPressed) str+=", Right Button Pressed";
        if(this.information.equals("")) str+=", inf="+this.information;
        return str;
    }
    
// mouse position code
    public static final int NO_HIT=0;
    public static final int INSIDE_DRAWAREA=1;
    //public static final int SELECTION_BOX=2;
    public static final int SELECTION_BOX=2;
    public static final int NW_RESIZE=3;
    public static final int NE_RESIZE=4;
    public static final int SE_RESIZE=5;
    public static final int SW_RESIZE=6;
    public static final int N_RESIZE=7;
    public static final int E_RESIZE=8;
    public static final int S_RESIZE=9;
    public static final int W_RESIZE=10;
    public static final int BOUNDINGBOX_BOUNDARY=11;
    public static final int INSIDE_BOUNDINGBOX=12;
    public static final int SHAPE_BOUNDARY=13;
    public static final int END_POINT=14;
    public static final int CONTROL_POINT=15;
    public static final int INSIDE_SHAPE=16;
    public static final int TEXTBOX_BOUNDARY=17;
    public static final int INSIDE_TEXTBOX=18;
    public static final int INSIDE_TEXT=19;
    public final static String[] positionString=new String[20];
    
    private void setPositionString(){
        for(int i=0;i<positionString.length;i++) setPositionString(i,"");
        setPositionString(NO_HIT,"NO_HIT");
        setPositionString(INSIDE_DRAWAREA,"INSIDE_DRAWAREA");
        setPositionString(SELECTION_BOX,"SELECTION_BOX");
        setPositionString(NW_RESIZE,"NW_RESIZE");
        setPositionString(NE_RESIZE,"NE_RESIZE");
        setPositionString(SE_RESIZE,"SE_RESIZE");
        setPositionString(SW_RESIZE,"SW_RESIZE");
        setPositionString(N_RESIZE,"N_RESIZE");
        setPositionString(E_RESIZE,"E_RESIZE");
        setPositionString(S_RESIZE,"S_RESIZE");
        setPositionString(W_RESIZE,"W_RESIZE");
        setPositionString(BOUNDINGBOX_BOUNDARY,"BOUNDINGBOX_BOUNDARY");
        setPositionString(INSIDE_BOUNDINGBOX,"INSIDE_BOUNDINGBOX");
        setPositionString(SHAPE_BOUNDARY,"SHAPE_BOUNDARY");
        setPositionString(END_POINT,"END_POINT");
        setPositionString(CONTROL_POINT,"CONTROL_POINT");
        setPositionString(INSIDE_SHAPE,"INSIDE_SHAPE");
        setPositionString(TEXTBOX_BOUNDARY,"TEXTBOX_BOUNDARY");
        setPositionString(INSIDE_TEXTBOX,"INSIDE_TEXTBOX");
        setPositionString(INSIDE_TEXT,"INSIDE_TEXT");
    }
    
    void setPositionString(int position, String positionString){
        this.positionString[position]=positionString;
    }
    
    public static String getPositionString(int position){
        String str="";
        str=positionString[position];
        return str;
    }
    
    public static String getPositionStringInDetail(int position){
        String str="No hit";
        if(position==MousePositionInfo.NO_HIT) str="No hit";
        if(position==MousePositionInfo.INSIDE_DRAWAREA) str="Inside draw area";
        if(position==MousePositionInfo.SELECTION_BOX) str="Selection box";
        if(position==MousePositionInfo.NW_RESIZE) str="NW-resize mark";
        if(position==MousePositionInfo.NE_RESIZE) str="NE-resize mark";
        if(position==MousePositionInfo.SE_RESIZE) str="SE-resize mark";
        if(position==MousePositionInfo.SW_RESIZE) str="SW-resize mark";
        if(position==MousePositionInfo.N_RESIZE) str="N-resize mark";
        if(position==MousePositionInfo.E_RESIZE) str="E-resize mark";
        if(position==MousePositionInfo.S_RESIZE) str="S-resize mark";
        if(position==MousePositionInfo.W_RESIZE) str="W-resize mark";
        if(position==MousePositionInfo.BOUNDINGBOX_BOUNDARY) str="Bounding box boundary";
        if(position==MousePositionInfo.INSIDE_BOUNDINGBOX) str="Inside bounding box";
        if(position==MousePositionInfo.SHAPE_BOUNDARY) str="Shape boundary";
        if(position==MousePositionInfo.END_POINT) str="End point";
        if(position==MousePositionInfo.CONTROL_POINT) str="Control point";
        if(position==MousePositionInfo.INSIDE_SHAPE) str="Inside shape";
        if(position==MousePositionInfo.TEXTBOX_BOUNDARY) str="TextBox boundary";
        if(position==MousePositionInfo.INSIDE_TEXTBOX) str="Inside TextBox";
        if(position==MousePositionInfo.INSIDE_TEXT) str="Inside text";
        return str;
    }

} //class MousePositionInfo
