package geomExtension;

import java.awt.*;
import java.awt.geom.*;
import java.text.*;

public class CrossCurvePT{
    public double t1;
    public double t2;
    Point2D p1=null;
    Point2D p2=null;
    Curve2D curve1=null;
    Curve2D curve2=null;
    
    
    public CrossCurvePT(double t1, double t2, Point2D p1, Point2D p2){
        this.t1=t1;
        this.t2=t2;
        this.p1=p1;
        this.p2=p2;
    }
    public CrossCurvePT(double t1, double t2, Point2D p1, Point2D p2, 
            Curve2D curve1, Curve2D curve2){
        this.t1=t1;
        this.t2=t2;
        this.p1=p1;
        this.p2=p2;
        this.curve1=curve1;
        this.curve2=curve2;
    }
    
    public double getParameterT1(){
        return this.t1;
    }
    
    public double getParameterT2(){
        return this.t2;
    }
    
    public Point2D getP1(){
        if(this.curve1!=null) this.p1=curve1.getP(this.t1);
        return this.p1;
    }
    
    public Point2D getP2(){
        if(this.curve2!=null) this.p2=curve2.getP(this.t2);
        return this.p2;
    }
    public void setCurve1(Curve2D curve2D){
        this.curve1=curve2D;
    }
    
    public Curve2D getCurve1(){
        return this.curve1;
    }
    
    public void setCurve2(Curve2D curve2D){
        this.curve2=curve2D;
    }
    
    public Curve2D getCurve2(){
        return this.curve2;
    }
    
    public CurvePT getCurvePT(int index){
        CurvePT curvePT=null;
        if(index==0) curvePT=new CurvePT(this.t1, this.p1);
        if(index>0)  curvePT=new CurvePT(this.t2, this.p2);
        return curvePT;
    }
    
    public CrossCurvePT getReversedOrderData(){
        CrossCurvePT newData=new CrossCurvePT(this.t2, this.t1, (Point2D)this.p2.clone(),
                (Point2D)this.p1.clone(), this.curve2, this.curve1);
        return newData;
    }
    
    public CrossCurvePT exchangeData(){
        CrossCurvePT newData=new CrossCurvePT(this.t2, this.t1, (Point2D)this.p2.clone(),
                (Point2D)this.p1.clone(), this.curve2, this.curve1);
        return newData;
    }
    
    public String toString(){
        NumberFormat nf1 = NumberFormat.getNumberInstance();
        nf1.setMaximumIntegerDigits(4);
        nf1.setMinimumFractionDigits(2);
        NumberFormat nf2 = NumberFormat.getNumberInstance();
        nf2.setMaximumIntegerDigits(5);
        nf2.setMinimumFractionDigits(2);
        String str="";
        str+="CurvePoint t1="+nf1.format(t1)+", t2="+nf1.format(t2)+
                ", p1="+nf2.format(this.getP1().getX())+","+nf2.format(this.getP1().getY())+
                ", p2="+nf2.format(this.getP2().getX())+","+nf2.format(this.getP2().getY());
        return str;
    }
}