/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package geomExtension;

import util.Util;
import java.awt.*;
import java.awt.geom.*;
import DrawTop.*;

public class Line2DE extends Curve2D{

    public Line2DE(Segment2D[] segments){
        super(segments);
    }
    
    public Line2DE(Point2D p1, Point2D p2){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        this.segments=new Segment2D[1];
        Line2D line=new Line2D.Double(p1,p2);
        segments[0]=new Segment2D(Segment2D.LINE, line);
        generalPath.append(line,true);
        this.closed=false;
    }
    
    public Line2DE(double x1, double y1, double x2, double y2){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        this.segments=new Segment2D[1];
        Line2D line=new Line2D.Double(new Point2D.Double(x1,y1),new Point2D.Double(x2,y2));
        segments[0]=new Segment2D(Segment2D.LINE, line);
        generalPath.append(line,true);
        this.closed=false;
    }
//Line2DE proper

    public void setData(Point2D p1, Point2D p2){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        Line2D line=new Line2D.Double(p1,p2);
        this.segments[0]=new Segment2D(Segment2D.LINE, line);
        this.generalPath.append(line,true);
        this.closed=false;
    }

//Line2DE proper
    public Point2D getP1(){
        return this.segments[0].getP(0);
    }
//Line2DE proper
    public Point2D getP2(){
        return this.segments[0].getP(1);
    }
//Line2DE proper
    public double getX1(){
        return this.segments[0].getP(0).getX();
    }
//Line2DE proper
    public double getY1(){
        return this.segments[0].getP(0).getY();
    }
//Line2DE proper
    public double getX2(){
        return this.segments[0].getP(1).getX();
    }
//Line2DE proper
    public double getY2(){
        return this.segments[0].getP(1).getY();
    }
//Curve2D method
    public int getType2DE(){
        return Command.LINE;
    }

    public Line2DE getTrimmedCurve2DE(double t1, double t2){
        if(t1==0.0&&t2==0.0) return this;
        Line2DE trimmedLine=this;
        Point2D p1=this.getP(t1);
        Point2D p2=this.getP(t2);
        trimmedLine=new Line2DE(p1,p2);
        return trimmedLine;
    }
    
    public Line2DE getTrimmedLine(double cut1, double cut2){
        if(cut1==0.0&&cut2==0.0) return this;
        Line2DE trimmedLine=this;
        double length=this.getCurveLength(0, 1);
        double t1=cut1/length;
        double t2=1d-cut2/length;
        trimmedLine=this.getTrimmedCurve2DE(t1,t2);
        return trimmedLine;
    }

//Curve2D method
    public Object clone(){
        return (new Line2DE(this.getP1(), this.getP2()));
    }
//Curve2D method
    public String toString(){
        String str="Line x1,y1="+Util.Pt(this.getP1())+
                ", x2,y2="+Util.Pt(this.getP2());
        return str;
    }
}