package menu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;

public class ButtonOfFontMenu extends JButton implements ActionListener {

    DialogOfFontMenu dialog;
    public static int debug = 0;

    public ButtonOfFontMenu(String commandName, String tip, DialogOfFontMenu dialog) {
        this.setActionCommand(commandName);
        this.addActionListener(this);
        this.setName(commandName);
        this.setText(commandName);
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.dialog = dialog;

    }

    public ButtonOfFontMenu(String commandName, boolean setText,
            ImageIcon imageIcon, String tip, DialogOfFontMenu dialog) {
        super(imageIcon);
        this.setActionCommand(commandName);
        this.addActionListener(this);
        this.setName(commandName);
        if (setText) {
            setText(commandName);
        }
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.dialog = dialog;

    }

    public void setStandardButtonStyle() {
        Border raisedBorder = new BevelBorder(BevelBorder.RAISED);
        this.setBorder(raisedBorder);
        this.setHorizontalTextPosition(SwingConstants.CENTER);
        this.setIconTextGap(0);
        this.setVerticalTextPosition(SwingConstants.BOTTOM);
        this.setHorizontalAlignment(CENTER);
        this.setFont(MenuConstants.MenuFont);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.showDialog();
    }

    public void showDialog() {
        this.dialog.showDialog();
    }

    public static JButton createFontMenuButton(String commandName, int width, String tip) {
        DialogOfFontMenu dialog = new DialogOfFontMenu();
        ButtonOfFontMenu button = null;
        button = new ButtonOfFontMenu(commandName, tip, dialog);
        if (width > 0) {
            button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}
