/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package menu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import DrawTop.*;

public class ComboBox extends JComboBox{
    //protected String selectedItem;
    ComboBoxAction action=new ComboBoxAction();
    
    public ComboBox(String commandName, String[] items, String tip) {
        super(items);
        this.setActionCommand(commandName);
        this.addActionListener(action);
        this.setName(commandName);
        this.setToolTipText(tip);
    }
/*
    public void setStandardStyle() { 
        setFont(MenuConstants.MenuFont);
        setBackground(null);
        setForeground(Color.BLACK);
        setOpaque(true);
    }

    public String getItem() { 
        return this.selectedItem; 
    }

    public boolean isSelected() { 
        return false; 
    }
    public void setSelected(boolean selected) {}

    public void setSelectedItem(String item){
        super.setSelectedItem(item);
    }
    public void itemStateChanged(ItemEvent e) {
        this.selectedItem=(String)e.getItem();
    }
*/
    public void activateListener(boolean activate){
        if(activate&&!this.isActionListener(this.action)){
            this.addActionListener(this.action);
        }
        if(!activate&&this.isActionListener(this.action)){
            this.removeActionListener(this.action);
        }
    }//activateListener

    private boolean isActionListener(ActionListener listener){
        ActionListener[] listeners=this.getListeners(ActionListener.class);
        boolean isRegistered=false;
        for(int i=0;i<listeners.length;i++){
            if(listener.equals(listeners[i])) isRegistered=true;
        }
        return isRegistered;
    }

    public static JComboBox createFontFamilyComboBox(String name) {
        int debug=0;
         GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
         String[] fontNames=env.getAvailableFontFamilyNames();
         //String[] fontNames=new String[names.length+1];
         fontNames[0]=" ";
         if(debug>0){
            String str="createFontFamilyComboBox  ";
            for(int i=0;i<fontNames.length;i++) str+=fontNames[i]+", ";
            System.out.println(str);
        }
         ComboBox comboBox = new ComboBox(name, fontNames, "font family");
         comboBox.activateListener(false);
         comboBox.setSelectedItem("Dialog");
         comboBox.setFont(MenuConstants.MenuItemFont);
         comboBox.setPreferredSize(new Dimension(MenuConstants.buttonWidth*6, 
                 MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(comboBox);
         return comboBox;
     }
     
     public static JComboBox createFontSizeComboBox(String name) {
         String[] fontSizes = new String[] {"", "8", "9", "10", "11", "12", "14",
            "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
         ComboBox comboBox = new ComboBox(name, fontSizes, "font size");
         comboBox.activateListener(false);
         comboBox.setSelectedIndex(5);
         comboBox.activateListener(true);
         comboBox.setFont(MenuConstants.MenuItemFont);
         comboBox.setPreferredSize(new Dimension(MenuConstants.buttonWidth*2,
                 MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(comboBox);
         return comboBox;
     }
}

class ComboBoxAction extends AbstractAction{
    int debug=0;
    public void actionPerformed(ActionEvent e) {
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- ComboBoxAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        ComboBox comboBox=(ComboBox)menuUtil.getMenuComponent(commandName);
        String selectedItem=(String)comboBox.getSelectedItem();
        Object[] args=new Object[1];
        args[0]=selectedItem;
        if(debug>0) System.out.println("- ComboBoxAction.actionPerformed  " +
                "selectedItem="+selectedItem);
        int commandId=Command.getCommandId(commandName);
        if(commandId<0){
            System.err.println("*** Error ComboBoxAction: specified command not found;"+commandName);
            return;
        }
        Command command=new Command(commandId, Command.callFromMenu, args);
        ExecCommand execCommand=ObjectTable.getExecCommand();
        execCommand=ObjectTable.getExecCommand("ComboBoxAction");
        execCommand.exec(command);
    }//End of actionPerformed
}