/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package menu;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import util.*;


public class DialogOfDrawPanel extends JDialog{
    DialogOfDrawPanelAction action=null;
    JScrollPane shapeScrollPane;
    JScrollPane listenerScrollPane;
    Dimension dialogDimension=new Dimension(500,300);
    
    public DialogOfDrawPanel(){
        super(ObjectTable.getDrawMain(),"Draw Panel Information");
        this.setName("DialogOfDrawPanel");  
        this.action=new DialogOfDrawPanelAction(this);
        this.addWindowListener(action);
    }
    
    public void setTitle(String str){
        this.setTitle(str);
    }
    
    public void showDialog(Point mousePosition){
        DialogOfDrawPanelListener DialogListener=new DialogOfDrawPanelListener(this);
        this.addComponentListener(DialogListener);
        Component owner=this.getOwner();
        Point pos=new Point(owner.getX()+(int)mousePosition.getX(), 
                owner.getY()+(int)mousePosition.getY());
        this.setLocation(pos);
        
        Container contentPane=this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane=new JTabbedPane();
        contentPane.add(tabbedPane,BorderLayout.CENTER);
        JPanel shapeInformationPanel=createShapeInfoPanel();
        JPanel listenerInformationPanel=createListenerInfoPanel();

        tabbedPane.add("shapes information", shapeInformationPanel);
        tabbedPane.add("listeners information", listenerInformationPanel);
        this.setPreferredSize(dialogDimension);
        this.pack();
        this.setVisible(true);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        DialogOfShapeFormat dialog
                =(DialogOfShapeFormat)menuUtil.getMenuComponent("DialogOfDrawPanel");
        if(dialog!=null) dialog.removeDialog();
        menuUtil.setMenuComponent(this);
    }
    
    protected void removeDialog(){
        this.setVisible(false);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        Component component=menuUtil.getMenuComponent(this.getName());
        if(component!=null) menuUtil.removeMenuComponent(component);
    }
    
    protected void setScrollViewPosition(){
        this.shapeScrollPane.getViewport().setViewPosition(new Point(0,0));
        this.listenerScrollPane.getViewport().setViewPosition(new Point(0,0));
    }
    
    private JPanel createShapeInfoPanel(){
        JPanel basePanel=new JPanel();
//Information Panel    
        JPanel informationPanel=new JPanel();
        TitledBorder frameBorder=BorderFactory.createTitledBorder("Shapes information");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        informationPanel.setBorder(frameBorder);
        GridLayout inforMationPanelLayout=new GridLayout(1,2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        informationPanel.setLayout(inforMationPanelLayout);

        JTextArea textArea=new JTextArea();
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        ArrayList containerList=containerManager.getContainerList();
        String info="";
        int size=containerList.size();
        //if(containers!=null) size=containers.length;
        if(size==0){
            info+="No containers";
        } else {
            info+="containers list";
            for(int i=0;i<size;i++) {
                ShapeContainer container=(ShapeContainer)containerList.get(i);
                info+="\n\n ** container["+i+"] : "+container.toString();
            }
        }
        textArea.setText(info);
        JScrollPane scrollPane=new JScrollPane();
        this.shapeScrollPane=scrollPane;
        scrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        
        //scrollPane.setPreferredSize(this.scrollPaneDimension);
        JViewport viewport=new JViewport();
        scrollPane.setViewport(viewport);
        
        //JPanel base=new JPanel();
        //base.add(textArea);
        viewport.setView(textArea);
        //Rectangle rect=textArea.modelToView(0);
        viewport.setViewPosition(new Point(0,0));
        //DialogOfDrawPanel.ShapeViewport=viewport;
        informationPanel.add(scrollPane);
        //informationPanel.setPreferredSize(scrollPaneDimension);
        //viewport.revalidate();
        //scrollPane.revalidate();
        
        

    // Layout BasePanel
        Box box=Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(informationPanel);
        box.add(Box.createVerticalStrut(5));
        return basePanel;
    }
    
    private JPanel createListenerInfoPanel(){
        JPanel basePanel=new JPanel();
//Information Panel    
        JPanel informationPanel=new JPanel();
        TitledBorder frameBorder=BorderFactory.createTitledBorder("Listeners information");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        informationPanel.setBorder(frameBorder);
        GridLayout inforMationPanelLayout=new GridLayout(1,2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        informationPanel.setLayout(inforMationPanelLayout);

        JTextArea textArea=new JTextArea();
        ListenerPanel listenerPanel=ObjectTable.getListenerPanel("");
        String str=listenerPanel.getMouseListenersInfo();
        textArea.setText(str);
        //textArea.setPreferredSize(textAreaDimension);

        JScrollPane scrollPane=new JScrollPane();
        this.listenerScrollPane=scrollPane;
        scrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        //scrollPane.setMaximumSize(scrollPaneDimension);
        //scrollPane.setPreferredSize(this.scrollPaneDimension);
        JViewport viewport=new JViewport();
        scrollPane.setViewport(viewport);
        viewport.setView(textArea);
        viewport.setViewPosition(new Point(0,0));
        //DialogOfDrawPanel.ListenerViewport=viewport;
        informationPanel.add(scrollPane);

    // Layout BasePanel
        Box box=Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(informationPanel);
        box.add(Box.createVerticalStrut(5));

        return basePanel;
    }

    public JScrollPane getShapeScrollPane(){
        return this.shapeScrollPane;
    }
    
    public JScrollPane getListenerScrollPane(){
        return this.listenerScrollPane;
    }
}

class DialogOfDrawPanelListener implements ComponentListener{
    DialogOfDrawPanel dialog=null;
    int debug=0;
    
    DialogOfDrawPanelListener(DialogOfDrawPanel dialog){
        this.dialog=dialog;
    }
    
    public void componentResized(ComponentEvent e){
        int marginX=40;
        int marginY=120;
        Dimension sizeOfDialog=this.dialog.getSize();
        if(sizeOfDialog==null) return;
        JScrollPane shapeScrollPane=this.dialog.getShapeScrollPane();
        JScrollPane listenerScrollPane=this.dialog.getListenerScrollPane();
        Dimension newSize=new Dimension((int)(sizeOfDialog.getWidth()-marginX), 
                (int)(sizeOfDialog.getHeight()-marginY));
        shapeScrollPane.setPreferredSize(newSize);
        shapeScrollPane.revalidate();
        listenerScrollPane.setPreferredSize(newSize);
        listenerScrollPane.revalidate();
        this.dialog.validate();
    }
    
    public void componentHidden(ComponentEvent e){}
    public void  componentMoved(ComponentEvent e) {}
    public void componentShown(ComponentEvent e){
      //-------------------------------------------------//  
        this.dialog.setScrollViewPosition();
      //-------------------------------------------------// 
    } 
}

class DialogOfDrawPanelAction extends AbstractAction implements WindowListener{
    DialogOfDrawPanel dialog;
    ExecCommand execCommand=ObjectTable.getExecCommand("DialogOfShapeFormat");
    int debug=0;
    
    public DialogOfDrawPanelAction(DialogOfDrawPanel dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- PullDownMenuAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
    }//End of actionPerformed
    
    private void closeDialog(){
        this.dialog.setVisible(false);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        Component component=menuUtil.getMenuComponent(this.dialog.getName());
        if(component!=null) menuUtil.removeMenuComponent(component);
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        if( debug>0) System.out.println("windowClosing called");
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
} // end of class

