
package menu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import util.*;

public class DialogOfPageSetup extends JDialog{
    PageSetupAction action=null;
    SpinnerListModel pageSizeSpinnerModel;
    JRadioButton landscapeButton;
    JRadioButton portraitButton;
    
    public DialogOfPageSetup(){
        super(ObjectTable.getDrawMain(), "Page Setup");
        this.setName("DialogOfPageSetup");  
        this.action=new PageSetupAction(this);
        this.addWindowListener(action);
    }

    public void showDialog(){
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        DialogOfPageSetup dialog
                =(DialogOfPageSetup)menuUtil.getMenuComponent("DialogOfPageSetup");
        if(dialog!=null) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), 
                    "page setup dialog is already opened", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+20, owner.getY()+90);
        this.setLocation(centerP);
        JPanel pagePanel=this.createPagePanel();
        Container contentPane=this.getContentPane();
        contentPane.add(pagePanel);
        this.pack();
        this.setVisible(true);
        menuUtil.setMenuComponent(this);
    }
    
    private JPanel createPagePanel(){
        JPanel pagePanel=new JPanel();
        GridLayout pagePanelLayout=new GridLayout(3,1);
        pagePanelLayout.setHgap(20);
        pagePanelLayout.setVgap(5);
        pagePanel.setLayout(pagePanelLayout);
        Border border=BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
     //pageSizePanel
        JPanel pageSizePanel=new JPanel();
        pageSizePanel.setFont(MenuConstants.MenuFont);
        TitledBorder frameBorder=BorderFactory.createTitledBorder("Page sized for:");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        pageSizePanel.setBorder(frameBorder);
        String[] pageSizes=new String[9];
        int stringlength=0;
        for(int i=0;i<=8;i++){
            Dimension dimension=DrawParameters.SheetSizesMM[i];
            dimension=new Dimension((int)dimension.getHeight(), (int)dimension.getWidth());
            pageSizes[i]=DrawParameters.SheetSizeString[8-i]+" ( "+(int)dimension.getWidth()+
                    "x"+(int)dimension.getHeight()+" mm )";
            if(pageSizes[i].length()>stringlength) stringlength=pageSizes[i].length();
        }
        this.pageSizeSpinnerModel=new SpinnerListModel(pageSizes);
        JSpinner spinner=new JSpinner(this.pageSizeSpinnerModel);
        spinner.setFont(MenuConstants.MenuFont);
        spinner.setBorder(border);
        String currentSize=DrawParameters.SheetSizeString[DrawParameters.SheetSize];
        int iSave=0;
        for(int i=0;i<=8;i++){
            if(pageSizes[i].startsWith(currentSize)){
                iSave=i;
                break;
            }
        }
        spinner.setValue(pageSizes[iSave]);
        pageSizePanel.add(spinner);
        
     //orientationPanel
        JPanel orientationPanel=new JPanel();
        orientationPanel.setLayout(new BoxLayout(orientationPanel, BoxLayout.X_AXIS));
        frameBorder=BorderFactory.createTitledBorder("Orientation");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        orientationPanel.setBorder(frameBorder);
        JLabel orientationLabel=new JLabel("Orientation:");
        orientationLabel.setFont(MenuConstants.MenuFont);
        orientationLabel.setBorder(border);
        
        JLabel orientationImageLabel=new JLabel();
        ImageIcon imageIcon=DrawImageIcon.get("text_box32T.png", 24,24);
        orientationImageLabel.setIcon(imageIcon);
        
        pagePanel.add(pageSizePanel);
        pagePanel.add(orientationPanel);
     
        JPanel radioButtonPanel=new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, BoxLayout.Y_AXIS));
        this.landscapeButton=new JRadioButton("Landscape");
        this.portraitButton=new JRadioButton("Portrait");
        this.landscapeButton.setFont(MenuConstants.MenuFont);
        this.portraitButton.setFont(MenuConstants.MenuFont);
        ButtonGroup group=new ButtonGroup();
        group.add(this.landscapeButton); 
        group.add(this.portraitButton);
        if(DrawParameters.SheetOrientation==0) this.landscapeButton.setSelected(true);
        else this.portraitButton.setSelected(true);
        radioButtonPanel.add(this.landscapeButton);
        radioButtonPanel.add(this.portraitButton);
        orientationPanel.add(orientationImageLabel);
        orientationPanel.add(radioButtonPanel);
        
    //buttonPanel   
        JPanel buttonPanel=new JPanel();
        JButton okButton=new JButton("OK");
        JButton cancelButton=new JButton("Cancel");
        okButton.setActionCommand("OK");
        cancelButton.setActionCommand("Cancel");
        okButton.addActionListener(this.action);
        cancelButton.addActionListener(this.action);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        pagePanel.add(buttonPanel);
      
        return pagePanel;
    }
}

class PageSetupAction extends AbstractAction implements WindowListener{
    DialogOfPageSetup dialog=null;
    
    public PageSetupAction(DialogOfPageSetup dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {
        int debug=MenuUtil.debug;
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- PullDownMenuAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
        if(commandName.equals("OK")){
            System.out.println(" -- actionPerformed OK");
            String pageSize=(String)this.dialog.pageSizeSpinnerModel.getValue();
            int length=DrawParameters.SheetSizeString.length;
            int size=0;
            for(int i=0;i<length;i++){
                if(pageSize.startsWith(DrawParameters.SheetSizeString[i])){
                    size=i;
                    break;
                }
            }
            int orientation=DrawParameters.LandScape;
            if(this.dialog.portraitButton.isSelected()) orientation=DrawParameters.Portrait;
            PageManager pageManager=ObjectTable.getPageManager();
            pageManager.pageSetup(size, orientation);
            this.closeDialog();
            return;
        }
        
        if(commandName.equals("Cancel")){
            System.out.println(" -- actionPerformed Cancel");
            this.closeDialog();
            return;
        }

    }//End of actionPerformed
    private void closeDialog(){
        this.dialog.setVisible(false);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        Component component=menuUtil.getMenuComponent(this.dialog.getName());
        if(component!=null) menuUtil.removeMenuComponent(component);
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
} // end of class