package shape;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;
import javax.imageio.ImageIO;
import java.io.*;
import java.util.*;
import DrawTop.*;
import geomExtension.*;
import util.*;

public class ImageElement extends ShapeElement{

//ImageElement proper
    //private Rectangle2D startDraggedBox=null;
    private BufferedImage bufferedImage=null;
    
    public ImageElement(){
        super();
    }

//ShapeElement
    public int getTypeE(){
        return Command.IMAGE;
    }
     public String getShapeIdString(){
         return "Image";
     }

    public Rectangle2D createTextArea(){
        return null;
    }

    public Image getBufferedImage(){
        return this.bufferedImage;
    }   

    public byte[] getByteImage(){
        byte[] byteData=null;
        if(this.bufferedImage==null) return null;
        try {
            int w = this.bufferedImage.getWidth(null);
            int h = this.bufferedImage.getHeight(null);
            if (bufferedImage.getType() != BufferedImage.TYPE_INT_RGB) {
                BufferedImage bi=new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
                Graphics g=bi.getGraphics();
                g.drawImage(this.bufferedImage, 0, 0, null);
                this.bufferedImage = bi;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write(bufferedImage, "JPG", outputStream);
            byteData=outputStream.toByteArray();
        } catch (IOException e) {
            System.out.println("*** Error ImageElement: Image could not be write");
        }
        return byteData;
    }   
    
    public void setByteImage(byte[] byteData){
        if(byteData==null) return;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteData);
             this.bufferedImage = ImageIO.read(inputStream);
        } catch (IOException e) {
            System.out.println("*** Error ImageElement: Image could not be read");
        }
    }  

//ShapeElement
    public SegmentModifier[] getSegmentModifiers(){
        SegmentModifier[] modifiers=new SegmentModifier[0];
        return modifiers;
    }
//ShapeElement
    public Point2D[] getModifierPTs(){
        Point2D[] PTs=new Point2D[0];
        return PTs;
    }

//ShapeElement
    public void create(Point2D startPoint, Point2D currentPoint){}
    public void create(Rectangle2D boundingBox){
        double X=boundingBox.getX(); double Y=boundingBox.getY();
        double Width=boundingBox.getWidth(); double Height=boundingBox.getHeight();
        this.curve2D=new Rectangle2DE(X, Y, Width, Height);
    }
    public void create(Point2D[] points){}

//ShapeElement
    public int getControlPTIndex(Point2D point){
        return -1;
    }

//ShapeElement
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint){};
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint){};
    public void modify(int ctrl, Point2D oldPoint, Point2D newPoint){}
    public void modifyPoint(Point2D point, String command){}
    //public int deletePoint(Point2D point){return 0;}
//ShapeElement
    public Object clone(){
        ImageElement imageElement=new ImageElement();
        Rectangle2DE curve=(Rectangle2DE)curve2D.clone();
        imageElement.setCurve2D(curve);
        byte[] image=this.getByteImage();
        imageElement.setByteImage(image);
        return imageElement;
    }
    
//ShapeElement
    public String toString(){
        String str="";
        if (this.curve2D == null) {
            str += "Image: not defined";
            return str;
        }

        Rectangle2DE rectangle=(Rectangle2DE)this.curve2D;
        double x=rectangle.getX();
        double y=rectangle.getY();
        double width=rectangle.getWidth(); 
        double height=rectangle.getHeight();
        str="Rectangle x,y=("+String.valueOf((int)x)+","+String.valueOf((int)y)+")"
                +" width,height="+String.valueOf((int)width)+","+String.valueOf((int)height);
        return str;
    }


}