/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package shape;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.border.Border.*;
import geomExtension.*;
import DrawTop.*;

public class TempShapeManager {
    Vector tempShapeVector=new Vector();
    int debug=0;

    public TempShapeManager(){}

    public void drawTempShape(Graphics g){
        Graphics2D g2=(Graphics2D)g;
        Color currentColor=g2.getColor();
        Stroke currentStroke=g2.getStroke();
        double scale=DrawParameters.getScale();
        int size=this.tempShapeVector.size();
        if( debug>0) System.out.println("drawTempShape size="+size);
        if(size==0) return;
        for(int i=0;i<size;i++){
            TempShape temp=(TempShape)this.tempShapeVector.get(i);
            Shape shape=temp.shape;
            if(shape!=null) {
                if(temp.fillColor!=null){
                    currentColor=g2.getColor();
                    g2.setColor(temp.fillColor);
                    g2.fill(shape);
                    g2.setColor(currentColor);
                }
                Stroke stroke=temp.stroke;
                currentStroke=g2.getStroke();
                if(stroke!=null) g2.setStroke(stroke);
                g2.setColor(temp.lineColor);
                g2.draw(shape);
                g2.setStroke(currentStroke);
            }
            String str=temp.message;
            if(str!=null&&!str.equals("")){
                Point2D stringPosition=temp.messagePoint;
                float x=(float)stringPosition.getX();
                float y=(float)stringPosition.getY();
                g2.setColor(temp.messageColor);
                g2.setFont(temp.messageFont);
                g2.drawString(str, x, y);
            }
        }
        g2.setColor(currentColor);
    }

    public void addTempShape(TempShape tempShape){
        this.tempShapeVector.add(tempShape);
        int size=this.tempShapeVector.size();
        if(size>100){
            System.out.println("*** Warning TempShapeManager.addTempShape: Num of marks="+size);
            System.out.println(this.toString());
            System.err.println("*** Warning TempShapeManager.addTempShape: Num of marks="+size);
            System.err.println(this.toString());
        }
    }

    public void clearTempShape(String id){
        if(debug>0) System.out.println("clearTempShape id="+id);

        while(true){
            boolean removed=false;
            for(int i=0;i<this.tempShapeVector.size();i++){
                TempShape drawMark=(TempShape)this.tempShapeVector.get(i);
                if(drawMark.id.equals(id)){
                    this.tempShapeVector.remove(drawMark);
                    removed=true;
                }
            }
            if(!removed) break;
        }
    }

    public void removeTempShape(String id, Point2D point){
        if(debug>0) System.out.println("removeTempShape id="+id);
        while(true){
            boolean removed=false;
            for(int i=0;i<this.tempShapeVector.size();i++){
                TempShape drawMark=(TempShape)this.tempShapeVector.get(i);
                Rectangle2D rect=drawMark.shape.getBounds2D();
                Point2D tempPoint=new Point2D.Double(rect.getX()+0.5*rect.getWidth(),
                        rect.getY()+0.5*rect.getHeight());
                double dist=Vector2D.dist(point, tempPoint);
                if(drawMark.id.equals(id)&&dist<DrawParameters.ConnectionSmallTolerance){
                    this.tempShapeVector.remove(drawMark);
                    removed=true;
                }
            }
            if(!removed) break;
        }
    }

    public void clearAllTempShapes(){
        if(debug>0) System.out.println("TempShapeManager.clearAllTempShape");
        this.tempShapeVector.clear();
    }

    public String toString(){
        Vector<String> strVector=new Vector<String>();
        Vector<Integer> countVector=new Vector<Integer>();
        for (int i = 0; i < this.tempShapeVector.size(); i++) {
            TempShape tempShape = (TempShape) this.tempShapeVector.get(i);
            int jsave=-1;
            for(int j=0;j<strVector.size();j++){
                if (tempShape.getId().equals(strVector.get(j))) {
                    jsave=j;
                    break;
                }
            }
            if(jsave<0){
                strVector.add(tempShape.getId());
                countVector.add(new Integer(1));
            } else {
                int count=countVector.get(jsave).intValue();
                count++;
                countVector.set(jsave, new Integer(count));
            }
        }
        String str="";
        str=" TempShapeManager num. of tempShapes="+this.tempShapeVector.size()+" "  ;
        for(int i=0;i<strVector.size();i++){
            str+="id:"+strVector.get(i)+" num:"+countVector.get(i);
            if(i<strVector.size()-1) str+=",  ";
        }
        return str;
    }
}
