
package shapeUtil;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import geomExtension.*;
import textBox.TextBox;
import util.*;


public class CutShape extends JDialog implements SelectionListener{
    CutShapeAction action=null;
    JLabel messageLabel1;
    JLabel messageLabel2;
    JButton goButton=null;
    JButton repeatButton=null;
    JButton cancelButton=null;
    JPanel selectPanel=null;
    JRadioButton yesButton=null;
    JRadioButton noButton=null;
    Vector shapeVector=new Vector();
    int debug=0;
    
    
    public CutShape(){
        super(ObjectTable.getDrawMain(), "cut shape");
        this.setName("cut shape");  
        this.action=new CutShapeAction(this);
        this.createDialog();
        //this.main=this;
    }
    
    public void createDialog(){
        //this.dialog=new JDialog(ObjectTable.getDrawMain(), "cut shape");
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+10, owner.getY()+80);
        this.setLocation(centerP);
      //set window listener  
        //this.addWindowListener(this);
        this.addWindowListener(action);
        //set SelectionListener
        SelectionLS selectionLS=ObjectTable.getSelectionLS("CutShape");
      //------------------------------------------//  
        selectionLS.addSelectionListener(this);
      //------------------------------------------//
        
        Container contentPane=this.getContentPane();
        Box box=Box.createVerticalBox();
        contentPane.add(box);
        
        JPanel messagePanel=new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Dimension messagePanelSize=new Dimension(300,80);
        messagePanel.setPreferredSize(messagePanelSize);
        GridLayout basePanelLayout=new GridLayout(3,1);
        basePanelLayout.setHgap(20);
        basePanelLayout.setVgap(5);
        messagePanel.setLayout(basePanelLayout);
        JLabel instructionLabel=new JLabel(" Click two shapes i.e. target and cutter !");
        this.messageLabel1=new JLabel(" ");
        this.messageLabel2=new JLabel(" ");
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        Dimension messageDimension=new Dimension(300, 14);
        this.messageLabel1.setPreferredSize(messageDimension);
        this.messageLabel2.setPreferredSize(messageDimension);
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
/*
        JLabel messageLabel=new JLabel(" ");
        this.messageLabel=messageLabel;
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel);
*/
    //OK, Cancel Button    
        JPanel buttonPanel=new JPanel();
        this.goButton=new JButton("GO !");
        this.repeatButton=new JButton("Repeat");
        this.cancelButton=new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.repeatButton.setEnabled(false);
        goButton.setActionCommand("Go");
        repeatButton.setActionCommand("Repeat");
        cancelButton.setActionCommand("Cancel");
        //ComputeDistanceAction action=new ComputeDistanceAction();
        goButton.addActionListener(action);
        repeatButton.addActionListener(action);
        cancelButton.addActionListener(action);
        buttonPanel.add(goButton);
        buttonPanel.add(repeatButton);
        buttonPanel.add(cancelButton);
        
     //Button group
        this.selectPanel=new JPanel();
        GridLayout selectPanelLayout=new GridLayout(1,2);
        selectPanelLayout.setHgap(20);
        selectPanelLayout.setVgap(5);
        selectPanel.setLayout(selectPanelLayout);
        ButtonGroup group = new ButtonGroup();
        this.yesButton = new JRadioButton("yes");
        this.noButton = new JRadioButton("no");
        group.add(this.yesButton);
        group.add(this.noButton);
        this.noButton.setSelected(true);
        selectPanel.add(this.yesButton);
        selectPanel.add(this.noButton);
        this.setSelectPanelEnable(false);
        selectPanel.setMaximumSize(new Dimension(150,40));
        
// layout the dialog
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(selectPanel);
    }
    
    public void showDialog(){
        this.pack();
        this.setVisible(true);
        showMessage("  Click target shape!", Color.BLUE);
        
        ContainerManager containerManager=ObjectTable.getContainerManager("CutShape");
        this.shapeVector.clear();
        ShapeContainer[] containers=containerManager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    protected void setSelectPanelEnable(boolean enable){
        TitledBorder selectPanelBorder=BorderFactory.createTitledBorder("Cut both shapes ?");
        if(enable) selectPanelBorder.setTitleColor(Color.BLACK);
        else selectPanelBorder.setTitleColor(Color.LIGHT_GRAY);
        this.selectPanel.setBorder(selectPanelBorder);
        this.yesButton.setEnabled(enable);
        this.noButton.setEnabled(enable);
        this.selectPanel.revalidate();
    }
    
    public void showMessage(String message, Color color){
        //System.out.println(" -- showMessage message="+message);
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index=message.indexOf("\n");
        String str1=message;
        String str2="";
        if(index>0){
            str1=message.substring(0, index);
            if(index+1<message.length()){
                str2=message.substring(index+1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }
/*
    protected void showMessage(String message, Color color){
        this.messageLabel.setForeground(color);
        this.messageLabel.setFont(DrawParameters.Font12Bold);
        this.messageLabel.setText(message);
    }
*/
    public MouseHitShape[] getClickedShapes(){
        int size=this.shapeVector.size();
        MouseHitShape[] shapes=new MouseHitShape[size];
        for(int i=0;i<size;i++){
            shapes[i]=(MouseHitShape)this.shapeVector.get(i);
        }
        return shapes;
    }

    public void selected(SelectionEvent event){
        //String type=event.getType();
        Point2D point=event.getClickedPoint();
        ShapeContainer[] containers=event.getSelectedContainers();
        int len=containers.length;
        if(len>1){
            showMessage(" Error.  Select one by one!.", Color.RED);
            return;
        }
        ShapeContainer container=containers[0];
        if(this.debug>0) System.out.println("CutShape.selected  container="+container+", point="+point);
      //check shape type
        if(!this.isSuitable(container)) return;
        
        if(this.shapeVector.size()==0) {
            showMessage(" Target accepted =>Click cutter.", Color.BLUE);
            DrawShapeUtil.drawTempShape("CutShape", point, DrawParameters.Mark_SmallSize,
                    "target", Color.RED);
        }
        if(this.shapeVector.size()==1) {
            if(isDuplicated(container)>=0){
                showMessage(" Error! selected cutter equals target. "
                        + "\n Select other shape for cutter !", Color.RED);
                return;
            } else{
                showMessage(" Cutter accepted => Go ! or Cancel", Color.BLUE);
                DrawShapeUtil.drawTempShape("CutShape", point, DrawParameters.Mark_SmallSize,
                    "cutter", Color.RED);
                this.goButton.setEnabled(true);
                this.setSelectPanelEnable(true);
            }
        }
        if(this.shapeVector.size()>=2){
            showMessage(" Target and cutter are selected. \n  Press Go ! or Cancel.", Color.BLUE);
            return;
        }
      // save ClickedData
        MouseHitShape clickedShape=new MouseHitShape(container, point);
        this.shapeVector.add(clickedShape);   
    }

    private boolean isSuitable(ShapeContainer container){
        boolean suitable=true;
        if(container.getContainerType()==ShapeContainer.GROUP){
            showMessage(" Error: Clicked shape is group, Click single shape !", Color.RED);
            suitable=false;
            return suitable;
        }
        ShapeContainer shapeContainer=(ShapeContainer)container;
        int type=shapeContainer.getElement().getTypeE();
        if(type<Command.AUTO_SHAPE_FIRST||type>Command.AUTO_SHAPE_LAST){
            showMessage(" Error: Not shape, Click again !", Color.RED);
            suitable=false;
            return suitable;
        }
        if(shapeContainer.isCommittedText()){
            showMessage(" Error: Clicked shape has comitted text. "
                    + "Repeat this process?", Color.RED);

            int returnCode = JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(),
                    "Clicked shape has comitted text.\n "
                    + "Remove the text and\ncontinue this process?"
                    , "", JOptionPane.YES_NO_OPTION);
            if (returnCode == JOptionPane.NO_OPTION) {
                suitable=false;
                return false;
            } else{
                suitable=true;
                TextBox textBox=shapeContainer.getTextBox();
                shapeContainer.deleteTextBox();
                textBox.setShapeContainer(null);
            }
        }
        return suitable;
    }
    
    private int isDuplicated(ShapeContainer container){ 
        int size=this.shapeVector.size();
        int isave=-1;
        for(int i=0;i<size;i++){
            MouseHitShape clickedShape=(MouseHitShape)this.shapeVector.get(i);
            String id=clickedShape.getShapeContainer().getShapeId();
            if(container.getShapeId().equals(id)){
                isave=i;
                break;
            }
        }
        return isave;
    }

    private void closeDialog(){
        this.setVisible(false);
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
      //-------------------------------// 
        DrawShapeUtil.clearAllTempShapes();
        drawPanel.repaint();
      //-------------------------------// 
        this.setVisible(false);
      //-----------------------------------------------------//  
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this);
      //-----------------------------------------------------//
        return;
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        if(this.debug>0)System.out.println("CutShape windowClosing");
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
    
} //end of DialogOfConnectCurves

//**** CutShapeAction ****
class CutShapeAction extends AbstractAction implements WindowListener {
    //CrossCurvePT[] crossPTs=null;
    CutShape dialog=null;
    Vector vector=new Vector();
    int debug=0;
    
    public CutShapeAction(CutShape dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {
        //int debug=MenuUtil.debug;
        int debug=0;
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- CutShapeAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);

        if(commandName.equals("Go")){
            //this.cut();
            this.cutShapes();
            this.endProcess();
            ObjectTable.getDrawPanel().repaint("cut shape");
            return;   
        }
        
        if(commandName.equals("Repeat")){
            this.dialog.showMessage("  Click target shape !", Color.BLUE);
            this.repeatProcess();
             return;   
        }
        if(commandName.equals("Cancel")){
            this.closeDialog();
            return;
        }
    }//End of actionPerformed
//**** cutShapes
    private void cutShapes(){
        MouseHitShape[] clickedShapes=this.dialog.getClickedShapes();
        for(int i=0;i<clickedShapes.length;i++){
             clickedShapes[i].getShapeContainer().setSelected(false);
        }

        ShapeContainer shapeContainer1=clickedShapes[0].getShapeContainer();
        ShapeContainer shapeContainer2=clickedShapes[1].getShapeContainer();
        if(debug>0) {
            System.out.println("** Cut shape: "+shapeContainer1.toShortString());
            System.out.println("** Cutting shape: "+shapeContainer2.toShortString());
        }
        Curve2D[] curve1=new Curve2D[1];
        Curve2D[] curve2=new Curve2D[1];
        curve1=this.getPathCurves(shapeContainer1.getElement().getCurve2D());
        curve2=this.getPathCurves(shapeContainer2.getElement().getCurve2D());
        
      //-------------------------------------------------------------//
        CrossCurvePT[] crossPTs=this.getIntersections(curve1, curve2);
      //-------------------------------------------------------------//  

        ContainerManager containerManager=ObjectTable.getContainerManager("");
      //------------------------------------//
        containerManager.undoSetupStart();
      //-------------------------------------//
        TrimmedCurve[] trimmedCurves=this.cutTargetCurves(crossPTs, curve1);
        ShapeContainer[] containers=this.createContainers(shapeContainer1, trimmedCurves);
        for(int i=0;i<containers.length;i++){
            containerManager.addContainer(containers[i]);
            containers[i].setSelected(true);
            containers[i].setConnectorPermission(false);
        }
        containerManager.deleteContainer(shapeContainer1);

        if(this.dialog.yesButton.isSelected()){
            crossPTs=this.getExchangedData(crossPTs);
            trimmedCurves=this.cutTargetCurves(crossPTs, curve2);
            containers=this.createContainers(shapeContainer2, trimmedCurves);
            for(int i=0;i<containers.length;i++){
                containerManager.addContainer(containers[i]);
                containers[i].setSelected(true);
                containers[i].setConnectorPermission(false);
            }
            containerManager.deleteContainer(shapeContainer2);
        }

      //--------------------------------//  
        containerManager.undoSetupEnd();
      //--------------------------------//

    }

//**** getIntersections
    private CrossCurvePT[] getIntersections(Curve2D[] curve1, Curve2D[] curve2){
        this.vector.clear();
        for(int i=0;i<curve1.length;i++){
            for(int j=0;j<curve2.length;j++){
                CrossCurvePT[] crossPTs=Curve2DUtil.getIntersectionPts(curve1[i], curve2[j]);
                for(int k=0;k<crossPTs.length;k++) this.vector.add(crossPTs[k]);
            }
        }
        int length=this.vector.size();
        CrossCurvePT[] crossPTs=new CrossCurvePT[length];
         for(int i=0;i<length;i++){
            crossPTs[i]=(CrossCurvePT)this.vector.get(i);
        }
         for(int i=0;i<length;i++){
            DrawShapeUtil.drawTempShape("CutShape",crossPTs[i].getP1(),
                    DrawParameters.Mark_SmallSize, "", Color.BLUE);
        }
        return crossPTs;
    }
//**** getPathCurves
    private Curve2D[] getPathCurves(Curve2D curve){
        Curve2D[] curves=new Curve2D[0];
        if(curve.getType2DE()==Command.GENERAL_CURVE){
            GeneralCurve2DE gcurve=(GeneralCurve2DE)curve;
            curves=gcurve.getSubPaths();
        } else {
            curves=new Curve2D[1];
            curves[0]=curve;
        }
        return curves;
    }
//**** getExchangedData
    private CrossCurvePT[] getExchangedData(CrossCurvePT[] crossPTs){
        int size=0;
        if(crossPTs!=null) size=crossPTs.length;
        CrossCurvePT[] newCrossPTs=new CrossCurvePT[size];
        for(int i=0;i<size;i++){
            CrossCurvePT newCrossPT=crossPTs[i].getReversedOrderData();
            newCrossPTs[i]=newCrossPT;
        }
        return newCrossPTs;
    }
//**** cutTargetCurves
    private TrimmedCurve[] cutTargetCurves(CrossCurvePT[] crossPTs, 
            Curve2D[] targetCurves){
        int size=0;
        if(crossPTs!=null) size=crossPTs.length;
        double[] crossT=new double[size];
        for(int i=0;i<size;i++){
           crossT[i]=crossPTs[i].getParameterT1();
        }
        Vector curveVector=new Vector();
        for(int i=0;i<targetCurves.length;i++){
          //-------------------------------------------------------------//
            double[] cutParams=this.getCutParams(targetCurves[i], crossPTs);
          //-------------------------------------------------------------//
            double t1, t2;
			Curve2D[] trimmedCurves=new Curve2D[cutParams.length-1];
            for(int j=0;j<cutParams.length-1;j++){
                t1=cutParams[j];
                t2=cutParams[j+1];
                trimmedCurves[j]=Curve2DUtil.trimCurve2D(targetCurves[i], t1, t2);
				if( trimmedCurves[j]!=null){
					TrimmedCurve trimmedCurve=new TrimmedCurve(targetCurves[i], t1, t2, trimmedCurves[j]);
					curveVector.add(trimmedCurve);
				}
            }
			if(this.debug>0) printTrimCurveInfo(targetCurves[i], trimmedCurves, crossPTs, cutParams);
        }
        TrimmedCurve[] trimmedCurves=new TrimmedCurve[curveVector.size()];
        for(int i=0;i<curveVector.size();i++){
            trimmedCurves[i]=(TrimmedCurve)curveVector.get(i);
        }
        return trimmedCurves;
    }
	
	private void printTrimCurveInfo(Curve2D targetCurve, Curve2D[] trimmedCurves, 
			CrossCurvePT[] selectedCrossPTs, double[] cutParams){
		String str="*** Print TrimCurveInfo";
		str+="* targetCurve: "+targetCurve.toString()+"\n";
		str+="-- selectedCrossPTs";
        for(int i=0;i<selectedCrossPTs.length;i++){
			str+="\n  No="+i+" "+selectedCrossPTs[i].toString();
        }
		str+="\n-- cutParams\n  ";
        for(int i=0;i<cutParams.length;i++){
			if(i>0) str+=", ";
			str+="cutParams["+i+"]="+Util.Num(cutParams[i]);
        }
		str+="\n-- trimmedCurves\n";
		for(int i=0;i<trimmedCurves.length;i++){
			if(trimmedCurves[i]==null) str+="  No="+i+" NULL";
			else str+="  No="+i+" "+trimmedCurves[i].toString()+"\n";
		}
		System.out.println(str);
        //return str;
	}
//**** createContainers
    private ShapeContainer[] createContainers(ShapeContainer targetContainer, 
            TrimmedCurve[] trimmedCurves){
        ShapeContainer[] trimmedContainers=new ShapeContainer[trimmedCurves.length];
        ContainerManager manager=ObjectTable.getContainerManager();
        for(int i=0;i<trimmedCurves.length;i++){
            ShapeElement trimmedElement=null;
            trimmedContainers[i]=new ShapeContainer();
            Curve2D trimmedCurve=trimmedCurves[i].getTrimmedCurve();
			if(trimmedCurve==null) continue;
            if(trimmedCurve.getType2DE()==Command.LINE) trimmedElement=new LineElement();
            if(trimmedCurve.getType2DE()==Command.POLYLINE) trimmedElement=new PolylineElement();
            if(trimmedCurve.getType2DE()==Command.CUBIC_CURVE) trimmedElement=new CubicCurveElement();
            if(trimmedCurve.getType2DE()==Command.GENERAL_CURVE) trimmedElement=new GeneralCurveElement();
            trimmedElement.setCurve2D(trimmedCurve);
            trimmedContainers[i].setElement(trimmedElement);
            PaintStyle paintStyle=targetContainer.getPaintStyle();
            trimmedContainers[i].setPaintStyle((PaintStyle)paintStyle.clone());
            trimmedContainers[i].setNewShapeId(manager, false);
        }
        if(debug>0){
            System.out.println("** createContainers");
            for(int i=0;i<trimmedContainers.length;i++){
                System.out.println(" -- TrimmedShape i="+i+", "+trimmedContainers[i].toShortString());
            }
        }
        return trimmedContainers;
    }
//**** getCutParams
    private double[] getCutParams(Curve2D targetCurve, CrossCurvePT[] crossPTs){
        this.vector.clear();
        for(int i=0;i<crossPTs.length;i++){
            if(crossPTs[i].getCurve1().equals(targetCurve)){
                this.vector.add(crossPTs[i]);
            }
        }
        int size=this.vector.size();
        CrossCurvePT[] selectedCrossPTs=new CrossCurvePT[size];
        double[] selectedCrossParams=new double[size];
        for(int i=0;i<size;i++){
            selectedCrossPTs[i]=(CrossCurvePT)this.vector.get(i);
            selectedCrossParams[i]=selectedCrossPTs[i].getParameterT1();
        }

        double[] sortedCrossParms=new double[size];
        for(int i=0;i<size;i++) sortedCrossParms[i]=selectedCrossParams[i];
        if(size>1) Util.simpleSort(sortedCrossParms);

        boolean closed=targetCurve.isClosed();
        double[] cutParms=null;
        if(closed){
            if(sortedCrossParms.length>=2){
                cutParms=new double[sortedCrossParms.length+1];
                for(int i=0;i<sortedCrossParms.length;i++) cutParms[i]=sortedCrossParms[i];
                cutParms[sortedCrossParms.length]=sortedCrossParms[0]; //???
            } else {
                cutParms=new double[2];
                cutParms[0]=0;
                cutParms[1]=targetCurve.getNumOfSegments();
            }
        } else{
            cutParms=new double[sortedCrossParms.length+2];
            cutParms[0]=0;
            cutParms[sortedCrossParms.length+1]=targetCurve.getNumOfSegments();
            for(int i=0;i<sortedCrossParms.length;i++) cutParms[i+1]=sortedCrossParms[i];
        }

        return cutParms;
    }

    private void endProcess(){
        ContainerManager manager=ObjectTable.getContainerManager("");
      //---------------------------------------------------------//  
        ShapeContainer[] containers=manager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
      //-----------------------------------------------------------//
        this.dialog.showMessage("  Done.", Color.BLUE);
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(true);
      //----------------------------------------------------//
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
      //-----------------------------------------------------//
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }
    
    private void repeatProcess(){
      //-----------------------------------------// 
        DrawShapeUtil.clearTempShape("CutShape");
      //-----------------------------------------//  
        ContainerManager manager=ObjectTable.getContainerManager("CutShape");
        ShapeContainer[] containers=manager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++ ) containers[i].setSelected(false);
        this.dialog.shapeVector.clear();
      //-----------------------------------------------------------//
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(false);
        this.dialog.setSelectPanelEnable(false);
        this.dialog.shapeVector.clear();
      //----------------------------------------------------//
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
        selectionLS.addSelectionListener(this.dialog);
      //-----------------------------------------------------//
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }
    
    private void closeDialog(){
        this.dialog.setVisible(false);
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
      //-------------------------------// 
        DrawShapeUtil.clearAllTempShapes();
        drawPanel.repaint();
      //----------------------------------------------------// 
        this.dialog.setVisible(false);
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
      //----------------------------------------------------//  
        selectionLS.removeSelectionListener(this.dialog);
      //----------------------------------------------------//
        return;
    }

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        if(this.debug>0)System.out.println("CutShapeAction windowClosing");
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

} // end of class

class TrimmedCurve{
    protected Curve2D trimmedCurve=null;
    protected Curve2D originalCurve=null;
    protected double t1;
    protected double t2;
    public TrimmedCurve(Curve2D originalCurve, double t1, double t2, Curve2D trimmedCurve){
        //this.trimmedCurve=Curve2DUtil.trimCurve2D(originalCurve, t1, t2);
        this.originalCurve=originalCurve;
		this.trimmedCurve=trimmedCurve;
        this.t1=t1;
        this.t1=t2;
    }
    
    public Curve2D getTrimmedCurve(){
        return this.trimmedCurve;
    }
}