package shapeUtil;

import java.awt.geom.*;
import DrawTop.*;
import shape.*;
import geomExtension.*;
import util.*;

public class MouseHitShape{
    private ShapeContainer shapeContainer=null;
    private Point2D mousePosition=null;
    
    public MouseHitShape(ShapeContainer shapeContainer, Point2D mousePosition){
        this.shapeContainer=shapeContainer;
        this.mousePosition=mousePosition;
    }
    
    public ShapeContainer getShapeContainer(){
        return this.shapeContainer;
    }
    
    public Point2D getMousePosition(){
        return this.mousePosition;
    }
    
    public double getCurveParameter(){
        double parameter=-1.0;
        Curve2D curve=this.shapeContainer.getElement().getCurve2D();
        CurvePT curvePT=Curve2DUtil.getShortestLine(this.mousePosition, curve);
        parameter=curvePT.getParameter();
        return parameter;
    }
    
    public int getEndIndexCloseToMouse(){
        Curve2D curve=this.shapeContainer.getElement().getCurve2D();
        int numSeg=curve.getNumOfSegments();
        Point2D p0=curve.getP(0);
        Point2D p1=curve.getP(numSeg);
        int index=0;
        double d0=Vector2D.dist(p0,this.getMousePosition());
        double d1=Vector2D.dist(p1,this.getMousePosition());
        if(d1<d0) index=1;
        return index;
    }
    
    public String toString(){
        String str="";
        str+="SelectedShape  shapeContainer="+this.shapeContainer.toShortString()+
                ", MousePosition="+Util.Pt(this.mousePosition);
        return str;
    }
}
