package util;

import java.io.*;
import java.util.*;

public class ConfigFile{
   private Properties properties;
   private String fileName;

   public ConfigFile(){
      properties = new Properties();
   }

   public void setFileName(String fileName){
      this.fileName=fileName;
   }

   
   public void load() throws IOException{
      FileInputStream fileInputStream;
      try{
         fileInputStream = new FileInputStream(this.fileName);
      } catch(FileNotFoundException e){
         throw new IOException("Cannot open file:" + this.fileName);
      }
      this.properties.load(fileInputStream);
      fileInputStream.close();      
   }

   public void save() throws IOException{
      FileOutputStream fileOutputStream;
      try{
         fileOutputStream = new FileOutputStream(this.fileName);
      } catch(FileNotFoundException e){
         throw new IOException("Cannot create file:" + this.fileName);
      }
      this.properties.store(fileOutputStream, "");
      fileOutputStream.close();      
   }

   public String getValue(String sKey){
      return this.properties.getProperty(sKey);
   }

   public void putValue(String sKey, String sValue){
      this.properties.put(sKey, sValue);
   }

   public Enumeration getKeys(){
      return this.properties.propertyNames();
   }
}
