package util;

import java.io.*;
import java.util.*;
import java.util.Arrays;

public class SysErrOutput {
    private String directoryName="/ErrorRecords";
    PrintStream printStream=null;
    File currentFile=null;
	String currentFilePath="";
    public static int debug=0;
    
    public SysErrOutput(){}

    public void openErrorFile(){
		this.currentFilePath = this.createFileName();
		File file = new File(this.currentFilePath);
		if (file.exists()) {
			System.out.println("** SysErrOutput openErrorFile file already exists");
			this.currentFile = file;
		} else {
			try {
				boolean created = file.createNewFile();
				System.out.println("** SysErrOutput openErrorFile created=" + created);
				this.currentFile = file;
			} catch (Exception e) {
				System.err.println("*** Error: ErrorFileIO.openErrorFile "
						+ "filePath=" + this.currentFilePath + "\n  e=" + e);
				return;
			}
		}
		this.printStream = this.openFile(this.currentFilePath);
		return;
	} //fileNew

    public boolean getDirectory(){
        File dir = new File("");
        String currentPath=dir.getAbsolutePath();
        String dirPath=currentPath+this.directoryName;
        dir=new File(dirPath);
        if(!dir.isDirectory() ){
            try{
                dir.mkdir();
            } catch(Exception e){
                System.out.println("*** Error: ErrorFileIO getDirectory, " +
                        "mkdir()");
                return false;
            }
        }
        return true;
    } //fileNew

    public String createFileName(){
        File file = new File("");
        String currentPath=file.getAbsolutePath();
        String filePath=currentPath+this.directoryName;
        Calendar cal = Calendar.getInstance();
        int yy=cal.get(Calendar.YEAR);
        int mm=cal.get(Calendar.MONTH)+1;
        int dd=cal.get(Calendar.DATE);
        System.out.println("Calender yy="+yy+", mm="+mm+", dd="+dd);
        int hour=cal.get(Calendar.HOUR_OF_DAY);
        int min=cal.get(Calendar.MINUTE);
        int sec=cal.get(Calendar.SECOND);
        String mmstr=String.valueOf(mm);
        if(mmstr.length()==1) mmstr="0"+mmstr;
        String ddstr=String.valueOf(dd);
        if(ddstr.length()==1) ddstr="0"+ddstr;
        String hoursrtr=String.valueOf(hour);
        if(hoursrtr.length()==1) hoursrtr="0"+hoursrtr;
        String minsrtr=String.valueOf(min);
        if(minsrtr.length()==1) minsrtr="0"+minsrtr;
        String secsrtr=String.valueOf(sec);
        if(secsrtr.length()==1) secsrtr="0"+secsrtr;
        String date=yy+""+mmstr+""+ddstr+"_"+hoursrtr+""+minsrtr+""+secsrtr;
        filePath+="/Errorfile_"+date+".txt";
        if(debug>0) System.out.println("createFileName="+filePath);
        return filePath;
    }
 
    public PrintStream openFile(String filePath){
        PrintStream printStream=null;
        try{
            printStream=new PrintStream(this.currentFile);
            System.setErr(printStream);
        } catch(Exception e){
            System.out.println("*** Error: FileIO.fileOpen e="+e);
            e.printStackTrace();
            return null;
        }
        return printStream;
    } //fileOpen

    public boolean closeFile(){
		System.out.println("** SysErrOutput closeFile called");
        try{
            this.printStream.close();
            System.out.println("this.printStream.close");
        } catch(Exception e){
            System.out.println("*** Error: FileIO.closeFile e="+e);
            e.printStackTrace();
            return false;
        }
        FileReader fileReader=null;
        char[] cbuf=new char[256];
        try {
			fileReader = new FileReader(this.currentFilePath);
            int n=fileReader.read(cbuf);
			String str=new String(cbuf);
			if(str.trim().equals("")) {
				System.out.println("currentFile deleted currentFile="+this.currentFile.getPath());
				boolean deleted=this.currentFile.delete();
				this.currentFile.deleteOnExit();
				System.out.println("this.currentFile deleted="+deleted
						+ ", exists="+this.currentFile.exists());
			}
			fileReader.close();
        } catch (IOException e) {
            System.out.println("*** Error: FileReader e=" + e);
        }
        
        return true;
    } 

} //End
