
package DrawTop;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import menu.*;
import shape.*;
import shapeUtil.*;
import util.*;


public class DrawMain extends JFrame{
    static int debug=0;
    public static void main(String[] args) {
        DrawMain drawMain=new DrawMain();
        JFrame jframe=drawMain;
		drawMain.setName("DrawMain-JFrame");
        ObjectTable.main=drawMain;
        DrawParameters parameters=new DrawParameters();
        drawMain.setFrame();
        if(debug>0) ObjectTable.menuUtil.printMenuComponentList();
    }
    
    void setFrame() {
        this.setTitle("DrawTop");
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//Window listeners 
        DrawWindowAdapter adaptor=new DrawWindowAdapter(this);
        this.addWindowListener(adaptor);
        this.addWindowFocusListener(adaptor);
        this.addWindowStateListener(adaptor);
//set Command
        new Command();
//set MenuUtil
        MenuUtil menuUtil=new MenuUtil();
        ObjectTable.menuUtil=menuUtil;

//GlassPane
        JPanel glassPane=(JPanel)this.getGlassPane();
        glassPane.setLayout(null);
        glassPane.setVisible(true);
        glassPane.setOpaque(false);
        ObjectTable.glassPane=glassPane;

//TabbedPane, StatusPanel
        Container contentPane=this.getContentPane();
		contentPane.setName("ContentPane");
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane=new JTabbedPane();
        ObjectTable.tabbedPane=tabbedPane;
        contentPane.add(tabbedPane, BorderLayout.NORTH);
        DrawMenu createMenu=new DrawMenu();
        JPanel homeTabPanel=createMenu.createHomeTabPanel();
        JPanel shapeTabPanel=createMenu.createShapeTabPanel();
        JPanel helpTabPanel=createMenu.createHelpTabPanel();
        tabbedPane.addTab("Home", homeTabPanel);
        tabbedPane.addTab("Shape", shapeTabPanel);
        tabbedPane.addTab("Help", helpTabPanel);
        StatusPanel statusPanel=new StatusPanel();
        ObjectTable.statusPanel=statusPanel;
        contentPane.add(statusPanel, BorderLayout.SOUTH);
        
//PopupMenu
		PopupPulldownMenu.createDrawPanelPopupMenu();
        PopupPulldownMenu.createSingleShapePopupMenu();
        PopupPulldownMenu.createGroupShapePopupMenu();
        PopupPulldownMenu.createTextBoxPopupMenu();
        
//DrawPanel, listenerPanel
        //TempShapeManager
        ObjectTable.tempShapeManager=new TempShapeManager();
        ListenerPanel listenerPanel=new ListenerPanel();
        ObjectTable.listenerPanel=listenerPanel;
        DrawPanel drawPanel=(DrawPanel)listenerPanel;
        ObjectTable.drawPanel=drawPanel;
        
//ScrollPane//ScrollPane
        JScrollPane scrollPane=new JScrollPane();
		scrollPane.setName("ScrollPane");
        ObjectTable.scrollPane=scrollPane;
        scrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        JViewport viewport=new JViewport();
        ObjectTable.viewport=viewport;
		viewport.setName("ViewPort");
        viewport.setOpaque(false);
		JPanel viewPanel = (JPanel) drawPanel.getParent();
		if (viewPanel == null) {
			viewPanel = new JPanel();
			viewPanel.setName("ViewPanel");
			viewPanel.add(drawPanel, 0);
			viewPanel.setOpaque(true);
			viewPanel.setBackground(Color.LIGHT_GRAY);
		}
        viewPanel.setAutoscrolls(true); 
        viewport.setView(viewPanel);
        scrollPane.setViewport(viewport);
        contentPane.add(scrollPane, BorderLayout.CENTER);
        Dimension screenSize=Toolkit.getDefaultToolkit().getScreenSize();
        double w0=screenSize.getWidth();
        double h0=screenSize.getHeight();
        double w=w0;
        double h=h0;
        int frameHeight=560;
        if(ObjectTable.videoCapture) frameHeight=480;
        if(h0>frameHeight){
            double scale=frameHeight/h0;
            w=screenSize.getWidth()*scale;
            h=screenSize.getHeight()*scale;
            System.out.println("Screen size w0="+0+", h0="+h0+", Screen w="+w+", h="+h);
        }
        screenSize.setSize(w, h);
        scrollPane.setPreferredSize(screenSize);
        
//ContainerManager
        ObjectTable.containerManager=new ContainerManager();
//Undo Manager
        UndoDrawManager undoDrawManager=new UndoDrawManager();
        ObjectTable.undoDrawManager=undoDrawManager;
//MousePositionLS
        ObjectTable.mousePositionLS=new MousePositionLS();
//ConnectionPoint
        ObjectTable.ConnectionLS=new ConnectionLS();
//SelectionLS
        ObjectTable.selectionLS=new SelectionLS();
//CreateAuxShape
        ObjectTable.createAuxShape=new CreateAuxShape();
//AutoAlignLS
        ObjectTable.moveResizeShapeLS=new MoveResizeShapeLS();

//FileIo, Edit
        ObjectTable.fileIo=new FileIo();
        ObjectTable.drawFileIo=new DrawFileIo();
        ObjectTable.edit=new Edit();
        ObjectTable.viewUtil=new ViewUtil();
        ObjectTable.sysErrOutput= new SysErrOutput();
        ObjectTable.sysErrOutput.openErrorFile();
//Command Processor and selection processor
        ObjectTable.execCommand=new ExecCommand();
        ObjectTable.execPopupMenu=new ExecPopupMenu();
//GuidancePanel
        GuidancePanel guidancePanel=new GuidancePanel();
        ObjectTable.guidancePanel=guidancePanel;
       
//Other components
        ObjectTable.componentLibDialog=new ComponentLibDialog();
        ObjectTable.buttonOfFontMenu = (ButtonOfFontMenu) menuUtil.getMenuComponent("font");
        ObjectTable.customColorChooserDialog=new CustomColorChooserDialog(this);
        ObjectTable.blinkingShape=new BlinkingShape(drawPanel);
		
        this.pack();
        this.setVisible(true);
        ObjectTable.fileIo.fileNew();
    }
} //End of DrawMain

class DrawWindowAdapter extends WindowAdapter{
    Window window=null;
    
    DrawWindowAdapter(Window window){
        this.window=window;
    }
    public void windowClosing(WindowEvent e){
		System.out.println("windowClosing called");
        ObjectTable.getSysErrOutput().closeFile();
		FileIo fileIo=ObjectTable.getFileIo();
		int ret=fileIo.saveCurrentFile();
		//ret: saved=0, unsaved=1, canceled=2
		if(ret==JOptionPane.YES_OPTION){
			String fileName=fileIo.getFileInformation().getSimpleFileName(fileIo.getCurrentFilePath());
			String message="The current file was saved as \""+fileName+".\" => Exit";
			JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message);
		}
    }
    public void windowActivated(WindowEvent e){
        this.window.repaint();
    }

    public void windowGainedFocus(WindowEvent e){
        this.window.repaint();
    }
    
    public void windowLostFocus(WindowEvent e){
        this.window.repaint();
    }
    
}