/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package DrawTop;

import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import shape.*;
import shapeUtil.*;
import textBox.*;
import util.*;

public class ExecCommandUtil {

    ContainerManager containerManager = ObjectTable.getContainerManager("");
    DrawPanel drawPanel = ObjectTable.getDrawPanel("");
    SelectionLS selectionLS = ObjectTable.getSelectionLS("");

    int debug=0;

    public ExecCommandUtil(){
    }

    public void addTextBox(ShapeContainer[] containers){
        if(containers.length==0) return;
        int result = this.checkTextBox(containers, "add");
        if (result > 0) {
            return;
        }
        //------------------------------------------------//
        this.containerManager.undoSetupStart(containers);
        //------------------------------------------------//
        for(int i=0;i<containers.length;i++){
            containers[i].addTextBox();
            containers[i].setChangeCode(UndoConstants.CONTAINER);
        }
        containers[0].makeTextBoxEditable(true);
        //-------------------------------//
        this.containerManager.undoSetupEnd();
       //-------------------------------//
       this.drawPanel.repaint("ExecCommand.Util");

    }

    public void deleteTextBox(ShapeContainer[] containers) {
        if(containers.length==0) return;
        int result = this.checkTextBox(containers, "delete");
        if (result > 0) {
            return;
        }
        String message = "Delete the textBox of the selected shape. \n Are you sure?";
        JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(),
                message);
        //-----------------------------------------//
        this.containerManager.undoSetupStart(containers);
        //-----------------------------------------//
        for(int i=0;i<containers.length;i++){
            containers[i].deleteTextBox();
            containers[i].setChangeCode(UndoConstants.CONTAINER);
        }
        //-------------------------------//
        this.containerManager.undoSetupEnd();
        //-------------------------------//
        this.drawPanel.repaint("ExecCommand.Util");

    }

    private int checkTextBox(ShapeContainer[] containers, String operation){
        int result=0;
        String message="";

        for(int i=0;i<containers.length;i++){
            //int type=containers[i].getElement().getType();
            if(!containers[i].getElement().isClosed()){
                message="\nWarning : Unclosed curve is selected !";
                result=-1;
                break;
            }
            if(containers[i].isTextBox()&&operation.equals("add")&&result==0){
                message="\nThe selected shape has a text box !";
                result=1;
                break;
            }
        }
        if (result != 0) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(),
                    message, "add text command", JOptionPane.ERROR_MESSAGE);
        }
        if(result<0) result=0;
        return result;
    }

    public void setFontStyle(FontStyle fontStyle){
        ContainerManager containerManager=ObjectTable.getContainerManager("");
      //---------------------------------//
        this.containerManager.undoSetupStart();
      //---------------------------------//
        ShapeContainer container=containerManager.getEditableTextBox();
        if(container!=null){
            TextBox textBox=container.getTextBox();
            textBox.currentFontStyle=fontStyle;
            //textBox.setCurrentFontStyle(fontStyle, "ExecCommand");
            if(textBox.hasSelectedText()) {
                textBox.setFontStyle(fontStyle);
                textBox.getShapeContainer().setChangeCode(UndoConstants.TEXTBOX);
            }
        } else{
            ShapeContainer[] containers=containerManager.getSelectedContainers();
            int size=0;
            if(containers!=null) size=containers.length;
            for(int i=0;i<size;i++){
                TextBox[] textBoxes=containers[i].getGroupedTextBoxes();
                for(int j=0;j<textBoxes.length;j++) {
                    textBoxes[j].setFontStyle(fontStyle);
                    textBoxes[j].getShapeContainer().setChangeCode(UndoConstants.TEXTBOX);
                }
            }
        }
      //-------------------------------//
        this.containerManager.undoSetupEnd();
      //-------------------------------//
    }

    public void setTextBoxLayout(Insets textBoxInsets, int textAlign, double lineSpace){
        ContainerManager containerManager=ObjectTable.getContainerManager("");
      //---------------------------------//
        this.containerManager.undoSetupStart();
      //---------------------------------//
        ShapeContainer[] containers=containerManager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        for(int i=0;i<size;i++){
            TextBox[] textBoxes=containers[i].getGroupedTextBoxes();
            for(int j=0;j<textBoxes.length;j++){
                textBoxes[j].setTextBoxLayout(textBoxInsets, textAlign, lineSpace);
                textBoxes[j].getShapeContainer().setChangeCode(UndoConstants.TEXTBOX);
            }
            containers[i].setChangeCode(UndoConstants.TEXTBOX);
        }
      //-------------------------------//
        this.containerManager.undoSetupEnd();
      //-------------------------------//
    }

    public void moveZorder(int mode){
        ContainerManager containerManager=ObjectTable.getContainerManager("ExecCommand");
        ShapeContainer[] selectedContainers=containerManager.getSelectedContainers();
        ShapeContainer[] containers=containerManager.getContainers();
        if(debug>0) this.containerManager.printContainers("ExecCommand.moveLayer");
        int size=0;
        if(selectedContainers!=null)  size=selectedContainers.length;
        if(size==0) return;
      //---------------------------------//
        this.containerManager.undoSetupStart();
      //---------------------------------//
        switch(mode){
            //move to front
            case 0:{
                for(int i=0;i<size;i++) this.containerManager.deleteContainer(selectedContainers[i]);
                for(int i=0;i<size;i++) this.containerManager.addContainer(selectedContainers[i]);
                break;
            }
            //move to back
            case 1:{
                for(int i=0;i<size;i++) this.containerManager.deleteContainer(selectedContainers[i]);
                for(int i=size-1;i>=0;i--) this.containerManager.addContainer(0,selectedContainers[i]);
                break;
            }
            //move foreward
            case 2:{
                if(containers.length<2) return;
                for(int i=containers.length-2;i>=0;i--){
                    if(containers[i].isSelected()&&!containers[i+1].isSelected()){
                        this.containerManager.swapContainers(containers[i], containers[i+1]);
                    }
                }//end of for
                break;
            }
            //move backward
            case 3:{
                if(containers.length<2) return;
                for(int i=1;i<containers.length;i++){
                    if(containers[i].isSelected()&&!containers[i-1].isSelected()){
                        this.containerManager.swapContainers(containers[i], containers[i-1]);
                    }
                }//end of for
                break;
            }
        }//switch
        //-----------------------------//
        this.containerManager.undoSetupEnd();
      //-------------------------------//
    }

    public void align(int mode){
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        ShapeContainer[] containers=containerManager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        if( size<2) return;
        Rectangle2D maxBox=ShapeElementUtil.getBoundingBox(containers);
        double MinX=maxBox.getX();
        double MinY=maxBox.getY();
        double MaxX=maxBox.getX()+maxBox.getWidth();
        double MaxY=maxBox.getY()+maxBox.getHeight();
        double CenterX=maxBox.getX()+0.5*maxBox.getWidth();
        double CenterY=maxBox.getY()+0.5*maxBox.getHeight();

        switch(mode){
            //align_left
            case 0:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    moveX=MinX-currentBox.getX();
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
            //align_center
            case 1:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    double centerX=currentBox.getX()+0.5*currentBox.getWidth();
                    moveX=CenterX-centerX;
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
            //align_right
            case 2:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    moveX=MaxX-(currentBox.getX()+currentBox.getWidth());
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
            //align_top
            case 3:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    moveY=MinY-currentBox.getY();
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
            //align_middle
            case 4:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    double centerY=currentBox.getY()+0.5*currentBox.getHeight();
                    moveY=CenterY-centerY;
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
            //align_bottom
            case 5:{
                double moveX=0, moveY=0;
                for(int i=0;i<size;i++) {
                    Rectangle2D currentBox=containers[i].getBoundingBox();
                    moveY=MaxY-(currentBox.getY()+currentBox.getHeight());
                    Rectangle2D newBox=
                        new Rectangle2D.Double(currentBox.getX()+moveX,
                        currentBox.getY()+moveY,
                        currentBox.getWidth(), currentBox.getHeight());
                  //---------------------------------------------//
                    ConnectionUtil.moveResize(containers[i],
                            currentBox, newBox, true, true);
                  //---------------------------------------------//
                }
                break;
            }
        }//switch
    }
}
