/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package geomExtension;

import java.awt.geom.*;
import java.text.*;
import DrawTop.*;


public class Ellipse2DE extends Curve2D{
    double pai=Math.PI;
    //double x; double y; double width; double height;
    
    public Ellipse2DE(Segment2D[] segments){
        super(segments);
    }
    
    public Ellipse2DE(double x, double y, double width, double height){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        this.segments=new Segment2D[1];
        Arc2D arc=new Arc2D.Double(x, y, width, height, 0, 360, Arc2D.OPEN);
        segments[0]=new Segment2D(Segment2D.ARC, arc);
        generalPath.append(arc,true);
        generalPath.closePath();
        this.closed=true;
    }

//Curve2D method
    public int getType2DE(){
        return Command.ELLIPSE;
    }
//Ellipse2DE proper
    public double getX(){
        Arc2D arc=(Arc2D)segments[0].getShape();
        return arc.getX();
    }
//Ellipse2DE proper
    public double getY(){
        Arc2D arc=(Arc2D)segments[0].getShape();
        return arc.getY();
    }
//Ellipse2DE proper
    public double getWidth(){
        Arc2D arc=(Arc2D)segments[0].getShape();
        return arc.getWidth();
    }
//Ellipse2DE proper
    public double getHeight(){
        Arc2D arc=(Arc2D)segments[0].getShape();
        return arc.getHeight();
    }

//Curve2D method
    public Object clone(){
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        return (new Ellipse2DE(x, y, w, h));
    }
//Curve2D method
    public String toString(){
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        String str="";
        str+="Ellipse x,y="+nf.format(x)+","+nf.format(y)+
                ", width,height="+nf.format(w)+","+nf.format(h);
        return str;
    }
}