package geomExtension;

import java.awt.geom.*;
import java.io.*;

public class SerializableCurve2D implements Serializable {
    public int type=0;
    public double[] doubleData=null;
    public Point2D[] points=null;
    public SerializableSegment2D[] serializableSegments=null;
    public static final String[] versions={"ver0.0"};
    static int debug=0;
    
    public SerializableCurve2D(){}

    public void setSegments(SerializableSegment2D[] serializableSegments){
        this.serializableSegments=serializableSegments;
    }
    
    public SerializableSegment2D[] getSegments(){
        return this.serializableSegments;
    }
    
    public Object clone(){
        SerializableCurve2D scurve=new SerializableCurve2D();
        scurve.type=this.type;
        if(this.doubleData!=null&&this.doubleData.length>0){
            double[] data=new double[this.doubleData.length];
            for(int i=0;i<this.doubleData.length;i++) data[i]=this.doubleData[i];
            scurve.doubleData=data;
        }
        if(this.points!=null&&this.points.length>0){
            Point2D[] pts=new Point2D[this.points.length];
            for(int i=0;i<this.points.length;i++)  pts[i]=(Point2D)this.points[i].clone();
            scurve.points=pts;
        }
        if(this.serializableSegments!=null){
            SerializableSegment2D[] segs=new SerializableSegment2D[this.serializableSegments.length];
            for(int i=0;i<this.serializableSegments.length;i++) 
                segs[i]=(SerializableSegment2D)this.serializableSegments[i].clone();
            scurve.serializableSegments=segs;
        }
        return scurve;
    }
    
    public static int writeSerializableCurve2D(ObjectOutputStream out,
            SerializableCurve2D sCurve2D) throws Exception{
        if(debug>0) System.out.println(" -- writeSerializableShape sCurve2D="+sCurve2D.toString());
        int ret=0;
        try{
            out.writeUTF(SerializableCurve2D.versions[0]);
            out.writeInt(sCurve2D.type);
            out.writeObject(sCurve2D.doubleData);
            out.writeObject(sCurve2D.points);
            int size=0;
            if(sCurve2D.serializableSegments!=null) size=sCurve2D.serializableSegments.length;
            out.writeInt(size);
            for(int i=0;i<size;i++){
                int ret0=SerializableSegment2D.writeSerializableSegment2D(out, 
                        sCurve2D.serializableSegments[i]);
                if(ret0<0) ret=-1;
            }
        } catch(Exception e){
            e.printStackTrace();
            ret=-1;
        }
        if(debug>0) System.out.println(" ++ writeSerializableCurve2D ret=="+ret);
        return ret;
    }
    
    public static SerializableCurve2D readSerializableCurve2D(ObjectInputStream in) 
            throws Exception{
        SerializableCurve2D sCurve2D=new SerializableCurve2D();
        String version="";
        try{
            version=in.readUTF();
            if(debug>0) System.out.println(" -- readSerializableShape version="+version);
            sCurve2D.type=in.readInt();
            sCurve2D.doubleData=(double[])in.readObject();
            sCurve2D.points=(Point2D[])in.readObject();
            int size=in.readInt();
            sCurve2D.serializableSegments=new SerializableSegment2D[size];
            for(int i=0;i<size;i++){
                sCurve2D.serializableSegments[i]=SerializableSegment2D.readSerializableSegment2D(in);
            }
        } catch(Exception e){
            System.out.println("*** Error readSerializableCurve2D version="+version);
            e.printStackTrace();
        }
        return sCurve2D;
    }
}
