package menu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import util.*;

public class ButtonOfAccelerators extends JButton{
    public static int debug=0;
    
    public ButtonOfAccelerators(String commandName, String[] accelerators) {
        this.setName(commandName);
        this.setActionCommand(commandName);
        this.setAccelerators(accelerators);
        this.setPreferredSize(new Dimension(1, 10));
    }

    public void setAccelerators(String[] accelerators){
        AcceleratorsAction action=new AcceleratorsAction();
        this.addActionListener(action);
        int size=0;
        if(accelerators!=null) size=accelerators.length;
        for(int i=0;i<size;i++){
            KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
            InputMap inputMap = this.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
            inputMap.put(stroke, accelerators[i]);
            ActionMap actionMap = this.getActionMap();
            actionMap.put(accelerators[i], action);
            if(debug>0) System.out.println("-- ButtonOfAcceleratoractionMap stroke="+stroke+
                    ", key="+accelerators[i]+", value="+actionMap.get(accelerators[i]));
        }
    }

    public static ButtonOfAccelerators createEditAccelerators(String commandName) {
        String[] accelerators={"ctrl x", "ctrl x", "ctrl v", "ctrl a", "delete"};
        ButtonOfAccelerators button=new ButtonOfAccelerators(commandName, accelerators);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }

}
class AcceleratorsAction extends AbstractAction{
    //ExecCommand execCommand;
    int debug=0;
    
    public AcceleratorsAction(){}
    
    public void actionPerformed(ActionEvent e) {
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        String ctrlCommand=Util.getASCIIControlString(commandName);
        if(ctrlCommand!=null&&!ctrlCommand.equals("")) {
            if(debug>0) System.out.println(" ++ commandName"+commandName+
                    ", crtl command="+ctrlCommand+
                    ", Hex of action command="+Util.toHexString(commandName));
            JTabbedPane tabbedPane=ObjectTable.getTabbedPane("ButtonOfAcceleratorAction");
            tabbedPane.setSelectedIndex(1);
            if(ctrlCommand.equalsIgnoreCase("ctrl x")) commandName="cut";
            if(ctrlCommand.equalsIgnoreCase("ctrl c")) commandName="copy";
            if(ctrlCommand.equalsIgnoreCase("ctrl v")) commandName="paste";
            if(ctrlCommand.equalsIgnoreCase("ctrl a")) commandName="select all";
            if(ctrlCommand.equalsIgnoreCase("delete")) commandName="del";

        }
        if(debug>0) System.out.println("- ButtonOfAcceleratorAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        int commandId=Command.getCommandId(commandName);
        if(commandId<0){
            System.err.println("*** Error ButtonOfAcceleratorAction: specified command not found;"+commandName);
            return;
        }
         Command command=new Command(commandId, Command.callFromMenu, null);
         ExecCommand execCommand=ObjectTable.getExecCommand();
         execCommand=ObjectTable.getExecCommand("ButtonOfAcceleratorAction");
         execCommand.exec(command);
    }//End of actionPerformed

}