package menu;

import java.awt.*;

import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import java.util.ArrayList;
import DrawTop.*;
import shape.*;
import util.*;

public class ButtonOfDebug  extends JMenuBar implements ActionListener {
    JMenu menu;
    String[] menuItemNames=null;
    //DialogOfSystemOut sysoutDialog=null;
    public static int debug=0;

    public ButtonOfDebug(String commandName, boolean setText, 
                ImageIcon imageIcon, String tip) {
        this.setLayout(new FlowLayout(FlowLayout.LEADING, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu=new JMenuEx();
        this.add(this.menu);
        if(setText) {
             this.menu.setText(commandName);
             this.menu.setHorizontalTextPosition(SwingConstants.LEADING);
        }
        if(imageIcon!=null) this.menu.setIcon(imageIcon);
        this.menu.setOpaque(false);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
    }
    
    public void setStandardButtonStyle() { 
        Border raisedBorder = new BevelBorder(BevelBorder.RAISED);
        this.menu.setBorder(raisedBorder);
        this.menu.setFont(MenuConstants.MenuFont);
        this.menu.setIconTextGap(0);
        this.menu.setOpaque(true);
        Color backGround=new Color(0xDDE8F3);
        this.menu.setBackground(backGround);
        this.menu.setForeground(Color.black);
    }

    public boolean isSelected() { 
        return menu.isSelected(); 
    }
  
    public void setSelected(boolean selected) {
        this.menu.setSelected(selected);
    }

    public static ButtonOfDebug createDebugButton(int width) {
        String commandName=Command.getCommandLowerString(Command.DEBUG);
        ButtonOfDebug menuButton=new ButtonOfDebug(commandName, true, null, commandName);
        menuButton.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        JMenu menu=menuButton.menu;
        //String[] menuItemNames
        //         ={"System.out dialog", "Print", "Print Menu List", "Print ContainerList", "Test ShapeContainer"};
        //menuButton.menuItemNames=menuItemNames;
        //JMenuItem menuItem=null;
    //menuItem System.out dialog
        JMenuItem menuItem=new JMenuItem("System.out dialog");
        menuItem.setName("System.out dialog");
        menuItem.setActionCommand("System.out dialog");
        menuItem.addActionListener(menuButton);
        menu.add(menuItem);
/*
		//menuItem renumberContainerList
        menuItem=new JMenuItem("renumber ContainerList");
        menuItem.setName("renumber ContainerList");
        menuItem.setActionCommand("renumber ContainerList");
        menuItem.addActionListener(menuButton);
        menu.add(menuItem);
*/
		//Print
		JMenu printSubMenu = new JMenu("Print");
		printSubMenu.setName("Print");
		JMenuItem printMenuItem1 = new JMenuItem("Print Menu List");
		printMenuItem1.setActionCommand("Print Menu List");
		printMenuItem1.addActionListener(menuButton);
		printSubMenu.add(printMenuItem1);
		JMenuItem printMenuItem2 = new JMenuItem("Print ContainerList");
		printMenuItem2.setActionCommand("Print ContainerList");
		printMenuItem2.addActionListener(menuButton);
		printSubMenu.add(printMenuItem2);
		JMenuItem printMenuItem3 = new JMenuItem("Print ScrollPane");
		printMenuItem3.setActionCommand("Print ScrollPane");
		printMenuItem3.addActionListener(menuButton);
		printSubMenu.add(printMenuItem3);
		menu.add(printSubMenu);

		//menuItem test ShapeContainer
		JMenu shapeSubMenu = new JMenu("Test Shape");
		shapeSubMenu.setName("Test Shape");
		JMenuItem shapeMenuItem1 = new JMenuItem("ShapeContainer.clone");
		shapeMenuItem1.setActionCommand("ShapeContainer.clone");
		shapeMenuItem1.addActionListener(menuButton);
		shapeSubMenu.add(shapeMenuItem1);
		JMenuItem shapeMenuItem2 = new JMenuItem("SerializableElement.clone");
		shapeMenuItem2.setActionCommand("SerializableElement.clone");
		shapeMenuItem2.addActionListener(menuButton);
		shapeSubMenu.add(shapeMenuItem2);
		JMenuItem shapeMenuItem3 = new JMenuItem("DrawFileIo convert, invert");
		shapeMenuItem3.setActionCommand("DrawFileIo convert, invert");
		shapeMenuItem3.addActionListener(menuButton);
		shapeSubMenu.add(shapeMenuItem3);
		menu.add(shapeSubMenu);

    //formating and registration to MenuUtil
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(menuButton);
        if(debug>0) menuUtil.printMenuComponent(menuButton);
        return menuButton;
    }

    public void actionPerformed(ActionEvent e){
        String menuItem=e.getActionCommand();
		if(debug>=0) System.out.println("** ButtonOfDebug.actionPerformed menuItem="+menuItem);
		
        if(menuItem.compareToIgnoreCase("System.out dialog")==0) {
            DialogOfSystemOut dialog=new DialogOfSystemOut();
            dialog.showDialog();
            System.out.println("System.out dialog open");
        } 
/*
        if(menuItem.compareToIgnoreCase("renumber ContainerList")==0) {
            ContainerManager manager=ObjectTable.getContainerManager();
			manager.printContainers(" Before Renumbering ContainerList");
			manager.renumberContainerList();
            manager.printContainers(" After Renumbering ContainerList");

        } 
*/
        if(menuItem.compareToIgnoreCase("Print Menu List")==0) {
            MenuUtil menuUtil=ObjectTable.getMenuUtil();
            DialogOfSystemOut dialog
                =(DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if(dialog==null){
                DialogOfSystemOut newDialog=new DialogOfSystemOut();
                newDialog.showDialog();
            }
            //-------------------------------------//
            JFrame frame=ObjectTable.getDrawMain();
            frame.list(System.out, 0);
			//-------------------------------------//
        }
		
		if (menuItem.compareToIgnoreCase("Print ContainerList") == 0) {
			MenuUtil menuUtil = ObjectTable.getMenuUtil();
			DialogOfSystemOut dialog
					= (DialogOfSystemOut) menuUtil.getMenuComponent("DialogOfSystemOut");
			if (dialog == null) {
				DialogOfSystemOut newDialog = new DialogOfSystemOut();
				newDialog.showDialog();
			}
			//------------------------------------------------------------------//
			ContainerManager manager = ObjectTable.getContainerManager(menuItem);
			manager.printContainers("");
			//------------------------------------------------------------------//
		}
		
		if (menuItem.compareToIgnoreCase("Print ScrollPane") == 0) {
			MenuUtil menuUtil = ObjectTable.getMenuUtil();
			DialogOfSystemOut dialog
					= (DialogOfSystemOut) menuUtil.getMenuComponent("DialogOfSystemOut");
			if (dialog == null) {
				DialogOfSystemOut newDialog = new DialogOfSystemOut();
				newDialog.showDialog();
			}
			//---------------------------------------//
			ButtonOfDebugTestCode.printScrollPane();
			//---------------------------------------//
		}
		
		if (menuItem.compareToIgnoreCase("ShapeContainer.clone") == 0) {
			MenuUtil menuUtil = ObjectTable.getMenuUtil();
			DialogOfSystemOut dialog
					= (DialogOfSystemOut) menuUtil.getMenuComponent("DialogOfSystemOut");
			if (dialog == null) {
				DialogOfSystemOut newDialog = new DialogOfSystemOut();
				newDialog.showDialog();
			}
		    //------------------------------------------//
			ButtonOfDebugTestCode.shapeContainerClone();
		    //------------------------------------------//
		}
		
		if (menuItem.compareToIgnoreCase("SerializableElement.clone") == 0) {
			MenuUtil menuUtil = ObjectTable.getMenuUtil();
			DialogOfSystemOut dialog
					= (DialogOfSystemOut) menuUtil.getMenuComponent("DialogOfSystemOut");
			if (dialog == null) {
				DialogOfSystemOut newDialog = new DialogOfSystemOut();
				newDialog.showDialog();
			}

			//-----------------------------------------------//
			ButtonOfDebugTestCode.serializableElementClone();
			//-----------------------------------------------//
		}
		if (menuItem.compareToIgnoreCase("DrawFileIo convert, invert") == 0) {
			MenuUtil menuUtil = ObjectTable.getMenuUtil();
			DialogOfSystemOut dialog
					= (DialogOfSystemOut) menuUtil.getMenuComponent("DialogOfSystemOut");
			if (dialog == null) {
				DialogOfSystemOut newDialog = new DialogOfSystemOut();
				newDialog.showDialog();
			}
			//--------------------------------------------//
			ButtonOfDebugTestCode.DrawFileIoConvertInvert();
			//-------------------------------------------//
		}
        int count=this.menu.getItemCount();
        for(int i=0;i<count;i++) {
            this.menu.getItem(i).setSelected(false);
        }
    }

}

/*
class JMenuEx extends JMenu{
    Color baseColor=new Color(0xCDD8F3);
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size=this.getPreferredSize();
        //this.setComponent(size);
        double w=size.getWidth();
        double h=size.getHeight();
        if(w==0||h==0) return;
        Point2D p1=new Point2D.Double(0d,0.2*h);
        Point2D p2=new Point2D.Double(0d,0.8*h);
        Point2D p3=new Point2D.Double(0d,h);
        GradientPaint gradient0 =new GradientPaint(p1, Color.white, p2, baseColor,true);
        GradientPaint gradient1 =new GradientPaint(p2, baseColor, p3, baseColor,true);
        Rectangle2D rect0=new Rectangle2D.Double(0,0,w,h);
        Rectangle2D rect1=new Rectangle2D.Double(0,p2.getY(),w,h);
        
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gradient0);
        g2d.fill(rect0);
        g2d.setPaint(gradient1);
        g2d.fill(rect1);
        g2d.setColor(Color.black);
        FontMetrics metrics=g.getFontMetrics();
        double stringH=metrics.getDescent()+metrics.getAscent();
        double stringW=metrics.stringWidth(this.getText());
        double stringX=0d;
        if(w>stringW) stringX=0.5*(w-stringW);
        double stringY=h-metrics.getDescent();
        if(h>stringH) stringY=0.5*(h+stringH)-metrics.getDescent();
        g2d.drawString(this.getText(), (float)stringX,(float)stringY);
    }
}
 * */