//
//
package menu;

import java.awt.geom.*;
import java.awt.*;
import java.util.ArrayList;
import java.io.*;
import java.util.*;
import javax.swing.*;
import DrawTop.*;
import geomExtension.*;

import shape.*;
import textBox.*;
import util.*;

public class ButtonOfDebugTestCode {
	static int debug=0;
	
	public static void printScrollPane() {
		//System.out.println("ButtonOfDebug actionPerformed called menuItem=printScrollPane");
		double currentScale = DrawParameters.getScale();
		JScrollPane scrollPane = ObjectTable.getScrollPane();
		DrawPanel drawPanel = ObjectTable.getDrawPanel();
		ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
		JPanel viewPanel = (JPanel) drawPanel.getParent();
		JViewport viewport = scrollPane.getViewport();
		Rectangle vp=viewport.getBounds();
		Rectangle vp0=new Rectangle(0, 0, (int)vp.getWidth(), (int)vp.getHeight());
		Rectangle dp = drawPanel.getBounds();
		Rectangle dp0 = new Rectangle(0, 0, (int) dp.getWidth(), (int) dp.getHeight());
		Rectangle lp = listenerPanel.getBounds();
		Rectangle lp0 = new Rectangle(0, 0, (int) lp.getWidth(), (int) lp.getHeight());
		Rectangle sc = scrollPane.getBounds();
		Rectangle sc0 = new Rectangle(0, 0, (int) sc.getWidth(), (int) sc.getHeight());
		Rectangle vpS=SwingUtilities.convertRectangle(viewport, vp0, scrollPane);
		Rectangle vpV=SwingUtilities.convertRectangle(viewport, vp0, viewPanel);
		Rectangle vpD=SwingUtilities.convertRectangle(viewport, vp0, drawPanel);
		
		Rectangle dpS=SwingUtilities.convertRectangle(drawPanel, dp0, scrollPane);
		Rectangle dpVP=SwingUtilities.convertRectangle(drawPanel, dp0, viewport);
		Rectangle dpP=SwingUtilities.convertRectangle(drawPanel, dp0, viewPanel);
		Rectangle lpD=SwingUtilities.convertRectangle(listenerPanel, lp0, drawPanel);


		String str="";
		str += "\n*** printScrollPane"
				+ "\n- scale=" + Util.PercentNum(currentScale, 0) + ", sheet size=" + DrawParameters.SheetSize
				+ "\n- drawPanel Parent=" + drawPanel.getParent().getName()
				+ ", viewPanel Parent=" + viewPanel.getParent().getName()
				+ ", viewport Parent=" + viewport.getParent().getName()
				+ "\n- viewport Rect: " + Util.Rect(vp0)+", Insets: "+Util.Insets(viewport.getInsets())
				+ "\n- drawPanel Rect: " + Util.Rect(dp0)+", Insets: "+Util.Insets(drawPanel.getInsets())
				+ "\n- scrollPane Rect: " + Util.Rect(sc0)+", Insets: "+Util.Insets(scrollPane.getInsets())
				+ "\n- viewport on scrollPane: " + Util.Rect(vpS)
				+ "\n- viewport on viewPanel: " + Util.Rect(vpV)
				+ "\n- viewport on drawPanel: " + Util.Rect(vpD)
				+ "\n- drawPanel on scrollPane: " + Util.Rect(dpS)
				+ "\n- drawPanel on viewport: " + Util.Rect(dpVP)
				+ "\n- drawPanel on viewPanel: " + Util.Rect(dpP)
				+ "\n- listenerPanel on drawPanel: " + Util.Rect(lpD);
		System.out.println(str);
	}
	
	public static void shapeContainerClone() {
		System.out.println("\n*** shapeContainerClone(");
		ContainerManager manager = ObjectTable.getContainerManager();

		ShapeContainer[] containers = manager.getContainers();
		ShapeContainer[] newContainers = new ShapeContainer[containers.length];
		System.out.println("** Original ShapeContainers");
		for (int i = 0; i < containers.length; i++) {
			System.out.println(" - containers[" + i + "]: " + containers[i].toVeryShortString());
		}
		System.out.println("\n** Clone ShapeContainers");
		for (int i = 0; i < containers.length; i++) {
			newContainers[i] = (ShapeContainer) containers[i].clone();
			System.out.println("- containers[" + i + "]: " + newContainers[i].toVeryShortString());
		}
		System.out.println("\n** Clone ShapeContainers after setNewShapeId(manager, true)");
		manager.undoSetupStart();
		for (int i = 0; i < containers.length; i++) {
			newContainers[i].setNewShapeId(manager, true);
			Rectangle2D oldBox = newContainers[i].getBoundingBox();
			double delta = 10;
			Rectangle2D newBox = new Rectangle2D.Double(oldBox.getX() + delta, oldBox.getY() + delta, oldBox.getWidth(), oldBox.getHeight());
			newContainers[i].getElement().moveResize(oldBox, newBox, true);
			manager.addContainer(newContainers[i]);
			System.out.println("- containers[" + i + "]: " + newContainers[i].toVeryShortString());
		}
		manager.undoSetupEnd();
		ObjectTable.getDrawPanel("").repaint();
		manager.printContainers("");
	}

	public static void serializableElementClone() {
		System.out.println("\n*** serializableElementClone");
		ArrayList serializableElementList = new ArrayList();
		ContainerManager manager = ObjectTable.getContainerManager();
		ArrayList containerList = manager.getContainerList();
		printContainerList("**print ContainerList size=" + containerList.size(), containerList);
		System.out.println("\n**SerializableElement convertShapeContainer starts");
		for (int i = 0; i < containerList.size(); i++) {
			ShapeContainer container = (ShapeContainer) containerList.get(i);
			//----------------------------------------------------------------------//	
			SerializableElement sElement
					= SerializableElementUtilEx.convertShapeContainer(container);
			//----------------------------------------------------------------------//	
			serializableElementList.add(sElement);
		}
		System.out.println("**SerializableElement convertShapeContainer sucessfull");
		printSerializableElementList("\n**print SerializableElementList size="
				+ serializableElementList.size(), serializableElementList);

		System.out.println("\n**SerializableElement cloning starts");
		ArrayList serializableElementCloneList = new ArrayList();
		for (int i = 0; i < serializableElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) serializableElementList.get(i);
			SerializableElement sElementClone = (SerializableElement) sElement.clone();
			serializableElementCloneList.add(sElementClone);
		}
		System.out.println("**SerializableElement cloning successfull");
		printSerializableElementList("\n**print SerializableElementCloneList size="
				+ serializableElementCloneList.size(), serializableElementCloneList);

		ArrayList ContainrtCloneList = new ArrayList();
		System.out.println("\n**SerializableElement invertShapeContainer starts");
		for (int i = 0; i < containerList.size(); i++) {
			SerializableElement sElement = (SerializableElement) serializableElementCloneList.get(i);
			//----------------------------------------------------------------------//	
			ShapeContainer container
					= SerializableElementUtilEx.invertShapeContainer(sElement);
			//----------------------------------------------------------------------//	
			ContainrtCloneList.add(container);
		}
		System.out.println("**SerializableElement invertShapeContainer sucessfull");
		printContainerList("**print ContainerCloneList size=" + ContainrtCloneList.size(), ContainrtCloneList);
	}

	public static void DrawFileIoConvertInvert() {
		DrawFileIoEx drawFileIoEx=new DrawFileIoEx();
		if(debug>=0) System.out.println("\n*** DrawFileIoEx.convertContainerList");
		ArrayList serializableElementList = new ArrayList();
		ContainerManager manager = ObjectTable.getContainerManager();
		ArrayList containerList = manager.getContainerList();
		printContainerList("**print ContainerList size=" + containerList.size(), containerList);
		if(debug>0) System.out.println("\n**SerializableElement convertShapeContainer starts");
	  //-------------------------------------------------------------------------//
		drawFileIoEx.convertContainerList(containerList, serializableElementList);
	  //-------------------------------------------------------------------------//
		printSerializableElementList("\n**print SerializableElementList size="
				+ serializableElementList.size(), serializableElementList);
		
		ArrayList newContainerList=new ArrayList();
	  //-------------------------------------------------------------------------//
		drawFileIoEx.invertContainerList(newContainerList, serializableElementList);
	  //-------------------------------------------------------------------------//
	  if(debug>=0) System.out.println("\n*** DrawFileIoEx.invertContainerList");
	  printContainerList("**print newContainerList size=" + newContainerList.size(), newContainerList);
	}

	private static void printContainerList(String title, ArrayList containerList) {
		System.out.println(title);
		for (int i = 0; i < containerList.size(); i++) {
			ShapeContainer container = (ShapeContainer) containerList.get(i);
			System.out.println(" - Container[" + i + "]=" + container.toVeryShortString());
		}
	}
	
	private static void printSerializableElementList(String title, ArrayList sElementList) {
		System.out.println(title);
		for (int i = 0; i < sElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) sElementList.get(i);
			System.out.println(" - SerializableElement[" + i + "]=" + sElement.toString());
		}
		
		System.out.println("\n toShartString");
		for (int i = 0; i < sElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) sElementList.get(i);
			System.out.println(" - SerializableElement[" + i + "]=" + sElement.toShortString());
		}
		System.out.println("\n toVeryShortString");
		for (int i = 0; i < sElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) sElementList.get(i);
			System.out.println(" - SerializableElement[" + i + "]=" + sElement.toVeryShortString());
		}
	}
}

class SerializableElementUtilEx implements Serializable {
	public static final String[] versions = {"ver0.0", "ver1.0"};
	static int debug = 0;

	public static SerializableElement convertShapeContainer(ShapeContainer container) {
		SerializableElement sElement = null;
		if (container.getContainerType() == ShapeContainer.SHAPE) {
			sElement = convertSingleContainer(container);
			//sElement = convertContainerSimply(container);
		} else {
			sElement = convertGroupContainer(container);
			//sElement = convertGroupContainer_org(container);
		}
		return sElement;
	}

	public static SerializableElement convertSingleContainer(ShapeContainer container) {
		SerializableElement sElement = new SerializableElement();
		//sElement for a sigle shape ShapeContainer
		sElement.containerType = ShapeContainer.SHAPE;
		sElement.containerIndex = container.getContainerIndex();
		ShapeContainer parent = container.getParent();
		sElement.parent = "";
		if (parent != null) {
			sElement.parent = parent.getShapeId();
		}
		sElement.shapeId = container.getShapeId();
		sElement.date = Calendar.getInstance().getTime();
		sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName()
				+ ":" + ObjectTable.getFileIo().getCurrentPage();
		sElement.connectorTargetPermission = container.connectorTargetPermission;
		sElement.connectorPermission = container.connectorPermission;
		sElement.property = container.property;

		//sElement for shapeElement
		ShapeElement shapeElement = container.getElement();
		int tye = shapeElement.getTypeE();
		sElement.elementType = Command.getCommandString(tye);
		//sElement.elementType=shapeElement.getTypeE();
		sElement.serializableCurve2D = shapeElement.getSerializableCurve2D();
		//sElement for PaintStyle
		sElement.fillColor = container.getPaintStyle().fillColor;
		sElement.lineColor = container.getPaintStyle().lineColor;
		sElement.lineWidth = container.getPaintStyle().lineWidth;
		sElement.dashedStyle = container.getPaintStyle().dashedStyle;
		sElement.dash = container.getPaintStyle().dash;
		sElement.arrowStyle = container.getPaintStyle().arrowStyle;
		sElement.startArrowType = container.getPaintStyle().startArrowType;
		sElement.endArrowType = container.getPaintStyle().endArrowType;
		// sElement for TextBox only
		if (container.isTextBox()) {
			TextBox textBox = container.getTextBox();
			sElement.textArea = (Rectangle2D) textBox.textArea.clone();
			CommittedTextContainer committedTextContainer = textBox.getCommittedTextContainer();
			sElement.attributedString = committedTextContainer.getSerializableAttributedString();
			sElement.textBoxInsets = (Insets) textBox.textBoxInsets.clone();
			sElement.textAlign = textBox.textAlign;
			sElement.lineSpace = textBox.lineSpace;
		}
		// sElement for ImageElement
		if (sElement.elementType.equalsIgnoreCase("IMAGE")) {
			ImageElement imageElement = (ImageElement) shapeElement;
			sElement.imageByteData = imageElement.getByteImage();
		}

		return sElement;
	}

	public static SerializableElement convertContainerSimply(ShapeContainer container) {
		SerializableElement sElement = new SerializableElement();
		if (container.getContainerType() == ShapeContainer.SHAPE) {
			//sElement for a sigle shape ShapeContainer
			sElement.containerType = ShapeContainer.SHAPE;
			sElement.containerIndex = container.getContainerIndex();
			ShapeContainer parent = container.getParent();
			sElement.parent = "";
			if (parent != null) {
				sElement.parent = parent.getShapeId();
			}
			sElement.shapeId = container.getShapeId();
			sElement.date = Calendar.getInstance().getTime();
			sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName()
					+ ":" + ObjectTable.getFileIo().getCurrentPage();
			sElement.connectorTargetPermission = container.connectorTargetPermission;
			sElement.connectorPermission = container.connectorPermission;
			sElement.property = container.property;

			//sElement for shapeElement
			ShapeElement shapeElement = container.getElement();
			int tye = shapeElement.getTypeE();
			sElement.elementType = Command.getCommandString(tye);
			//sElement.elementType=shapeElement.getTypeE();
			sElement.serializableCurve2D = shapeElement.getSerializableCurve2D();
			//sElement for PaintStyle
			sElement.fillColor = container.getPaintStyle().fillColor;
			sElement.lineColor = container.getPaintStyle().lineColor;
			sElement.lineWidth = container.getPaintStyle().lineWidth;
			sElement.dashedStyle = container.getPaintStyle().dashedStyle;
			sElement.dash = container.getPaintStyle().dash;
			sElement.arrowStyle = container.getPaintStyle().arrowStyle;
			sElement.startArrowType = container.getPaintStyle().startArrowType;
			sElement.endArrowType = container.getPaintStyle().endArrowType;
			// sElement for TextBox only
			if (container.isTextBox()) {
				TextBox textBox = container.getTextBox();
				sElement.textArea = (Rectangle2D) textBox.textArea.clone();
				CommittedTextContainer committedTextContainer = textBox.getCommittedTextContainer();
				sElement.attributedString = committedTextContainer.getSerializableAttributedString();
				sElement.textBoxInsets = (Insets) textBox.textBoxInsets.clone();
				sElement.textAlign = textBox.textAlign;
				sElement.lineSpace = textBox.lineSpace;
			}
			// sElement for ImageElement
			if (sElement.elementType.equalsIgnoreCase("IMAGE")) {
				ImageElement imageElement = (ImageElement) shapeElement;
				sElement.imageByteData = imageElement.getByteImage();
			}
		} else {
			//sElement for group ShapeContainer
			sElement.containerType = ShapeContainer.GROUP;
			sElement.containerIndex = container.getContainerIndex();
			ShapeContainer parent = container.getParent();
			sElement.parent = "";
			if (parent != null) {
				sElement.parent = parent.getShapeId();
			}
			ShapeElement shapeElement = container.getElement();
			int tye = shapeElement.getTypeE();
			sElement.elementType = Command.getCommandString(tye);
			//sElement.elementType=shapeElement.getTypeE();
			sElement.shapeId = container.getShapeId();
			sElement.date = Calendar.getInstance().getTime();
			sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName()
					+ ":" + ObjectTable.getFileIo().getCurrentPage();
			sElement.connectorTargetPermission = container.connectorTargetPermission;
			sElement.connectorPermission = container.connectorPermission;
			sElement.property = container.property;
			//sElement for groupElement
			GroupElement groupElement = ((GroupElement) shapeElement);
			ShapeContainer[] children = groupElement.getChildren();
			sElement.childrenList.clear();
			for (int i = 0; i < children.length; i++) {
				String shapeId = children[i].getShapeId();
				sElement.childrenList.add(shapeId);
			}
			//sElement.childrenList.clear();
		}
		return sElement;
	}
	private static SerializableElement convertGroupContainer(ShapeContainer container) {
		SerializableElement sElement = new SerializableElement();
		//ShapeElement shapeElement = container.getElement();
		GroupElement groupElement=(GroupElement)container.getElement();
		//sElement for group ShapeContainer
		sElement.containerType = ShapeContainer.GROUP;
		sElement.containerIndex = container.getContainerIndex();
		ShapeContainer parent = container.getParent();
		sElement.parent = "";
		if (parent != null) {
			sElement.parent = parent.getShapeId();
		}
		int tye = groupElement.getTypeE();
		sElement.elementType = Command.getCommandString(tye);
		//sElement.elementType=groupElement.getTypeE();
		sElement.shapeId = container.getShapeId();
		sElement.date = Calendar.getInstance().getTime();
		sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName()
				+ ":" + ObjectTable.getFileIo().getCurrentPage();
		sElement.connectorTargetPermission = container.connectorTargetPermission;
		sElement.connectorPermission = container.connectorPermission;
		sElement.property = container.property;
		//sElement for groupElement
		//GroupElement groupElement = ((GroupElement) shapeElement);
	/*
		ShapeContainer[] children = groupElement.getChildren();
		sElement.childrenList.clear();
		for (int i = 0; i < children.length; i++) {
			String shapeId = children[i].getShapeId();
			sElement.childrenList.add(shapeId);
		}
	*/
		//SerializableElement sElement = convertContainerSimply(container);
		//sElement for groupElement
		//GroupElement groupElement = ((GroupElement) shapeElement);
		ShapeContainer[] children = groupElement.getChildren();
		sElement.childrenList.clear();
		for (int i = 0; i < children.length; i++) {
		/*
			if (children[i].getContainerType() == ShapeContainer.SHAPE) {
				ShapeContainer child = (ShapeContainer) children[i];
				SerializableElement sChild = convertShapeContainer(child);
				sElement.childrenList.add(sChild);
				if (debug > 0) {
					System.out.println(" convertGroupContainer add to childrenList"
							+ " sChild[" + i + "]=" + sChild.shapeId + ", Parent=" + container.getShapeId());
				}
			}
		*/
			//if (children[i].getContainerType() == ShapeContainer.GROUP) {
				ShapeContainer child = (ShapeContainer) children[i];
				SerializableElement sChild = convertShapeContainer(child);
				sElement.childrenList.add(sChild);
				if (debug > 0) {
					System.out.println(" convertGroupContainer add to childrenList"
							+ " sChild[" + i + "]=" + sChild.shapeId + ", Parent=" + container.getShapeId());
				}
			//}
		}
		return sElement;
	}
	
	private static SerializableElement convertGroupContainer_org(ShapeContainer container) {
		ShapeElement shapeElement = container.getElement();
		SerializableElement sElement = convertContainerSimply(container);
		//sElement for groupElement
		GroupElement groupElement = ((GroupElement) shapeElement);
		ShapeContainer[] children = groupElement.getChildren();
		sElement.childrenList.clear();
		for (int i = 0; i < children.length; i++) {
			if (children[i].getContainerType() == ShapeContainer.SHAPE) {
				ShapeContainer child = (ShapeContainer) children[i];
				SerializableElement sChild = convertContainerSimply(child);
				sElement.childrenList.add(sChild);
				if (debug > 0) {
					System.out.println(" convertGroupContainer add to childrenList"
							+ " sChild[" + i + "]=" + sChild.shapeId + ", Parent=" + container.getShapeId());
				}
			}
			if (children[i].getContainerType() == ShapeContainer.GROUP) {
				ShapeContainer child = (ShapeContainer) children[i];
				SerializableElement sChild = convertGroupContainer_org(child);
				sElement.childrenList.add(sChild);
				if (debug > 0) {
					System.out.println(" convertGroupContainer add to childrenList"
							+ " sChild[" + i + "]=" + sChild.shapeId + ", Parent=" + container.getShapeId());
				}
			}
		}
		return sElement;
	}

	public static ShapeContainer invertShapeContainer(SerializableElement sElement) {
		//public static ShapeContainer reconstructShapeContainer(SerializableElement sElement){
		ShapeContainer container = null;
		if (sElement.containerType == ShapeContainer.SHAPE) {
			container = invertSingleContainer(sElement);
			if (container != null) {
				container.setSelected(false);
			}
		} else {
			container = invertGroupContainer(sElement);
			container.setSelected(false);
		}
		if (debug > 0) {
			System.out.println("\n** SerializableElementUtil invertShapeContainer **" + "\n"
					+ "- SerializableElementUtil" + sElement.toShortString()
					+ "\n- ShapeContainer" + container.toShortString());
		}
		return container;
	}

	public static ShapeContainer invertSingleContainer(SerializableElement sElement) {
		//public static ShapeContainer invertContainerSimply(SerializableElement sElement) {
		ShapeContainer container = new ShapeContainer();
		container.setContainerIndex(sElement.containerIndex);
		ShapeElement shapeElement = null;
		String shapeId = sElement.shapeId;
		int id = container.getElementType(shapeId);
		int type = Command.getCommandId(sElement.elementType);
		if (type < 0) {
			System.err.println("*** Error invertSingleContainerSimply: id=" + type
					+ ", elementType=" + sElement.elementType);
			type = id;
		}
		switch (type) {
			case Command.RECTANGLE: {
				shapeElement = new RectangleElement();
				break;
			}
			case Command.ROUND_RECTANGLE: {
				shapeElement = new RoundRectangleElement();
				break;
			}
			case Command.ELLIPSE: {
				shapeElement = new EllipseElement();
				break;
			}
			case Command.LINE: {
				shapeElement = new LineElement();
				break;
			}
			case Command.POLYLINE: {
				shapeElement = new PolylineElement();
				break;
			}
			case Command.CUBIC_CURVE: {
				shapeElement = new CubicCurveElement();
				break;
			}
			case Command.GENERAL_CURVE: {
				shapeElement = new GeneralCurveElement();
				break;
			}

			case Command.IMAGE: {
				shapeElement = new ImageElement();
				ImageElement imageElement = (ImageElement) shapeElement;
				imageElement.setByteImage(sElement.imageByteData);
				break;
			}
		} //switch
		// set ShapeContainer sElement
		container.setShapeId(sElement.shapeId);
		container.setElement(shapeElement);
		shapeElement.setShapeContainer(container);
		container.setConnectorTargetPermission(sElement.connectorTargetPermission);
		container.setConnectorPermission(sElement.connectorPermission);
		container.property = sElement.property;
		container.property.put("type", shapeElement.getShapeIdString());
		// set ShapeElement sElement
		shapeElement.setSerializableCurve2D((SerializableCurve2D) sElement.serializableCurve2D.clone());

		// set PaintStyle sElement
		PaintStyle paintStyle = container.getPaintStyle();
		//PaintStyle paintStyle=new PaintStyle(container);
		paintStyle.fillColor = sElement.fillColor;
		paintStyle.lineColor = sElement.lineColor;
		paintStyle.lineWidth = sElement.lineWidth;
		paintStyle.dashedStyle = sElement.dashedStyle;
		paintStyle.dash = sElement.dash;
		paintStyle.arrowStyle = sElement.arrowStyle;
		paintStyle.startArrowType = sElement.startArrowType;
		paintStyle.endArrowType = sElement.endArrowType;
		container.setPaintStyle(paintStyle);
		// set textBox
		if (sElement.textArea != null) {
			Rectangle2D textArea = (Rectangle2D) sElement.textArea.clone();
			container.addTextBox(textArea);
			TextBox textBox = container.getTextBox();
			textBox.setTextArea(textArea);
			CommittedTextContainer committedTextContainer
					= textBox.getCommittedTextContainer();
			committedTextContainer.setSerializableAttributedString(sElement.attributedString);
			textBox.textBoxInsets = (Insets) sElement.textBoxInsets.clone();
			textBox.textAlign = sElement.textAlign;
			textBox.lineSpace = sElement.lineSpace;
		}

		if (debug > 0) {
			System.out.println(" ++ OutputElementData.createShapeContainer "
					+ "container=" + container.toString());
		}
		return container;
	}

	public static ShapeContainer invertGroupContainer(SerializableElement sElement) {
		if (debug > 0) {
			System.out.println("\n** SerializableElementUtil invertGropShapeContainer **" + "\n"
					+ "- SerializableElementUtil" + sElement.toString());
		}
		ShapeContainer container = new ShapeContainer();
		container.setContainerIndex(sElement.containerIndex);
		container.setShapeId(sElement.shapeId);
		container.setConnectorTargetPermission(sElement.connectorTargetPermission);
		container.setConnectorPermission(sElement.connectorPermission);
		container.property = sElement.property;
		GroupElement groupElement = new GroupElement();
		container.setElement(groupElement);
		groupElement.setShapeContainer(container);
		if (debug > 0) {
			System.out.println(" ++ SerializableElementUtil.invertGropShapeContaine "
					+ "groupContainer=" + container.toString());
		}

		ArrayList childrenList = (ArrayList) sElement.childrenList.clone();
		for (int j = 0; j < childrenList.size(); j++) {
			String className = childrenList.get(j).getClass().getSimpleName();
			if (debug > 0) {
				System.out.println(" ++ SerializableElementUtil.convertToGroupContainer "
						+ "loop j=" + j + ", className=" + className);
			}
			//className equals String in DrawFileIo
			if (!className.equals("String")) {
				//className=="SerializableElement"
				SerializableElement childData = (SerializableElement) childrenList.get(j);
				//----------------------------------------------//
				ShapeContainer childContainer
						= invertShapeContainer(childData);
				//----------------------------------------------//  
				if (childContainer != null) {
					groupElement.addChildren(childContainer);
					childContainer.setParent(container);
				}
			}
		}
		if (debug > 0) {
			System.out.println("\n** SerializableElementUtil invertGropShapeContainer **" + "\n"
					+ "- ShapeContainer" + container.toShortString());
		}

		return container;
	}
}	
class DrawFileIoEx {
    public final String[] versions={"ver0.0", "ver1.0", "ver1_0"};
	private int depth=0;
    public int debug=0;
    
    public DrawFileIoEx(){}

	public void convertContainerList(ArrayList containerList, ArrayList serializableElementList) {
		int size = containerList.size();
		for (int i = 0; i < size; i++) {
			ShapeContainer container
					= (ShapeContainer) containerList.get(i);
		  //-----------------------------------------------------------------------//
			SerializableElement[] sElements= this.convertShapeContainer(container);
		  //-----------------------------------------------------------------------//
			for (int j = 0; j < sElements.length; j++) {
				serializableElementList.add(sElements[j]);
			}
		}
		if (debug >0) {
			System.out.println("\n**** DrawFileIo convertContainerList before convert ****");
			this.printContainerList("Print ContainerLis",
					containerList);
			System.out.println("\n**** DrawFileIo convertContainerList after convert ****");
			this.printSerializableElementList("Print SerializableElementList",
					serializableElementList);
		}
		return;
	}

// Convert to write format of ShapeContainer   //
	public SerializableElement[] convertShapeContainer(ShapeContainer container) {
		SerializableElement[] sElements = null;
		if (container.getContainerType() == container.SHAPE) {
			sElements = new SerializableElement[1];
		  //-----------------------------------------------------------------------//
			sElements[0] = SerializableElementUtilEx.convertSingleContainer(container);
			//sElements[0] = SerializableElementUtilEx.convertContainerSimply(container);
		  //-----------------------------------------------------------------------//
		} else {
		  //---------------------------------------------------//
			sElements = this.convertGroupContainer(container);
			//sElements = convertGroupContainerSimply(container);
		  //---------------------------------------------------//
		}
		return sElements;
	}

	public SerializableElement[] convertGroupContainer(ShapeContainer container) {
		SerializableElement[] sElements = null;
		ShapeContainer[] containers = container.getGroupedContainers();
		sElements = new SerializableElement[containers.length];
		for (int i = 0; i < containers.length; i++) {
		  //------------------------------------------------------------------------------//
			sElements[i] = SerializableElementUtilEx.convertShapeContainer(containers[i]);
			//sElements[i] = SerializableElementUtilEx.convertContainerSimply(containers[i]);
		   //-----------------------------------------------------------------------------//
		   if(sElements[i].containerType==ShapeContainer.GROUP){
			   ArrayList childrenList=sElements[i].childrenList;
			   for(int j=0;j<childrenList.size();j++){
				   String shapeId=((SerializableElement)childrenList.get(j)).shapeId;
				   sElements[i].childrenList.set(j, shapeId);
			   }
		   }
		}
		return sElements;
	}
		
	public SerializableElement[] convertGroupContainerSimply(ShapeContainer container) {
		SerializableElement[] sElements = null;
		ShapeContainer[] containers = container.getGroupedContainers();
		sElements = new SerializableElement[containers.length];
		for (int i = 0; i < containers.length; i++) {
		  //---------------------------------------------------------------------------//
			sElements[i] = SerializableElementUtilEx.convertContainerSimply(containers[i]);
		   //---------------------------------------------------------------------------//
		}
		return sElements;
	}

    public void invertContainerList(ArrayList containerList, ArrayList serializableElementList){
        int size=serializableElementList.size();
        for(int i=0;i<size;i++){
            SerializableElement sElement=(SerializableElement)serializableElementList.get(i);
            String parent=sElement.parent;
            if(parent==null||parent.equals("")){
			  //--------------------------------------------------------------//
                ShapeContainer container=this.invertShapeContainer(sElement,
                    serializableElementList);
			  //--------------------------------------------------------------//
                containerList.add(container);
            }
        }
        if(debug>0) {
			System.out.println("\n**** DrawFileIo invertContainerList before invert ****");
			printSerializableElementList("Print SerializableElementList",
					serializableElementList);

			System.out.println("\n**** DrawFileIo invertContainerList after invert ****");
            //printSerializableElementList(" ** Print SerializableElementList before invert", serializableElementList);
            printContainerList("Print ContainerList ", containerList);
        }
        return;
    }

    public ShapeContainer invertShapeContainer(SerializableElement sElement, 
			ArrayList serializableElementList){

		if (debug > 0) {
			System.out.println("\n** DrawFileIo invertShapeContainer before invert"
					+", sElement="+sElement.shapeId+ " **");
			System.out.println("Print SerializableElement\n"+sElement.toShortString());
		}
        ShapeContainer container=new ShapeContainer();
		if (sElement.containerType == ShapeContainer.SHAPE) {
			//System.out.println(" - DrawFileIo invertShapeContainer single shape");
			//single ShapeContainer
			container=SerializableElementUtilEx.invertSingleContainer(sElement);
		} else {
			if (debug > 0) System.out.println("- DrawFileIo invertShapeContainer group");
			//Group ShapeContainer
			container = SerializableElementUtilEx.invertGroupContainer(sElement);
			GroupElement groupElement=(GroupElement)container.getElement();
			ArrayList childrenList = (ArrayList) sElement.childrenList.clone();
			for (int j = 0; j < childrenList.size(); j++) {
				String childShapeId = (String) childrenList.get(j);
				//-----------------------------------------------------------------------------------------------//
				SerializableElement childData 
						= this.getSerializableElement(childShapeId, serializableElementList);
				//-----------------------------------------------------------------------------------------------//
				if (debug >0) {
					System.out.println("--  DrawFileIo invertShapeContainer --");
					System.out.println(" - childData[="+j+"]" + childData.toShortString());
				}
				//--------------------------------------------------------------------//
				ShapeContainer childContainer
						= this.invertShapeContainer(childData, serializableElementList);
				//--------------------------------------------------------------------//
				if (childContainer != null) {
					groupElement.addChildren(childContainer);
					childContainer.setParent(container);
				}
			}
		}
		container.setSelected(false);
		if (debug > 0) {
			System.out.println("\n** DrawFileIo invertShapeContainer after invert"
					+ ", sElement=" + sElement.shapeId + " **");
			System.out.println("Print ShapeContainer\n" + container.toVeryShortString());
		}
		return container;
	}

	public SerializableElement getPerfectSerializableElement(SerializableElement sElement,
			ArrayList serializableElementList) {
		++depth;
		if (debug > 0) {
			System.out.println("** getPerfectSerializableElement start depth=" + depth
					+ "\n - sElement=" + sElement.toVeryShortString()
					+ "\n--> getPerfectSerializableElement start end");
		}
		if (sElement.containerType == ShapeContainer.SHAPE) {
			return sElement;
		}
		// sElement is group
		if (debug > 0) {
			System.out.println("   -- sElement.childrenList.size()=" + sElement.childrenList.size());
		}
		String ObjectName = sElement.childrenList.get(0).getClass().getSimpleName();
		for (int i = 0; i < sElement.childrenList.size(); i++) {
			if (ObjectName.equals("String")) {
				String shapeId = (String) sElement.childrenList.get(i);
				SerializableElement childElement = this.getSerializableElement(shapeId, serializableElementList);
				if (debug > 0) {
					System.out.println("  - ObjectName=" + ObjectName
							+ ": childElement[" + i + "]=" + childElement.shapeId
							+ ", containerType=" + childElement.containerType
							+ ", parent=" + childElement.parent
							+ ", children=" + childElement.childrenList.size());
				}
				if (childElement.containerType == ShapeContainer.SHAPE) {
					sElement.childrenList.set(i, childElement);
					int remove = this.removeSerializableElement(shapeId, serializableElementList);
				} else {
					//sElement.childrenList.set(i, childElement);
					SerializableElement perfectChildElement
							= this.getPerfectSerializableElement(childElement, serializableElementList);
					sElement.childrenList.set(i, perfectChildElement);
					int remove = this.removeSerializableElement(shapeId, serializableElementList);
				}
			} else {
				SerializableElement childElement = (SerializableElement) sElement.childrenList.get(i);
				if (debug > 0) {
					System.out.println("  - ObjectName=" + ObjectName
							+ ": childElement[" + i + "]=" + childElement.shapeId
							+ ", parent=" + childElement.parent + ", children=" + childElement.childrenList.size());
				}
			}
		}
		if (debug > 0) {
			System.out.println("** getPerfectSerializableElement return depth=" + depth
					+ "\n - sElement=" + sElement.toVeryShortString()
					+ "\n--> getPerfectSerializableElement return end");
		}
		--depth;
		return sElement;
	}

    private SerializableElement getSerializableElement(String shapeId, ArrayList sElementList){
        SerializableElement target=null;
        int size=sElementList.size();
        for(int i=0;i<size;i++) {
            SerializableElement element=(SerializableElement)sElementList.get(i);
			if(element.shapeId.equals(shapeId)){
                target=element;
                break;
            }
        }
        return target;
    }
	private int removeSerializableElement(String shapeId, ArrayList sElementList) {
		SerializableElement target = null;
		int size = sElementList.size();
		int pos=-1;
		for (int i = 0; i < size; i++) {
			SerializableElement element = (SerializableElement) sElementList.get(i);
			if (element.shapeId.equals(shapeId)) {
				pos=i;
				sElementList.remove(element);
				break;
			}
		}
		if(debug>0) System.out.println("removeSerializableElement shapeId="+shapeId+", pos="+pos);
		return pos;
	}

	public boolean isDuplicatedNumber(ArrayList serializableElementList) {
		int size = serializableElementList.size();
		int[] numbers = new int[size];
		for (int i = 0; i < size; i++) {
			SerializableElement sElement = (SerializableElement) serializableElementList.get(i);
			String shapeId = sElement.shapeId;
			int id0 = shapeId.indexOf("-");
			int id1 = shapeId.indexOf(")");
			String num = shapeId.substring(id0 + 1, id1);
			numbers[i] = (new Integer(num)).intValue();
		}

		boolean duplicated = false;
		for (int i = 0; i < size; i++) {
			for (int j = 0; j < i; j++) {
				if (numbers[j] == numbers[i]) {
					duplicated = true;
					break;
				}
			}
		}
		return duplicated;
	}

	private void printContainerList(String title, ArrayList containerList) {
		System.out.println(title);
		for (int i = 0; i < containerList.size(); i++) {
			ShapeContainer container = (ShapeContainer) containerList.get(i);
			System.out.println(" - Container[" + i + "]=" + container.toVeryShortString());
		}
	}

	private void printSerializableElementList(String title, ArrayList sElementList) {
		System.out.println(title);
		for (int i = 0; i < sElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) sElementList.get(i);
			System.out.println(" - SerializableElement[" + i + "]=" + sElement.toVeryShortString());
		}
	}
	
	private void printPerfectSerializableElementList(String title, ArrayList sElementList) {
		System.out.println(title);
		for (int i = 0; i < sElementList.size(); i++) {
			SerializableElement sElement = (SerializableElement) sElementList.get(i);
			sElement=this.getPerfectSerializableElement(sElement, sElementList);
			System.out.println(" - SerializableElement[" + i + "]=" + sElement.toVeryShortString());
		}
	}
}

