package menu;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;


public class ButtonOfPulldownMenu extends JMenuBar {
    JMenu menu=null;
    PulldownMenuAction menuAction=new PulldownMenuAction(this);
    public static int debug=0;
    
    //public ButtonOfPulldownMenu() {};
    
    public ButtonOfPulldownMenu(String commandName, String tip) {
        this.setLayout(new FlowLayout(FlowLayout.LEADING, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu=new JMenuEx();
        this.add(this.menu);
        this.menu.setName(commandName);
        this.menu.setActionCommand(commandName);
        this.menu.addActionListener(this.menuAction);
        this.menu.setText(commandName);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
  }
    
    public ButtonOfPulldownMenu(String commandName, ImageIcon imageIcon, String tip) {
        this.setLayout(new FlowLayout(FlowLayout.LEADING, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu=new JMenu();
        this.menu.setName(commandName);
        this.menu.setActionCommand(commandName);
        this.menu.addActionListener(this.menuAction);
        this.add(this.menu);
        if(imageIcon!=null) this.menu.setIcon(imageIcon);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
  }
 
    public void setStandardButtonStyle() { 
        Border raisedBorder = new BevelBorder(BevelBorder.RAISED);
        this.menu.setBorder(raisedBorder);
        this.menu.setFont(MenuConstants.MenuFont);
        this.menu.setIconTextGap(0);
        this.menu.setOpaque(true);
        Color backGround=new Color(0xDDE8F3);
        this.menu.setBackground(backGround);
        this.menu.setForeground(Color.black);
    }

    public void setSelected(boolean selected) {
        this.menu.setSelected(selected);
    }
    
    public boolean isSelected() { 
        return this.menu.isSelected(); 
    }
    
    public JMenu getMenu(){
        return this.menu;
    }
    
    public void setMenuItems(String[] menuItemNames, ImageIcon[] imageIcons, 
            String[] accelerators){
        int acceleratorWidth=24;
        int textWidthMax=0, textHeightMax=0;
        for(int i=0;i<menuItemNames.length;i++) {
             Dimension textSize=this.getTextLayoutSize(menuItemNames[i], 
                     MenuConstants.MenuItemFont);
             int textWidth=(int)textSize.getWidth();
             int textHeight=(int)textSize.getHeight();
             if(accelerators!=null&&!accelerators[i].equals("")) textWidth+=acceleratorWidth;
             if(textWidth>textWidthMax) textWidthMax=textWidth;
             if(textHeight>textHeightMax) textHeightMax=textHeight;
        }
        int marginWidth=32, marginHeight=6;
        for(int i=0;i<menuItemNames.length;i++) {
           JMenuItem menuItem=new JMenuItem();
           if(accelerators!=null&&!accelerators[i].equals("")){
                KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
                menuItem.setAccelerator(stroke);
           }
           int imageWidth=0, imageHeight=0;
           int menuItemWidth=0;
           if(imageIcons[i]!=null){
                menuItem.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
                JLabel textLabel=new JLabel(" "+menuItemNames[i]+" ");
                textLabel.setPreferredSize(new Dimension(textWidthMax+marginWidth, 
                        textHeightMax+marginHeight));
                menuItem.add(textLabel);
                menuItemWidth+=textWidthMax+marginWidth;
                
                Image image=imageIcons[i].getImage();
                imageWidth=image.getWidth(null);
                imageHeight=image.getHeight(null);
                JLabel imageLabel=new JLabel(imageIcons[i]);
                imageLabel.setPreferredSize(new Dimension(imageWidth, imageHeight));
                menuItem.add(imageLabel);
                menuItemWidth+=imageWidth+marginWidth;
           } else{
               menuItem.setText(menuItemNames[i]);
               menuItemWidth+=textWidthMax+marginWidth;
           }

           int menuItemHeight=textHeightMax+marginHeight;
           menuItem.setPreferredSize(new Dimension(menuItemWidth, menuItemHeight));
           menuItem.setActionCommand(menuItemNames[i]);
           menuItem.addActionListener(this.menuAction);
           menuItem.setName(menuItemNames[i]);
           this.menu.add(menuItem);
        }
    }

    private Dimension getTextLayoutSize(String text, Font font){
        TextLayout textlayout=new TextLayout(text, font, 
                new FontRenderContext(null, false, false));
        int textWidth=(int)textlayout.getAdvance();
        int textHeight=(int)(textlayout.getAscent()+textlayout.getDescent());
        return new Dimension(textWidth, textHeight);
    }

    public void setSelectedMenuItem(String menuItemName){
        if(debug>0) System.out.println("** ButtonOfPullDownMenu.selectedMenuItem " +
                "menuItemName="+menuItemName);
        Border loweredBorder = new BevelBorder(BevelBorder.LOWERED);
        Component[] components=this.menu.getMenuComponents();
        for(int i=0;i<components.length;i++){
            JMenuItem menuItem=(JMenuItem)components[i];
            menuItem.setBackground(null);
            menuItem.setBorder(null);
            String name=menuItem.getName();
            //String name=menuItem.getActionCommand();
            if(Command.compareStrings(name, menuItemName)){
                menuItem.setBackground(Color.WHITE);
                menuItem.setBorder(loweredBorder);
            }
        }
    }

    public JMenuItem getMenuItem(JMenu menu, String menuItemName){
        JMenuItem menuItem=null;
        Component[] components=menu.getMenuComponents();
        for(int i=0;i<components.length;i++){
            String type=components[i].getClass().getSimpleName();
            if(type.equals("JMenu")) {
                JMenu subMenu=(JMenu)components[i];
                JMenuItem item=this.getMenuItem(subMenu, menuItemName);
                if(item!=null){
                    menuItem=item;
                    break;
                }
            }
            if(type.equals("JMenuItem")){
                JMenuItem item=(JMenuItem)components[i];
                String name=item.getName();
                if(Command.compareStrings(name, menuItemName)){
                    menuItem=item;
                    break;
                }
            }
            if(type.equals("JCheckBoxMenuItem")){
                JCheckBoxMenuItem item=(JCheckBoxMenuItem)components[i];
                String name=item.getName();
                if(Command.compareStrings(name, menuItemName)) {
                    menuItem=item;
                    break;
                }
            }
        }// for
        if(debug>0) System.out.println("  --> ButtonOfPullDownMenu.getMenuItem "
                +menuItemName+", return menuItem="+menuItem.getActionCommand());
        return menuItem;
    }

    public static ButtonOfPulldownMenu createPageButton(int width) {
        String tip="page";
        String commandName=Command.getCommandLowerString(Command.PAGE);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        
        String[] menuItemNames={"next page", "previous page", "last page", "top page",
                    "insert new page", "delete page", "page setup"};
        String[] imageName={"", "", "", "", "", "", ""};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                       MenuConstants.menuItemImageHeight);
           }
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }

    public static ButtonOfPulldownMenu createEditButton(int width) {
        String tip="edit";
        String commandName=Command.getCommandLowerString(Command.EDIT);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        
        String[] menuItemNames={"cut", "copy", "paste", "select all"};
        String[] imageName={"", "", "", "", ""};
        String[] accelerators={"ctrl X", "ctrl C", "ctrl V", "ctrl A"};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                       MenuConstants.menuItemImageHeight);
           }
        }
        button.setMenuItems(menuItemNames, itemIcons, accelerators);
        button.menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }

    public static ButtonOfPulldownMenu createAuxShapeButton(int width) {
        String tip="create auxiliary shape";
        String commandName=Command.getCommandLowerString(Command.AUX);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu=button.getMenu();
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
     //set text and ImageIcon menuItem
        String[] menuItemNames={ "center line", "line bisector", "angle bisector"};
        String[] imageName={"","","", "", "", "", "", "", "", ""};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth,
                       MenuConstants.menuItemImageHeight);
           }
        }
        button.setMenuItems(menuItemNames, itemIcons, null);

      //formating and registration to MenuUtil
        //menu.insertSeparator(2);
        //menu.insertSeparator(6);
        menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }

    public static ButtonOfPulldownMenu createShapeUtilButton(int width) {
        String tip="shape utility";
        String commandName=Command.getCommandLowerString(Command.UTIL);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu=button.getMenu();
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
     //set text and ImageIcon menuItem
        String[] menuItemNames={"shape format", "draw panel information", "add textbox", "delete textbox", "translate", "rotate", "flip",
         "modify shape", "cut shape", "connect curves", "combine", "break"};
        String[] imageName={"","","","","", "", "", "", "", "", "", ""};
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                       MenuConstants.menuItemImageHeight);
           }
        }
        button.setMenuItems(menuItemNames, itemIcons, null);

      //formating and registration to MenuUtil
        menu.insertSeparator(2);
        menu.insertSeparator(5);
        menu.insertSeparator(9);
        menu.insertSeparator(13);

        menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }
    
/*
    public static ButtonOfPulldownMenu createShapeUtilButton(int width) {
        boolean formalVersion=ObjectTable.formalVersion;
        String tip="shape utility";
        String commandName=Command.getCommandLowerString(Command.UTIL);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu=button.getMenu();
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
     //set text and ImageIcon menuItem
        String[] menuItemNames={"add textbox", "delete textbox", "translate", "rotate", "flip",
         "modify shape", "cut shape", "connect curves"};
        String[] testMenuItemNames={"add textbox", "delete textbox", "translate", "rotate", "flip",
         "modify shape", "cut shape", "connect curves", "combine", "break"};
        String[] imageName={"","","", "", "", "", "", "", "", ""};
        if(!formalVersion) menuItemNames=testMenuItemNames;
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
           itemIcons[i]=null;
           if(!imageName[i].equals("")){
               itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                       MenuConstants.menuItemImageHeight);
           }
        }
        button.setMenuItems(menuItemNames, itemIcons, null);

      //formating and registration to MenuUtil
        menu.insertSeparator(2);
        menu.insertSeparator(6);
        if(!formalVersion) menu.insertSeparator(10);
        menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }
*/
    
    public static ButtonOfPulldownMenu createSettingButton(int width) {
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        String commandName=Command.getCommandLowerString(Command.SETTING);
        String tip="draw assistant mark or shape";
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu=button.getMenu();
        button.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        PulldownMenuAction action=new PulldownMenuAction(button);
        String[] actionCommands=new String[3];
        
      // auto align
        commandName=Command.getCommandLowerString(Command.AUTO_ALIGN);
        JCheckBoxMenuItem autoAlignCheckBox = new JCheckBoxMenuItem(commandName);
        autoAlignCheckBox.addActionListener(action);
        actionCommands[0]=commandName;
        autoAlignCheckBox.setName(actionCommands[0]);
        autoAlignCheckBox.setActionCommand(actionCommands[0]);
        autoAlignCheckBox.setSelected(true);
        menu.add(autoAlignCheckBox);
        //menuUtil.setMenuComponent(autoAlignCheckBox);
        
      // connector function
        commandName=Command.getCommandLowerString(Command.ENABLE_CONNECTOR);
        JCheckBoxMenuItem connectorCheckBox = new JCheckBoxMenuItem("enable connector");
        connectorCheckBox.addActionListener(action);
        actionCommands[0]=Command.getCommandLowerString(Command.ENABLE_CONNECTOR);
        connectorCheckBox.setName(actionCommands[0]);
        connectorCheckBox.setActionCommand(actionCommands[0]);
        connectorCheckBox.setSelected(true);
        menu.add(connectorCheckBox);
        //menuUtil.setMenuComponent(connectorCheckBox);
        
      // connector auto tracking
        JMenuItem connectorDirItem=new JMenu("auto tracking option of connectors");
        actionCommands[0]=Command.getCommandLowerString(Command.FREE_DIRECTION);
        actionCommands[1]=Command.getCommandLowerString(Command.KEEP_XY_DIRECTION);
        
        JCheckBoxMenuItem noDir = new JCheckBoxMenuItem("free direction");
        JCheckBoxMenuItem xyDir = new JCheckBoxMenuItem("keep x/y direction");
        xyDir.setSelected(true);

        noDir.setName(actionCommands[0]);
        xyDir.setName(actionCommands[1]);
        noDir.setActionCommand(actionCommands[0]);
        xyDir.setActionCommand(actionCommands[1]);
        noDir.addActionListener(action);
        xyDir.addActionListener(action);
        ButtonGroup group = new ButtonGroup();
        group.add(noDir);
        group.add(xyDir);
        connectorDirItem.add(noDir);
        connectorDirItem.add(xyDir);
        menu.add(connectorDirItem);

       // node points
        actionCommands[0]=Command.getCommandLowerString(Command.HIGHLIGHTING_FOR_SELECTION);
        JCheckBoxMenuItem highlightingCheckBox = new JCheckBoxMenuItem(actionCommands[0]);
        highlightingCheckBox.addActionListener(action);
        highlightingCheckBox.setName(actionCommands[0]);
        highlightingCheckBox.setActionCommand(actionCommands[0]);
        highlightingCheckBox.setSelected(true);
        menu.add(highlightingCheckBox);
        
      // node points
        actionCommands[0]=Command.getCommandLowerString(Command.DRAW_NODE_POINTS);
        JCheckBoxMenuItem nodeCheckBox = new JCheckBoxMenuItem(actionCommands[0]);
        nodeCheckBox.addActionListener(action);
        nodeCheckBox.setName(actionCommands[0]);
        nodeCheckBox.setActionCommand(actionCommands[0]);
        menu.add(nodeCheckBox);

      //formating and registration to MenuUtil
        menu.setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
        menuUtil.setMenuComponent(button);
        if(debug>0) {
            menuUtil.printMenuComponent(button);
            String target=Command.getCommandLowerString(Command.KEEP_XY_DIRECTION);
            menuUtil.getChildComponent(button, target, "JCheckBoxMenuItem");
        }
        return button;
    }

    public static ButtonOfPulldownMenu createTextAlignButton() {
        //String commandName="text_align";
        String commandName=Command.getCommandLowerString(Command.TEXT_ALIGN);
        String buttonImage="text_align_left32T.png";
        String tip="text_align";
        String[] menuItemNames={"text align left", "text align center", "text align right"};
        String[] imageName={"text_align_left32T.png", "text_align_center32T.png",
                             "text_align_right32T.png"};
         
        ImageIcon buttonIcon=DrawImageIcon.get(buttonImage, MenuConstants.imageWidth, 
                       MenuConstants.imageHeight);
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName,
                buttonIcon, tip);
        button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                MenuConstants.buttonHeight));
         
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=null;
            if(!imageName[i].equals("")){
                itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.imageWidth, 
                        MenuConstants.imageHeight);
            }
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }
    
    public static ButtonOfPulldownMenu createFillColorChooserButton(boolean icon) {
        String commandName=Command.getCommandLowerString(Command.FILL_COLOR);
        String buttonImage="fill_color32T.png";
        String tip="fill color";
         ImageIcon buttonIcon=DrawImageIcon.get(buttonImage, MenuConstants.imageWidth, 
                 MenuConstants.imageHeight);
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         button.setPreferredSize(new Dimension(64, MenuConstants.buttonHeight));
         if(icon) {
             button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
             button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
         } 
         JMenuItem noFillItem=new JMenuItem("no fill");
         noFillItem.setActionCommand("no fill");
         noFillItem.setName(commandName);  //Component Name
         noFillItem.addActionListener(button.menuAction);
         button.menu.add(noFillItem);
         JMenuItem fillColorItem=new JMenuItem();
         fillColorItem.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
         Component colorChooser=ButtonOfColorChooser.createColorChooserButton("fill color", 64, "fill color");
         fillColorItem.add(colorChooser);
         fillColorItem.setPreferredSize(new Dimension(72,24));
         button.menu.add(fillColorItem);

         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         return button;
    }

    public static ButtonOfPulldownMenu createLineColorChooserButton(boolean icon) {
        //String commandName="line color";
        String commandName=Command.getCommandLowerString(Command.LINE_COLOR);
        String buttonImage="line_color32T.png";
        String tip="line color";
         ImageIcon buttonIcon=DrawImageIcon.get(buttonImage, MenuConstants.imageWidth, 
                 MenuConstants.imageHeight);
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         button.setPreferredSize(new Dimension(64, MenuConstants.buttonHeight));
         if(icon) {
             button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
             button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
         }
         JMenuItem noLineItem=new JMenuItem("no line");
         noLineItem.setActionCommand("no line");
         noLineItem.setName("no line");
         noLineItem.addActionListener(button.menuAction);
         button.getMenu().add(noLineItem);
         JMenuItem lineColorItem=new JMenuItem("line color");
         lineColorItem.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
         lineColorItem.setName("line color");
         Component colorChooser=ButtonOfColorChooser.createColorChooserButton("line color", 64, "line color");
         lineColorItem.add(colorChooser);
         lineColorItem.setPreferredSize(new Dimension(72,24));
         button.getMenu().add(lineColorItem);
         
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
    }

    public static ButtonOfPulldownMenu createLineWidthButton(boolean icon) {
        //String commandName="line style";
        String commandName=Command.getCommandLowerString(Command.LINE_WIDTH);
        String imageFilePath="line_style32T.png";
        String tip="line width";
        String[] imageName
                 ={"line0.5pt.png", "line1.0pt.png", "line1.5pt.png", "line2.0pt.png", "line2.5pt.png",
                   "line3.0pt.png", "line4.0pt.png", "line5.0pt.png", "line6.0pt.png"};
        String[] menuItemNames
                 ={"0.5 pt","1.0 pt", "1.5 pt", "2.0 pt", "2.5 pt", "3.0 pt", "4.0 pt", "5.0 pt", "6.0 pt"};

        ImageIcon buttonIcon=DrawImageIcon.get(imageFilePath, MenuConstants.imageWidth, 
                 MenuConstants.imageHeight);
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         if(icon) button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
         
        ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
        for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                    MenuConstants.menuItemImageHeight);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if(debug>0) menuUtil.printMenuComponent(button);
        return button;
    }
    
     public static ButtonOfPulldownMenu createLineStrokeButton(boolean icon) {
        //String commandName="dashed style";
        String commandName=Command.getCommandLowerString(Command.LINE_STROKE);
        String imageFilePath="dashed_style32T.png";
        String tip="line stroke";
         String[] imageName
                 ={"dashed_style_solid.png", "dashed_style_roundedDot.png", "dashed_style_squareDot.png", 
                   "dashed_style_dash.png", "dashed_style_dashDot.png", "dashed_style_dashDotDot.png"};
         String[] menuItemNames
                 ={"solid", "roundedDot", "squareDot", "dash", "dashDot", "dashDotDot"};
         ImageIcon buttonIcon=DrawImageIcon.get(imageFilePath, MenuConstants.imageWidth, 
                 MenuConstants.imageHeight);
         
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         if(icon) button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
         
         ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
         for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, MenuConstants.menuItemImageHeight);
         }
         button.setMenuItems(menuItemNames, itemIcons, null);
         button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
     }
     
     public static ButtonOfPulldownMenu createArrowStyleButton(boolean icon) {
        //String commandName="arrow style";
        String commandName=Command.getCommandLowerString(Command.ARROW_STYLE);
        String imageFilePath="arrow_style32T.png";
        String tip="arrow style";
         String[] imageName
                 ={"arrow_style1.png", "arrow_style2.png", "arrow_style3.png", "arrow_style4.png",
                   "arrow_style5.png", "arrow_style6.png", "arrow_style7.png"};
         String[] menuItemNames
                 ={"arrow style 1", "arrow style 2", "arrow style 3", "arrow style 4", 
                   "arrow style 5", "arrow style 6", "arrow style 7"};

         ImageIcon buttonIcon=DrawImageIcon.get(imageFilePath, MenuConstants.imageWidth, 
                 MenuConstants.imageHeight);
         
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         if(icon) button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
         
         ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
         for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.menuItemImageWidth, 
                    MenuConstants.menuItemImageHeight);
         }
         button.setMenuItems(menuItemNames, itemIcons, null);
         button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
    }
     
    public static ButtonOfPulldownMenu createZorderButton(boolean icon) {
        //String commandName="depth position";
        String commandName=Command.getCommandLowerString(Command.Z_ORDER);
        String imageFilePath="move_to_front32T.png";
        String tip="depth position";
        String[] menuItemNames={"move to front", "move to back", "move forward",
                                "move backward"};
        String[] imageName={"move_to_front32T.png", "move_to_back32T.png",
                            "move_forward32T.png", "move_backward32T.png"};
         
         
         ImageIcon buttonIcon=DrawImageIcon.get(imageFilePath, MenuConstants.imageWidth, 
                        MenuConstants.imageHeight);
         
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         if(icon) button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
         
         ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
         for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=null;
            if(!imageName[i].equals("")){
                itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.imageWidth, 
                        MenuConstants.imageHeight);
            }
         }
         button.setMenuItems(menuItemNames, itemIcons, null);
         button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
     }

    public static ButtonOfPulldownMenu createAlignButton(boolean icon) {
        //String commandName="align";
        String commandName=Command.getCommandLowerString(Command.ALIGN);
        String imageFilePath="align_left32T.png";
        String tip="align";
        String[] menuItemNames={"align_left", "align_center", "align_right",
                                "align_top", "align_middle", "align_bottom"};
        String[] imageName={"align_left32T.png", "align_center32T.png",
                            "align_right32T.png", "align_top32T.png",
                            "align_middle32T.png", "align_bottom32T.png"};
         
         
         ImageIcon buttonIcon=DrawImageIcon.get(imageFilePath, MenuConstants.imageWidth, 
                        MenuConstants.imageHeight);
         
         ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, tip);
         if(icon) button=new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
         
         ImageIcon[] itemIcons=new ImageIcon[menuItemNames.length];
         for(int i=0;i<menuItemNames.length;i++) {
            itemIcons[i]=null;
            if(!imageName[i].equals("")){
                itemIcons[i]=DrawImageIcon.get(imageName[i], MenuConstants.imageWidth, 
                        MenuConstants.imageHeight);
            }
         }
         button.setMenuItems(menuItemNames, itemIcons, null);
         button.setPreferredSize(new Dimension(MenuConstants.buttonWidth, 
                 MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
    }

    public static ButtonOfPulldownMenu createTestButton(int width) {
        String commandName=Command.getCommandLowerString(Command.TEST);
        String[] actionCommands=new String[3];
        JMenuItem[] menuItems=new JMenuItem[3];
        ButtonOfPulldownMenu button=new ButtonOfPulldownMenu(commandName, commandName);
        JMenu menu=button.getMenu();
        PulldownMenuAction action=new PulldownMenuAction(button);

      // Geometric test
         JMenuItem geomItem=new JMenuItem("geometric test  ");
         actionCommands[0]=Command.getCommandLowerString(Command.GEOMTEST);
         geomItem.setName(actionCommands[0]);
         geomItem.setActionCommand(actionCommands[0]);
         geomItem.addActionListener(action);
         menu.add(geomItem);
     //menuItem Display bounding box
         JMenuItem boxItem= new JCheckBoxMenuItem("draw bounding box");
         actionCommands[0]=Command.getCommandLowerString(Command.DRAW_BOUNDING_BOX);
         boxItem.setName(actionCommands[0]);
         boxItem.setActionCommand(actionCommands[0]);
         boxItem.addActionListener(action);
         menu.add(boxItem);
     //menuItem Display characteristic point
         JMenuItem charItem= new JCheckBoxMenuItem("draw characteristic points");
         actionCommands[0]=Command.getCommandLowerString(Command.DRAW_CHARACTERISTIC_PT);
         charItem.setName(actionCommands[0]);
         charItem.setActionCommand(actionCommands[0]);
         charItem.addActionListener(action);
         menu.add(charItem);
     //menuItem Display textLayout bound
         JMenuItem layoutItem= new JCheckBoxMenuItem("draw textLayout bound");
         actionCommands[0]=Command.getCommandLowerString(Command.DRAW_TEXTLAYOUT_BOUND);
         layoutItem.setName(actionCommands[0]);
         layoutItem.setActionCommand(actionCommands[0]);
         layoutItem.addActionListener(action);
         menu.add(layoutItem);

      // draw Unselectable Area
         JMenuItem unselectableItem= new JCheckBoxMenuItem("draw unselectable areas");
         actionCommands[0]=Command.getCommandLowerString(Command.UNSELECTABLE_AREAS);
         unselectableItem.setName(actionCommands[0]);
         unselectableItem.setActionCommand(actionCommands[0]);
         unselectableItem.addActionListener(action);
         //menu.add(unselectableItem);

      // draw connection point
        JMenuItem connectionItem=new JMenuItem("draw Connection mark");
         actionCommands[0]=Command.getCommandLowerString(Command.CONNECTION_TEST);
         connectionItem.setName(actionCommands[0]);
         connectionItem.setActionCommand(actionCommands[0]);
         connectionItem.addActionListener(action);
         //menu.add(connectionItem);

/*
     // temporary shapes
        JCheckBoxMenuItem tempShapeCheckBox = new JCheckBoxMenuItem(" keep temporary shapes ");
        tempShapeCheckBox.setName(commandName);
        tempShapeCheckBox.setSelected(false);
        tempShapeCheckBox.addActionListener(action);
        actionCommands[0]=Command.getCommandLowerString(Command.KEEP_TEMP_SHAPES);
        tempShapeCheckBox.setName(actionCommands[0]);
        tempShapeCheckBox.setActionCommand(actionCommands[0]);
        menu.add(tempShapeCheckBox);
     // temporary shapes
        JMenuItem clearTempShapes = new JMenuItem(" clear all temporary shapes ");
        clearTempShapes.addActionListener(action);
        actionCommands[0]=Command.getCommandLowerString(Command.CLEAR_ALL_TEMP_SHAPES);
        clearTempShapes.setName(actionCommands[0]);
        clearTempShapes.setActionCommand(actionCommands[0]);
        menu.add(clearTempShapes);
*/
      //setMenuItems
         button.getMenu().setPreferredSize(new Dimension(width, MenuConstants.buttonHeight));
         MenuUtil menuUtil=ObjectTable.getMenuUtil();
         menuUtil.setMenuComponent(button);
         if(debug>0) menuUtil.printMenuComponent(button);
         return button;
    }

}

class PulldownMenuAction extends AbstractAction{
    ButtonOfPulldownMenu buttonOfPulldownMenu;
    
    PulldownMenuAction(ButtonOfPulldownMenu buttonOfPulldownMenu){
        this.buttonOfPulldownMenu=buttonOfPulldownMenu;
    }
    
    public void actionPerformed(ActionEvent e) {
        int debug=MenuUtil.debug;
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- PulldownMenuAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        Object[] args=new Object[2];
        args[0]=commandName;
        args[1]=e;
        //int commandId=Command.getCommandId(commandName);
		int commandId=Command.getCommandId(this.buttonOfPulldownMenu.menu.getActionCommand());
        if(commandId<0){
            System.err.println("*** Error PulldownMenuAction: specified command not found;"+componentName);
            return;
        }
        Command command=new Command(commandId, Command.callFromMenu, args);
        ExecCommand execCommand=ObjectTable.getExecCommand("PulldownMenuAction");
		if(debug>0) System.out.println("- PulldownMenuAction.actionPerformed  command to be passed: " +command.toString());
        execCommand.exec(command);
    }//End of actionPerformed
}

class JMenuEx extends JMenu{
    Color baseColor=new Color(0xCDD8F3);
    
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size=this.getPreferredSize();
        //this.setComponent(size);
        double w=size.getWidth();
        double h=size.getHeight();
        if(w==0||h==0) return;
        Point2D p1=new Point2D.Double(0d,0.2*h);
        Point2D p2=new Point2D.Double(0d,0.8*h);
        Point2D p3=new Point2D.Double(0d,h);
        GradientPaint gradient0 =new GradientPaint(p1, Color.white, p2, baseColor,true);
        GradientPaint gradient1 =new GradientPaint(p2, baseColor, p3, baseColor,true);
        Rectangle2D rect0=new Rectangle2D.Double(0,0,w,h);
        Rectangle2D rect1=new Rectangle2D.Double(0,p2.getY(),w,h);
        
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gradient0);
        g2d.fill(rect0);
        g2d.setPaint(gradient1);
        g2d.fill(rect1);
        g2d.setColor(Color.black);
        FontMetrics metrics=g.getFontMetrics();
        double stringH=metrics.getDescent()+metrics.getAscent();
        double stringW=metrics.stringWidth(this.getText());
        double stringX=0d;
        if(w>stringW) stringX=0.5*(w-stringW);
        double stringY=h-metrics.getDescent();
        if(h>stringH) stringY=0.5*(h+stringH)-metrics.getDescent();
        g2d.drawString(this.getText(), (float)stringX,(float)stringY);
    }
}
