
package menu;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import java.io.File.*;
import DrawTop.*;
import util.*;

public class DialogOfFontMenu extends JDialog implements WindowListener{
    Point dialogLocation=new Point(570, 80);
    int debug=0;
    
    public DialogOfFontMenu(){
        super(ObjectTable.getDrawMain(), "Font menu");
        DrawMenu createMenu = new DrawMenu();
        JPanel fontStyleGroup = createMenu.createFontStyleGroup();
        this.getContentPane().add(fontStyleGroup);
        this.pack();
        Insets insets = this.getInsets();
        Component component = this.getComponent(0);
        Dimension size = component.getPreferredSize();
        this.setSize(new Dimension((int) size.getWidth() + insets.left + insets.right,
                (int) size.getHeight() + insets.top + insets.bottom));
        this.addWindowListener(this);
    }

    public void showDialog() {
        if(this.isVisible()) return;
        this.setVisible(true);
        Component owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)this.dialogLocation.getX(),
                owner.getY() + (int)this.dialogLocation.getY());
        this.setLocation(pos);
        if(debug>0) System.out.println("DialogOfFontMenu.showDialog Owner x,y="
                +owner.getX()+", "+owner.getY()+ ", dialog location="+Util.Pt(this.dialogLocation));
    }
    
    private void closeDialog() {
        Component owner = this.getOwner();
        Point dialogPT=this.getLocation();
        this.dialogLocation = new Point((int)dialogPT.getX()-owner.getX(),
                (int)dialogPT.getY()-owner.getY());
        this.setVisible(false);
        if(debug>0) System.out.println("closeDialog dialog location=" + Util.Pt(this.dialogLocation));
        return;
    }

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

}


