package shape;

import java.awt.*;
import java.awt.geom.*;
import DrawTop.*;
import geomExtension.*;

public class ConnectorMark{
    //ShapeElement shapeElement=null;
    
    public ConnectorMark(){}
    
    public void drawTargetMark(Graphics g, ShapeElement shapeElement){
        Graphics2D g2=(Graphics2D)g;
        double scale=DrawParameters.Scale;
        double markSize=4d/scale;
        Rectangle2D targetMark
                =new Rectangle2D.Double(-0.5d*markSize,-0.5d*markSize, markSize, markSize);
        Curve2D curve=shapeElement.getCurve2D();
        BasicStroke stroke=new BasicStroke((float)(1.5/scale), BasicStroke.CAP_SQUARE, 
                    BasicStroke.JOIN_MITER, 10.0f);
        Color currentColor=g2.getColor();
        AffineTransform currentTransform=g2.getTransform();
        Stroke currentStroke=g2.getStroke();
        g2.setStroke(stroke);
        double[] t=this.getTargetMarkPosition(shapeElement);
        for(int i=0;i<t.length;i++){
            Point2D position=curve.getP(t[i]);
            double moveX=position.getX();
            double moveY=position.getY();
            g2.translate(moveX, moveY);
            g2.setColor(Color.WHITE);
            g2.draw(targetMark);
            g2.setColor(Color.RED);
            g2.fill(targetMark);
            g2.translate(-moveX, -moveY);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }
    
    public void drawConnectorMark(Graphics g, ShapeElement shapeElement){
        Graphics2D g2=(Graphics2D)g;
        double scale=DrawParameters.Scale;
        double markSize=5d/scale;
        Rectangle2D connectorMark
                =new Rectangle2D.Double(-0.5d*markSize,-0.5d*markSize, markSize, markSize);
        Curve2D curve=shapeElement.getCurve2D();
        BasicStroke stroke=new BasicStroke((float)(2/scale), BasicStroke.CAP_SQUARE, 
                    BasicStroke.JOIN_MITER, 10.0f);
        Color currentColor=g2.getColor();
        AffineTransform currentTransform=g2.getTransform();
        Stroke currentStroke=g2.getStroke();
        g2.setStroke(stroke);
        double[] t=this.getConnectorMarkPosition(shapeElement);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, 
                RenderingHints.VALUE_ANTIALIAS_ON);
        for(int i=0;i<t.length;i++){
            Point2D position=curve.getP(t[i]);
            double moveX=position.getX();
            double moveY=position.getY();
            g2.translate(moveX, moveY);
            g2.setColor(Color.WHITE);
            g2.fill(connectorMark);
            g2.setColor(Color.RED);
            g2.draw(connectorMark);
            g2.translate(-moveX, -moveY);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, 
                RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }
    
    
    private double[] getTargetMarkPosition(ShapeElement shapeElement){
        double[] params=new double[0];
        if(shapeElement.getTypeE()==Command.GROUP) return params;
        Curve2D curve=shapeElement.getCurve2D();
        int numseg=curve.getNumOfSegments();
        int type=shapeElement.getTypeE();
        //double[] params=new double[0];
        
        if(type==Command.RECTANGLE||type==Command.IMAGE){
            params=new double[4];
            params[0]=0.5;
            params[1]=1.5;
            params[2]=2.5;
            params[3]=3.5;
        } else if(type==Command.ROUND_RECTANGLE){
            params=new double[4];
            params[0]=0.5;
            params[1]=2.5;
            params[2]=4.5;
            params[3]=6.5;
        } else if(type==Command.ELLIPSE){
            params=new double[4];
            params[0]=0.0;
            params[1]=0.25;
            params[2]=0.5;
            params[3]=0.75;
        //} else if(type==Command.LINE){
        } else {
            params=new double[numseg];
            for(int i=0;i<numseg;i++)
                params[i]=i+0.5d;
        }
        return params;
    }
    
    private double[] getConnectorMarkPosition(ShapeElement shapeElement){
        double[] params=new double[0];
        Curve2D curve=shapeElement.getCurve2D();
        if(curve==null) return params;
        int numseg=curve.getNumOfSegments();
        int type=shapeElement.getTypeE();
        
        if(type==Command.LINE){
            params=new double[2];
            params[0]=0.0;
            params[1]=1.0;
        } else if(type==Command.POLYLINE&&!curve.isClosed()){
            params=new double[2];
            params[0]=0.0;
            params[1]=numseg; 
        }
        return params;
    }
}
