package shape;

import java.awt.geom.*;
import java.util.*;
import DrawTop.*;
import geomExtension.*;
import util.*;

public class EllipseElement extends ShapeElement{

    public EllipseElement(){
        super();
    }

//ShapeElement
    public int getTypeE(){
        return Command.ELLIPSE;
    }
    public String getShapeIdString(){
         return "Ellipse";
    }

     public Point2D[] getEndPTs(){
         Point2D[] PTs=new Point2D[0];
         return PTs;
     }
//ShapeElement
    public Rectangle2D createTextArea(){
        Rectangle2D boundingBox=this.getBoundingBox();
        double x=boundingBox.getX();
        double y=boundingBox.getY();
        double w=boundingBox.getWidth();
        double h=boundingBox.getHeight();
        //double angle=Math.atan(h/w);
        double pai=Math.PI;
        double angle=pai/4;
        double W=w*Math.cos(angle);
        double H=h*Math.sin(angle);
        Rectangle2D textArea=new Rectangle2D.Double(x+0.5*w-0.5*W, y+0.5*h-0.5*H, W, H);
        if(textArea.getWidth()<DrawParameters.MinTextArea.getWidth()||
                textArea.getHeight()<DrawParameters.MinTextArea.getHeight()) return null;

        return textArea;
    }

//ShapeElement
    public SegmentModifier[] getSegmentModifiers(){
        SegmentModifier[] modifiers=new SegmentModifier[0];
        return modifiers;
    }
//ShapeElement
    public Point2D[] getModifierPTs(){
        Point2D[] PTs=new Point2D[0];
        return PTs;
    }

//ShapeElement
    //public void creationStart(int ctrl, Point2D point){}
    public void create(Point2D startPoint, Point2D currentPoint){}
    public void create(Rectangle2D boundingBox){
        //System.out.println(" *** EllipseElement create");
        double X=boundingBox.getX(); double Y=boundingBox.getY();
        double Width=boundingBox.getWidth(); double Height=boundingBox.getHeight();
        //double edgeLength=Math.min(Width, Height);
        this.curve2D=new Ellipse2DE(X, Y, Width, Height);
    }
    public void create(Point2D[] points){}

//ShapeElement
    public int getControlPTIndex(Point2D point){
        return -1;
    }
 
//ShapeElement

//ShapeElement
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint){};
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint){}
    public void modify(int ctrl, Point2D oldPoint, Point2D newPoint){}
    public void modifyPoint(Point2D point, String command){}
//ShapeElement
    public Object clone(){
        EllipseElement shapeElement=new EllipseElement();
        Ellipse2DE curve=(Ellipse2DE)curve2D.clone();
        shapeElement.setCurve2D(curve);
        return shapeElement;
    }
   
//ShapeElement
    public String toString(){
        String str="";
        if (this.curve2D == null) {
            str += "Ellipse: not defined";
            return str;
        }
        Ellipse2DE ellipse=(Ellipse2DE)this.curve2D;
        double x=ellipse.getX(); 
        double y=ellipse.getY();
        double width=ellipse.getWidth(); 
        double height=ellipse.getHeight();
        str="Ellipse x,y=("+String.valueOf((int)x)+","+String.valueOf((int)y)+")"
                +" width,height="+String.valueOf((int)width)+","+String.valueOf((int)height);
        return str;
    }

}