
package shape;
import java.awt.*;
import java.awt.geom.*;

public class TempShape {
    public String id="";
    public Shape shape=null;
    public Stroke stroke=null;
    public Color lineColor=null;
    public Color fillColor=null;
    
    public String message="";
    public Point2D messagePoint=null;
    public Color messageColor=null;
    public Font messageFont=null;
    

    public TempShape(String id, Shape shape, Stroke stroke, Color lineColor, Color fillColor,
            String message, Point2D messagePoint, Color messageColor, Font messageFont){
        this.id=id;
        this.shape=shape;
        this.stroke=stroke;
        this.lineColor=lineColor;
        this.fillColor=fillColor;
        this.message=message;
        this.messagePoint=messagePoint;
        if(messagePoint==null) this.messagePoint=this.getStringPosition();
        this.messageColor=messageColor;
        this.messageFont=messageFont;
    }
    
    public TempShape(String id, String message, Point2D messagePoint, Color messageColor, Font messageFont){
        this.id=id;
        this.shape=null;
        this.stroke=null;
        this.lineColor=null;
        this.fillColor=null;
        this.message=message;
        this.messagePoint=messagePoint;
        if(messagePoint==null) this.messagePoint=this.getStringPosition();
        this.messageColor=messageColor;
        this.messageFont=messageFont;
    }
    public String getId(){
        return this.id;
    }

    public BasicStroke getScaledStroke(double scale){
        BasicStroke stroke=(BasicStroke)this.stroke;
        BasicStroke newStroke=stroke;
        float lineW=(float)(stroke.getLineWidth()/scale);
        newStroke = new BasicStroke(lineW, BasicStroke.CAP_SQUARE,
                BasicStroke.JOIN_MITER, 1.0f, stroke.getDashArray(), 0.0f);
        return newStroke;
    }

    public Point2D getStringPosition(){
        double margin=5d;
        Point2D position=null;
        Rectangle2D bound=this.shape.getBounds2D();
        double x=bound.getX()+0.5*bound.getWidth()+margin;
        double y=bound.getY()+0.5*bound.getHeight();
        position=new Point2D.Double(x,y);
        return position;
    }
    
    public String toString(){
        String str="TempShape";
        str+=", id="+this.id;
        if(this.message!=null&&!this.message.equals("")) str+=", message"+this.message;
        return str;
    }
}

