
package shapeUtil;

import java.util.*;
import DrawTop.*;
import shape.*;
import geomExtension.*;
import javax.swing.*;
import textBox.*;
import util.*;


public class Combine{
    int debug=0;
    public Combine(){ }
    
    public void combine(){
        ContainerManager containerManager=ObjectTable.getContainerManager();
        ShapeContainer[] selectedContainers=containerManager.getSelectedContainers();
        if(selectedContainers.length<=1) return;
       //cloded check 
        Vector vector=new Vector();
        for(int i=0;i<selectedContainers.length;i++){
            ShapeContainer[] containers=selectedContainers[i].getGroupedSingleShapeContainers();
            for(int j=0;j<containers.length;j++){
                Curve2D curve2D=containers[j].getElement().getCurve2D();
                if(!curve2D.isClosed()){
                    vector.add(containers[j]);
                    containers[j].setBlinking(true);
                }
            }
        }
        int size=vector.size();
        if(size>0){
            BlinkingShape blinkingShape=ObjectTable.getBlinkingShape();
            blinkingShape.startBlinking();
            String message="";
            if(size==1) message=" Error: The specified shape is not closed!";
            else message=" Error: The specified shapes are not closed!";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(),
                message, "", JOptionPane.ERROR_MESSAGE);
            for(int j=0;j<size;j++){
                ShapeContainer container=(ShapeContainer)vector.get(j);
                container.setBlinking(false);
            }
            blinkingShape.stopBlinking();
            return;
        }
      //
        Segment2D moveSeg=new Segment2D(Segment2D.MOVETO, null);
        vector.clear();
        int indexMax=0;   
        PaintStyle newStyle=null;
        for(int i=0;i<selectedContainers.length;i++){
            ShapeContainer[] containers=selectedContainers[i].getGroupedSingleShapeContainers();
            for(int j=0;j<containers.length;j++){
                int containerIndex=containers[j].getContainerIndex();
                if(containerIndex>indexMax) {
                    indexMax=containerIndex;
                    newStyle=containers[j].getPaintStyle();
                }
                Curve2D curve2D=containers[j].getElement().getCurve2D();
                Segment2D[] segments=curve2D.getSegment2Ds();
                for(int k=0;k<segments.length;k++){
                    vector.add(segments[k].clone());
                }
                vector.add(moveSeg.clone());
            }
        }
        //int size=vector.size();
        Segment2D last=(Segment2D)vector.get(vector.size()-1);
        if(last.getType()==Segment2D.MOVETO) vector.remove(vector.size()-1);
        Segment2D[] segments=new Segment2D[vector.size()];
        for(int i=0;i<vector.size();i++){
            segments[i]=(Segment2D)vector.get(i);
        }
        GeneralCurve2DE combinedCurve=new GeneralCurve2DE(segments);
        GeneralCurveElement newElement=new GeneralCurveElement();
        newElement.setCurve2D(combinedCurve);
        ShapeContainer newContainer=new ShapeContainer();
        newContainer.setElement(newElement);
        newElement.setShapeContainer(newContainer);
        newContainer.setNewShapeId(containerManager, false);
        if(newStyle!=null) newContainer.setPaintStyle(newStyle);
        if(debug>=0) System.out.println("\nCombined newContainer "+newContainer.toString());
        //combinedCurve.test();
      //------------------------------------//
        containerManager.undoSetupStart();
      //-------------------------------------//
        containerManager.addContainer(newContainer);
        newContainer.setSelected(true);
        for(int i=0;i<selectedContainers.length;i++){
            containerManager.deleteContainer(selectedContainers[i]);
        }
      //--------------------------------//  
        containerManager.undoSetupEnd();
      //--------------------------------//
        //System.out.println("++ After add combinedContainer"+containerManager.toString());
    }
    
    public void breakCombine(){
        ContainerManager containerManager=ObjectTable.getContainerManager();
        ShapeContainer[] selectedContainers=containerManager.getSelectedContainers();
        //String str="";
        for(int i=0;i<selectedContainers.length;i++){
            ShapeContainer shapeContainer=selectedContainers[i];
            ShapeElement element=shapeContainer.getElement();
            if(element.getTypeE()!=Command.GENERAL_CURVE) continue;
            GeneralCurveElement gelement=(GeneralCurveElement)element;
            int index=shapeContainer.getContainerIndex();
            PaintStyle paintStyle=shapeContainer.getPaintStyle();
            String str="** breakCombine i="+i+" Changing to SimpleElements containerIndex="+index;
            ShapeElement[] elements=gelement.getSimpleShapeElements();
            if(elements.length>0){
                ShapeContainer[] newContainers=new ShapeContainer[elements.length];
                for(int j=0;j<elements.length;j++){
                    newContainers[j]=new ShapeContainer();
                    newContainers[j].setElement(elements[j]);
                    newContainers[j].setNewShapeId(containerManager, false);
                    newContainers[j].setPaintStyle((PaintStyle)paintStyle.clone());
                    str+="\n - newContainer["+j+"]: "+newContainers[j].toShortString();
                }
                if(debug>=0) System.out.println(str);
              //------------------------------------//
                containerManager.undoSetupStart();
              //-------------------------------------//
                containerManager.deleteContainer(shapeContainer);
                for(int j=0;j<elements.length;j++) {
                    newContainers[j].setSelected(true);
                    containerManager.addContainer(index, newContainers[j]);
                }
              //--------------------------------//  
                containerManager.undoSetupEnd();
              //--------------------------------//
            }
        }
        
    }
} // end of class