
package shapeUtil;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import menu.*;
import util.*;


public class GeometricTest extends JDialog{
    GeometricTestLS geometricTestLS=null;
    //JLabel messageLabel=null;
	JPanel messagePanel = new JPanel();
	Dimension messageLabelDimension=new Dimension(300, 14);
	//Dimension messagePanelDimension=new Dimension(300, 50);
    JLabel messageLabel1=new JLabel(" ");
    JLabel messageLabel2=new JLabel(" ");
    JRadioButton NormalLinesButton=null;
    JRadioButton ShortestLineButton=null;
    JRadioButton ProjectionLinesButton=null;
    JRadioButton IntersectionPtsButton=null;
	JRadioButton NormalLinesBetweenShapesButton=null;
	JRadioButton ShortestLinesBetweenShapesButton=null;
	int debug=0;

    
    public GeometricTest(){
        super(ObjectTable.getDrawMain(), "Geometric test");
        this.geometricTestLS=new GeometricTestLS();
        this.setName("Geometric test");
    }

    public void showDialog(){
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        GeometricTest dialog
                =(GeometricTest)menuUtil.getMenuComponent("Geometric test");
        if(dialog!=null) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), 
                    "geometric test dialog is already opened", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        GeometricTestAction action=new GeometricTestAction(this);
        this.addWindowListener(action);
        this.geometricTestLS.start();
      //set dialog position
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+50, owner.getY()+90);
        this.setLocation(centerP);
      //set dialog
        Container contentPane=this.getContentPane();
		//Container contentPane=this.getContentPane();

		//baseBox.setLayout(new FlowLayout(FlowLayout.LEADING, 0, 0));
        
    //messageLabel
		
		this.messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
		//this.messagePanel.setBackground(Color.green);
		Box messageBox = Box.createVerticalBox();
		messageBox.add(Box.createVerticalStrut(0));
		messageBox.add(this.messageLabel1);
		messageBox.add(Box.createVerticalStrut(0));
		messageBox.add(this.messageLabel2);
		messageBox.add(Box.createVerticalStrut(0));
		this.messageLabel1.setPreferredSize(this.messageLabelDimension);
		this.messageLabel2.setPreferredSize(this.messageLabelDimension);
		//this.messageLabel1.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
		//this.messageLabel2.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
		this.messagePanel.add(messageBox);
        this.showMessage("  Select button from the below");

    //RadioButton
        JPanel buttonPanel=new JPanel();
		buttonPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
        this.NormalLinesButton=new JRadioButton("Normal Lines From Mouse");
        this.ShortestLineButton=new JRadioButton("Sortest Line From Mouse");
        this.ProjectionLinesButton=new JRadioButton("Projection Lines From Mouse");
        this.IntersectionPtsButton=new JRadioButton("Intersection Pts");
		this.NormalLinesBetweenShapesButton=new JRadioButton("Normal Lines Between Shapes");
		this.ShortestLinesBetweenShapesButton=new JRadioButton("Shortest Line Between Shapes");
        this.NormalLinesButton.addActionListener(action);
        this.ShortestLineButton.addActionListener(action);
        this.ProjectionLinesButton.addActionListener(action);
        this.IntersectionPtsButton.addActionListener(action);
		this.NormalLinesBetweenShapesButton.addActionListener(action);
		this.ShortestLinesBetweenShapesButton.addActionListener(action);
        this.NormalLinesButton.setSelected(true);
		
        ButtonGroup group=new ButtonGroup();
        group.add(this.NormalLinesButton); 
        group.add(this.ShortestLineButton);
        group.add(this.ProjectionLinesButton);
        group.add(this.IntersectionPtsButton);
		group.add(this.NormalLinesBetweenShapesButton);
		group.add(this.ShortestLinesBetweenShapesButton);
        buttonPanel.add(this.NormalLinesButton);
        buttonPanel.add(this.ShortestLineButton);
        buttonPanel.add(this.ProjectionLinesButton);
        buttonPanel.add(this.IntersectionPtsButton);
		buttonPanel.add(this.NormalLinesBetweenShapesButton);
		buttonPanel.add(this.ShortestLinesBetweenShapesButton);
		buttonPanel.setPreferredSize(new Dimension(300,150));
        
// layout the dialog
		//Container contentPane=this.getContentPane();
		JPanel basePanel = new JPanel();
		contentPane.add(basePanel);
		BoxLayout baseBox=new BoxLayout(basePanel, BoxLayout.LINE_AXIS);
		//basePanel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
		//basePanel.setOpaque(true);
		//basePanel.setBackground(Color.cyan);
		basePanel.add(this.messagePanel);
		basePanel.add(buttonPanel);

		this.setPreferredSize(new Dimension(310,280));
        this.pack();
        this.setVisible(true);
		
        menuUtil.setMenuComponent(this);
        return;
    }
    
    protected void showMessage(String message){
        this.messageLabel1.setForeground(Color.BLUE);
        this.messageLabel2.setForeground(Color.BLUE);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index=message.indexOf("\n");
        String str1="";
        String str2="";
        if(index>0){
            str1=message.substring(0, index);
            if(index+1<message.length()){
                str2=message.substring(index+1, message.length());
            }
        }else{
			str1=message;
		}
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
		if(debug>0) System.out.println("** GeometricTest JDialog size="
				+Util.Dim(this.getSize()));
    }
    
    protected GeometricTestLS getGeometricTestLS(){
        return this.geometricTestLS;
    }
    
} 
class GeometricTestAction extends AbstractAction  implements WindowListener {
    GeometricTest dialog=null;
    int debug=0;
    
    public GeometricTestAction(GeometricTest dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- GeometricTestAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        GeometricTestLS geometricTestLS=this.dialog.getGeometricTestLS();
        
        if(commandName.equals("Normal Lines From Mouse")){
            geometricTestLS.setMode(GeometricTestLS.NormalLinesFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if(commandName.equals("Sortest Line From Mouse")){
            geometricTestLS.setMode(GeometricTestLS.ShortestLineFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if(commandName.equals("Projection Lines From Mouse")){
            geometricTestLS.setMode(GeometricTestLS.ProjectionLinesFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if(commandName.equals("Intersection Pts")){
            geometricTestLS.setMode(GeometricTestLS.IntersectionPts_Mode);
            this.dialog.showMessage("  Select shapes and drag them onto other shapes!");
        }
        if(commandName.equals("Normal Lines Between Shapes")){
            geometricTestLS.setMode(GeometricTestLS.NormalLinesBetweenShapes_Mode);
            this.dialog.showMessage("  Select shapes and drag them!");
        }
        if(commandName.equals("Shortest Line Between Shapes")){
            geometricTestLS.setMode(GeometricTestLS.ShortestLineBetweenShapes_Mode);
            this.dialog.showMessage("  Select shapes and drag them!");
        }
    }//End of actionPerformed
 
    private void closeDialog(){
        this.dialog.setVisible(false);
        this.dialog.getGeometricTestLS().end();
        DrawShapeUtil.clearTempShape("geomTest");
        ObjectTable.getDrawPanel().repaint();
        MenuUtil menuUtil=ObjectTable.getMenuUtil();
        Component component=menuUtil.getMenuComponent(this.dialog.getName());
        if(component!=null) menuUtil.removeMenuComponent(component);
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

} // end of class