package util;

import java.awt.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import DrawTop.*;
import shape.*;

public class PageManager {
    DrawMain main=ObjectTable.getDrawMain();
    DrawPanel drawPanel=ObjectTable.getDrawPanel("");
    DrawFileIo drawFileIo=ObjectTable.getDrawFileIo();
    private ArrayList PageList=null;
    private int CurrentPage=0;
    public String[] versions={"ver0.0", "ver1.0"};
    public static int debug=0;
    
    public PageManager(){}

    public DrawFileIo getDrawFileIo(){
        return this.drawFileIo;
    }
    
    public  void init(){
        this.PageList=new ArrayList();
        this.CurrentPage=0;
        this.insertNewPage();
        this.initApp();
    }
    
    public  void setPageList(ArrayList pageList){
        PageList=pageList;
    }

    public  ArrayList getPageList(){
        return PageList;
    }
    
    public int getCurrentPage(){
        return this.CurrentPage;
    }

    public void setCurrentPage(int page){
        this.CurrentPage=page;
    }

    public UndoDrawManager getUndoDrawManager(String callFrom){
        UndoDrawManager undoDrawManager=null;
        if(this.CurrentPage>0){
            PageData pageData=(PageData)PageList.get(this.CurrentPage-1);
            undoDrawManager=pageData.getUndoDrawManager();
        }
        if(undoDrawManager==null){
            System.out.println("*** Error: PageManager.getUndoDrawManager undoDrawManager=null" +
                ", current page"+this.CurrentPage+", call from="+callFrom);
        }
        return undoDrawManager;
    }

    private void initApp(){
        ObjectTable.getContainerManager().deSelectAll();
        DrawPanel drawPanel=ObjectTable.getDrawPanel();
        if(drawPanel!=null&&ObjectTable.getTempShapeManager("PageManager")!=null){
            ObjectTable.getTempShapeManager("PageManager").clearAllTempShapes();
        }
    }

    public void showTopPage(){
        this.initApp();
        int topPage=1;
        this.saveCurrentPage();
        this.showPage(topPage);
    }

    public void showLastPage(){
        this.initApp();
        int lastPage=PageList.size();
        this.saveCurrentPage();
        this.showPage(lastPage);
    }

    public void showNextPage(){
        this.initApp();
        this.saveCurrentPage();
        int returnCode=this.showPage(this.CurrentPage+1);
        if(returnCode<0){
            JOptionPane.showMessageDialog(main, "no next page", "", 
                JOptionPane.ERROR_MESSAGE);
            return;
        }
    }

    public void showPreviousPage(){
        this.initApp();
        this.saveCurrentPage();
        int returnCode=this.showPage(this.CurrentPage-1);
        if(returnCode<0){
            JOptionPane.showMessageDialog(main, "no previouse page", "", 
                JOptionPane.ERROR_MESSAGE);
            return;
        }
    }

    public void insertNewPage(){
        this.initApp();
        if(this.CurrentPage>0) this.saveCurrentPage();
        boolean before=false;
        if(this.CurrentPage>0) {
            Object[] possibleValues = {"insert after this page", "insert before this page" };
            Object selectedValue = JOptionPane.showInputDialog(main, "Choose one", "Input",
                JOptionPane.INFORMATION_MESSAGE, null,possibleValues, possibleValues[0]);
            if(selectedValue==null) return;
            if(selectedValue.equals("insert before this page")) before=true;
        }
		
        ViewData viewData=ViewUtil.getDefaultViewData();
        if(before) {
            if(this.CurrentPage==0) this.CurrentPage=1;
        } else{
            this.CurrentPage++;
        }
      //------------------------------------------------------------------------------//  
        PageData pageData
                =new PageData(new ArrayList(), viewData, 
                 new UndoDrawManager());
      //-----------------------------------------------------------------------------//   
        PageList.add(this.CurrentPage-1, pageData);
        if(debug>0) System.out.println("** PageManager.insertNewPage newPage="+
                    this.CurrentPage);
        this.showPage(this.CurrentPage);
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
    }

    public void deletePage(){
        this.initApp();
        if(debug>0) System.out.println("** deletePage start page="+this.CurrentPage+
                ", PageList.size()="+PageList.size());
        int returnCode=JOptionPane.showConfirmDialog(main, "Delete this page?" +
                " Undo is not supported for this operarion", "", 
                JOptionPane.YES_NO_OPTION);
        if(returnCode!=JOptionPane.YES_OPTION) return;
        PageList.remove(this.CurrentPage-1);
        if(this.CurrentPage<=PageList.size()) this.showPage(this.CurrentPage);
        else if(this.CurrentPage-1>0) this.showPage(--this.CurrentPage);
        else{
            this.CurrentPage=0;
            this.insertNewPage();
            JOptionPane.showMessageDialog(main, "all page deteted", "", 
                JOptionPane.ERROR_MESSAGE);
        }
        System.out.println(" -- deletePage end, PageList.size()="+PageList.size());
    }
    
    public void movePage(int selectedPage, int moveTo){
        if(debug>0) System.out.println("** movePage  current page="+this.CurrentPage+
                ", PageList.size()="+PageList.size());
        this.initApp();
        if(selectedPage<1) return;
        Object selectedPageData=PageList.get(selectedPage-1);
        if(moveTo>=1&&moveTo<=PageList.size()+1){
            PageList.add(moveTo-1,selectedPageData);
        } else{
            String message="page can't be moved, page="+selectedPage+", moveTo="+moveTo;
            return;
        }
        if(moveTo<=selectedPage){
            PageList.remove(selectedPage);
            this.CurrentPage=moveTo;
            this.showPage(this.CurrentPage);
        } else{
            PageList.remove(selectedPage-1);
            this.CurrentPage=moveTo-1;
            this.showPage(this.CurrentPage);
        }
        if(debug>0)System.out.println(" -- movePage end, PageList.size()="+PageList.size());
    }
   
    public void pageSetup(int sheetSize, int orientation){
        System.out.println("PageManager.pageSetup page size="+
                DrawParameters.SheetSizeString[sheetSize]+
                ", orientation="+DrawParameters.SheetOrientationString[orientation]);
        DrawParameters.SheetSize=sheetSize;
        DrawParameters.SheetOrientation=orientation;
        double scale=DrawParameters.Scale;
      //--------------------------------------------//  
        ViewUtil.setView(scale, new Point(0,0));
      //--------------------------------------------//    
        this.saveCurrentPage();
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
    }
    
    public int showPage(int selectedPage){
        if(debug>0) System.out.println("** PageManager.showPage page="+selectedPage+
                ", PageList.size()="+PageList.size()+", currentPage="+this.CurrentPage);
        int size=PageList.size();
        PageData pageData=null;
        if(selectedPage>=1&&selectedPage<=size){
            pageData=(PageData)this.PageList.get(selectedPage-1);
            this.CurrentPage=selectedPage;
        } else{
            if(debug>0) System.out.println("** PageManager.showPage selectedPage not found+" +
                    " selectedPage="+selectedPage);
            return -1;
        }
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        containerManager.setContainerList(pageData.ContainerList);
        ViewUtil.setViewData(pageData.viewData);
        ObjectTable.undoDrawManager=pageData.getUndoDrawManager();
        pageData.getUndoDrawManager().changeButtonState();
        if(debug>0) System.out.println("** PageManager.showPage UndoDrawManager()="+
                pageData.getUndoDrawManager().toString());
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
        return 0;
    }
    
	/* 2016.04.08 deleted, Hereafter use saveCurrentPage().
    public void savePageAtFileSave(){
        this.saveCurrentPage();
    }
	*/
	// Revised from private void savePage(int page)  2016.04.08
    public void saveCurrentPage(){
        this.initApp();
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        ArrayList containerList=containerManager.getContainerList();
        ViewData viewData=ViewUtil.getViewData();
        PageData pageData=(PageData)this.PageList.get(this.CurrentPage-1);
        pageData.setContainerList(containerList);
        pageData.setViewData(viewData);
        if(debug>0) System.out.println(" -- savePage page="+this.CurrentPage+
                "\n   page data: "+pageData.toString());
        try{
            PageList.set(this.CurrentPage-1, pageData);
        } catch (IndexOutOfBoundsException e){
            System.err.println("*** Error PageManager.savePage; current page not found" +
                    ", index="+(this.CurrentPage-1));  
        }
    }
	
	/*
	// 2016.04.08 deleted
    private void savePage(int page){
        this.initApp();
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        ArrayList containerList=containerManager.getContainerList();
        ViewData viewData=ViewUtil.getViewData();
        PageData pageData=(PageData)this.PageList.get(page-1);
        pageData.setContainerList(containerList);
        pageData.setViewData(viewData);
        if(debug>0) System.out.println(" -- savePage page="+page+
                "\n   page data: "+pageData.toString());
        try{
            PageList.set(page-1, pageData);
        } catch (IndexOutOfBoundsException e){
            System.err.println("*** Error PageManager.savePage; current page not found" +
                    ", index="+(page-1));  
        }
    }
	*/
    public ArrayList getContainerList(int page){
        PageData pageData=(PageData)this.PageList.get(page-1);
        ArrayList containerList=pageData.ContainerList;
        return containerList;
    }

    public ViewData getViewData(int page){
        PageData pageData=(PageData)this.PageList.get(page-1);
        ViewData viewData=pageData.viewData;
        return viewData;
    }

} //End of PageManager


