package util;

import java.text.*;
import textBox.*;
import java.awt.datatransfer.*;
import java.io.*;

public class TransferableAttributedString implements Transferable, Serializable{
   private SerializableAttributedString sString;
    
    public TransferableAttributedString(AttributedCharacterIterator iterator){
        this.sString=new SerializableAttributedString(iterator);
    } // end of constructor
    
//Transferable method
    public Object getTransferData(DataFlavor flavor)
        throws UnsupportedFlavorException {
        if (flavor==Edit.AttributedStringFlavor||
                flavor.equals(Edit.AttributedStringFlavor)) {
            return this.sString;
        }if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.sString.getString();
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
    }
//Transferable method
    public DataFlavor[] getTransferDataFlavors(){
        DataFlavor[] flavors=new DataFlavor[2];
        flavors[0]=Edit.AttributedStringFlavor;
        flavors[1]=DataFlavor.stringFlavor;
        return flavors;
    }
//Transferable method
    public boolean isDataFlavorSupported(DataFlavor flavor){
        boolean supported=false;
        if(flavor==Edit.AttributedStringFlavor) supported=true;
        if(flavor==DataFlavor.stringFlavor) supported=true;
        return supported;
    }
      
} //End of class
