/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.DrawWindowAdapter;
import DrawTop.ExecCommand;
import DrawTop.ExecPopupMenu;
import DrawTop.ListenerPanel;
import DrawTop.MousePositionLS;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import menu.ButtonOfFontMenu;
import menu.CustomColorChooserDialog;
import menu.DrawMenu;
import menu.GuidancePanel;
import menu.MenuUtil;
import menu.PopupPulldownMenu;
import menu.StatusPanel;
import shape.BlinkingShape;
import shape.TempShapeManager;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ConnectionLS;
import shapeUtil.CreateAuxShape;
import shapeUtil.MoveResizeShapeLS;
import util.ContainerManager;
import util.DrawFileIo;
import util.Edit;
import util.FileIo;
import util.SysErrOutput;
import util.UndoDrawManager;
import util.ViewUtil;

public class DrawMain
extends JFrame {
    static int debug = 0;

    public static void main(String[] args) {
        DrawMain drawMain;
        DrawMain jframe = drawMain = new DrawMain();
        drawMain.setName("DrawMain-JFrame");
        ObjectTable.main = drawMain;
        DrawParameters parameters = new DrawParameters();
        drawMain.setFrame();
        if (debug > 0) {
            ObjectTable.menuUtil.printMenuComponentList();
        }
    }

    void setFrame() {
        GuidancePanel guidancePanel;
        UndoDrawManager undoDrawManager;
        JViewport viewport;
        ListenerPanel listenerPanel;
        StatusPanel statusPanel;
        JTabbedPane tabbedPane;
        MenuUtil menuUtil;
        this.setTitle("DrawTop");
        this.setDefaultCloseOperation(3);
        DrawWindowAdapter adaptor = new DrawWindowAdapter(this);
        this.addWindowListener(adaptor);
        this.addWindowFocusListener(adaptor);
        this.addWindowStateListener(adaptor);
        new Command();
        ObjectTable.menuUtil = menuUtil = new MenuUtil();
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.setLayout(null);
        glassPane.setVisible(true);
        glassPane.setOpaque(false);
        ObjectTable.glassPane = glassPane;
        Container contentPane = this.getContentPane();
        contentPane.setName("ContentPane");
        contentPane.setLayout(new BorderLayout());
        ObjectTable.tabbedPane = tabbedPane = new JTabbedPane();
        contentPane.add((Component)tabbedPane, "North");
        DrawMenu createMenu = new DrawMenu();
        JPanel homeTabPanel = createMenu.createHomeTabPanel();
        JPanel shapeTabPanel = createMenu.createShapeTabPanel();
        JPanel helpTabPanel = createMenu.createHelpTabPanel();
        tabbedPane.addTab("Home", homeTabPanel);
        tabbedPane.addTab("Shape", shapeTabPanel);
        tabbedPane.addTab("Help", helpTabPanel);
        ObjectTable.statusPanel = statusPanel = new StatusPanel();
        contentPane.add((Component)statusPanel, "South");
        PopupPulldownMenu.createDrawPanelPopupMenu();
        PopupPulldownMenu.createSingleShapePopupMenu();
        PopupPulldownMenu.createGroupShapePopupMenu();
        PopupPulldownMenu.createTextBoxPopupMenu();
        ObjectTable.tempShapeManager = new TempShapeManager();
        ObjectTable.listenerPanel = listenerPanel = new ListenerPanel();
        ListenerPanel drawPanel = listenerPanel;
        ObjectTable.drawPanel = drawPanel;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setName("ScrollPane");
        ObjectTable.scrollPane = scrollPane;
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        ObjectTable.viewport = viewport = new JViewport();
        viewport.setName("ViewPort");
        viewport.setOpaque(false);
        JPanel viewPanel = (JPanel)drawPanel.getParent();
        if (viewPanel == null) {
            viewPanel = new JPanel();
            viewPanel.setName("ViewPanel");
            viewPanel.add((Component)drawPanel, 0);
            viewPanel.setOpaque(true);
            viewPanel.setBackground(Color.LIGHT_GRAY);
        }
        viewPanel.setAutoscrolls(true);
        viewport.setView(viewPanel);
        scrollPane.setViewport(viewport);
        contentPane.add((Component)scrollPane, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double w0 = screenSize.getWidth();
        double h0 = screenSize.getHeight();
        double w = w0;
        double h = h0;
        int frameHeight = 560;
        if (ObjectTable.videoCapture) {
            frameHeight = 480;
        }
        if (h0 > (double)frameHeight) {
            double scale = (double)frameHeight / h0;
            w = screenSize.getWidth() * scale;
            h = screenSize.getHeight() * scale;
            System.out.println("Screen size w0=0, h0=" + h0 + ", Screen w=" + w + ", h=" + h);
        }
        screenSize.setSize(w, h);
        scrollPane.setPreferredSize(screenSize);
        ObjectTable.containerManager = new ContainerManager();
        ObjectTable.undoDrawManager = undoDrawManager = new UndoDrawManager();
        ObjectTable.mousePositionLS = new MousePositionLS();
        ObjectTable.ConnectionLS = new ConnectionLS();
        ObjectTable.selectionLS = new SelectionLS();
        ObjectTable.createAuxShape = new CreateAuxShape();
        ObjectTable.moveResizeShapeLS = new MoveResizeShapeLS();
        ObjectTable.fileIo = new FileIo();
        ObjectTable.drawFileIo = new DrawFileIo();
        ObjectTable.edit = new Edit();
        ObjectTable.viewUtil = new ViewUtil();
        ObjectTable.sysErrOutput = new SysErrOutput();
        ObjectTable.sysErrOutput.openErrorFile();
        ObjectTable.execCommand = new ExecCommand();
        ObjectTable.execPopupMenu = new ExecPopupMenu();
        ObjectTable.guidancePanel = guidancePanel = new GuidancePanel();
        ObjectTable.componentLibDialog = new ComponentLibDialog();
        ObjectTable.buttonOfFontMenu = (ButtonOfFontMenu)menuUtil.getMenuComponent("font");
        ObjectTable.customColorChooserDialog = new CustomColorChooserDialog(this);
        ObjectTable.blinkingShape = new BlinkingShape(drawPanel);
        this.pack();
        this.setVisible(true);
        ObjectTable.fileIo.fileNew();
    }

    @Override
    public void setFont(Font font) {
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("MenuItem.acceleratorFont", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", font);
        UIManager.put("Menu.font", font);
        UIManager.put("Menu.acceleratorFont", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("ViewPort.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
    }
}

