/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.Command;
import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ExecCommandUtil;
import DrawTop.MousePositionInfo;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import menu.ButtonOfPulldownMenu;
import menu.DialogOfDrawPanel;
import menu.DialogOfPageLayout;
import menu.DialogOfPageSetup;
import menu.DialogOfShapeFormat;
import menu.DialogOfZoom;
import menu.MenuUtil;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.ChangeShapeElement;
import shapeUtil.Combine;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ConnectCurves;
import shapeUtil.ConnectionLSTest;
import shapeUtil.ConnectionUtil;
import shapeUtil.CreateAuxShape;
import shapeUtil.CreateShapeLS;
import shapeUtil.CutShape;
import shapeUtil.ExtendCurve;
import shapeUtil.Flip;
import shapeUtil.GeometricTest;
import shapeUtil.ModifyShape;
import shapeUtil.Rotate;
import shapeUtil.Translate;
import textBox.FontStyle;
import util.ContainerManager;
import util.Edit;
import util.FileIo;
import util.PageManager;
import util.UndoDrawManager;
import util.ViewUtil;

public class ExecCommand {
    public ExecCommandUtil execUtil;
    private int currentCommandId = -1;
    private int previousCommandId = -1;
    public CreateShapeLS activeCreateShapeLS = null;
    Point2D clickedPoint = null;
    public static int debug = 0;
    int idNumber = 0;

    public ExecCommand() {
        ObjectTable.execCommand = this;
        this.execUtil = new ExecCommandUtil();
    }

    public void exec(Command command) {
        ShapeContainer[] containers;
        int commandId;
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        PageManager pageManager = ObjectTable.getPageManager("ExecCommand");
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        FileIo fileIO = ObjectTable.getFileIo("");
        Edit edit = ObjectTable.getEdit("");
        DrawShapeUtil.clearTempShape("ConnectedMessage");
        DrawShapeUtil.clearTempShape("ConnectionMark");
        DrawShapeUtil.clearTempShape("OnlinePT");
        DrawShapeUtil.clearTempShape("ConnectedPT");
        DrawShapeUtil.clearTempShape("Auto_align");
        this.currentCommandId = commandId = command.getCommandId();
        if (commandId < 0) {
            System.err.println("*** Error ExecCommand.exec: specified command not found;" + command);
            return;
        }
        int callFrom = command.getCallFrom();
        Object[] params = command.getParams();
        if (debug > 0) {
            System.out.println("- ExecCommand.exec " + command.toString());
        }
        if (this.activeCreateShapeLS != null && callFrom != 4) {
            this.activeCreateShapeLS.abort();
            this.activeCreateShapeLS = null;
        }
        switch (commandId) {
            case 0: {
                fileIO.fileNew();
                break;
            }
            case 1: {
                fileIO.fileOpen();
                break;
            }
            case 2: {
                fileIO.fileSave();
                break;
            }
            case 3: {
                fileIO.fileSaveAs();
                break;
            }
            case 4: {
                String menuItem = (String)params[0];
                if (Command.getCommandId(menuItem) == 5) {
                    pageManager.showNextPage();
                }
                if (Command.getCommandId(menuItem) == 6) {
                    pageManager.showPreviousPage();
                }
                if (Command.getCommandId(menuItem) == 7) {
                    pageManager.showLastPage();
                }
                if (Command.getCommandId(menuItem) == 8) {
                    pageManager.showTopPage();
                }
                if (Command.getCommandId(menuItem) == 9) {
                    pageManager.insertNewPage();
                }
                if (Command.getCommandId(menuItem) == 10) {
                    pageManager.deletePage();
                }
                if (Command.getCommandId(menuItem) == 12) {
                    DialogOfPageSetup dialog = new DialogOfPageSetup();
                    dialog.showDialog();
                }
                drawPanel.repaint("ExecCommand.Page");
                break;
            }
            case 5: {
                pageManager.showNextPage();
                break;
            }
            case 6: {
                pageManager.showPreviousPage();
                break;
            }
            case 9: {
                pageManager.insertNewPage();
                break;
            }
            case 10: {
                pageManager.deletePage();
                break;
            }
            case 12: {
                JDialog dialog = new DialogOfPageSetup();
                dialog.showDialog();
                break;
            }
            case 13: {
                JDialog dialog = new DialogOfPageLayout();
                ((DialogOfPageLayout)dialog).showDialog();
                break;
            }
            case 14: {
                fileIO.printOut();
                break;
            }
            case 17: {
                fileIO.exit();
                break;
            }
            case 20: {
                Object[] object = command.getParams();
                String menuItem = (String)object[0];
                if (Command.getCommandId(menuItem) == 21) {
                    edit.cut();
                }
                if (Command.getCommandId(menuItem) == 22) {
                    edit.copy();
                }
                if (Command.getCommandId(menuItem) == 23) {
                    edit.paste();
                }
                if (Command.getCommandId(menuItem) == 24) {
                    edit.delete();
                }
                if (Command.getCommandId(menuItem) != 26) break;
                ShapeContainer[] containers2 = containerManager.getContainers();
                for (int i = 0; i < containers2.length; ++i) {
                    containers2[i].setSelected(true);
                }
                break;
            }
            case 21: {
                edit.cut();
                break;
            }
            case 22: {
                edit.copy();
                break;
            }
            case 23: {
                edit.paste();
                break;
            }
            case 24: {
                edit.delete();
                break;
            }
            case 25: {
                edit.delete();
                break;
            }
            case 26: {
                containers = containerManager.getContainers();
                for (int i = 0; i < containers.length; ++i) {
                    containers[i].setSelected(true);
                }
                break;
            }
            case 30: {
                UndoDrawManager undoDrawManager = ObjectTable.getUndoDrawManager("exec");
                undoDrawManager.undo();
                break;
            }
            case 31: {
                UndoDrawManager undoDrawManager = ObjectTable.getUndoDrawManager("exec");
                undoDrawManager.redo();
                break;
            }
            case 32: {
                Object[] object = command.getParams();
                this.clickedPoint = (Point2D)object[0];
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (callFrom == 1) {
                    selectionLS = ObjectTable.getSelectionLS("ExecCommand");
                    selectionLS.selectAll(false);
                    CreateShapeLS createShapeLS = new CreateShapeLS();
                    createShapeLS.creatingStart(commandId);
                    this.activeCreateShapeLS = createShapeLS;
                    drawPanel.repaint("ExecCommand.Shape");
                }
                if (callFrom != 4) break;
                this.activeCreateShapeLS = null;
                if (debug <= 0) break;
                System.out.println("** ExecCommand CreateShapeLS end");
                break;
            }
            case 60: {
                ShapeContainer[] containers3;
                CreateAuxShape createAuxShape;
                Object[] object = command.getParams();
                String menuItem = (String)object[0];
                if (Command.getCommandId(menuItem) == 61) {
                    createAuxShape = ObjectTable.getCreateAuxShape();
                    containers3 = containerManager.getSelectedContainers();
                    createAuxShape.centerLine(containers3);
                }
                if (Command.getCommandId(menuItem) == 62) {
                    createAuxShape = ObjectTable.getCreateAuxShape();
                    containers3 = containerManager.getSelectedContainers();
                    createAuxShape.lineBisector(containers3);
                }
                if (Command.getCommandId(menuItem) == 63) {
                    createAuxShape = ObjectTable.getCreateAuxShape();
                    containers3 = containerManager.getSelectedContainers();
                    createAuxShape.angleBisector(containers3);
                }
                drawPanel.repaint("ExecCommand.Util");
                break;
            }
            case 80: {
                ComponentLibDialog libDialog = ObjectTable.getComponentLibDialog();
                libDialog.showDialog();
                break;
            }
            case 81: {
                if (debug > 0) {
                    System.out.println("  -->ExecCommand move");
                }
                if (callFrom != 2 && callFrom != 3) break;
                MousePositionInfo info = (MousePositionInfo)params[0];
                MouseEvent event = (MouseEvent)params[1];
                containerManager.makeAllTextBoxesUneditable();
                ObjectTable.getAutoAlignLS().start(info, event);
                break;
            }
            case 82: {
                MousePositionInfo info;
                if (debug > 0) {
                    System.out.println("  -->ExecCommand resize");
                }
                if (callFrom == 2 || callFrom == 3) {
                    info = (MousePositionInfo)params[0];
                    MouseEvent event = (MouseEvent)params[1];
                    containerManager.makeAllTextBoxesUneditable();
                    ObjectTable.getAutoAlignLS().start(info, event);
                    break;
                }
                if (callFrom != 5) break;
                Rectangle2D oldBox = (Rectangle2D)params[0];
                Rectangle2D newBox = (Rectangle2D)params[1];
                ShapeContainer[] containers4 = containerManager.getSelectedContainers();
                for (int i = 0; i < containers4.length; ++i) {
                    ConnectionUtil.moveResize(containers4[i], oldBox, newBox, true, true);
                }
                break;
            }
            case 86: {
                if (callFrom != 1) break;
                ShapeContainer container = (ShapeContainer)params[1];
                ShapeContainer[] containers5 = container.getGroupedSingleShapeContainers();
                Point2D point = (Point2D)params[0];
                this.execUtil.addTextBox(containers5);
                break;
            }
            case 87: {
                if (callFrom != 1) break;
                ShapeContainer container = (ShapeContainer)params[1];
                ShapeContainer[] containers6 = container.getGroupedSingleShapeContainers();
                Point2D point = (Point2D)params[0];
                this.execUtil.deleteTextBox(containers6);
                break;
            }
            case 101: {
                if (callFrom != 1) break;
                ModifyShape modifyShape = new ModifyShape();
                modifyShape.showDialog();
                break;
            }
            case 100: {
                if (callFrom != 1) break;
                JDialog dialog = ObjectTable.getComponentLibDialog();
                ChangeShapeElement changeShape = new ChangeShapeElement((ComponentLibDialog)dialog);
                changeShape.start();
                break;
            }
            case 85: {
                Combine combine;
                ShapeContainer[] containers7;
                Object[] object = command.getParams();
                String menuItem = (String)object[0];
                if (Command.getCommandId(menuItem) == 86) {
                    containers7 = containerManager.getAllSigleShapeContainers(true);
                    this.execUtil.addTextBox(containers7);
                }
                if (Command.getCommandId(menuItem) == 87) {
                    containers7 = containerManager.getAllSigleShapeContainers(true);
                    this.execUtil.deleteTextBox(containers7);
                }
                if (Command.getCommandId(menuItem) == 88) {
                    Translate translate = new Translate();
                    translate.showDialog();
                }
                if (Command.getCommandId(menuItem) == 89) {
                    Rotate rotate = new Rotate();
                    rotate.showDialog();
                }
                if (Command.getCommandId(menuItem) == 90) {
                    Flip flip = new Flip();
                    flip.showDialog();
                }
                if (Command.getCommandId(menuItem) == 100) {
                    ComponentLibDialog dialog = ObjectTable.getComponentLibDialog();
                    ChangeShapeElement changeShape = new ChangeShapeElement(dialog);
                    changeShape.start();
                }
                if (Command.getCommandId(menuItem) == 101) {
                    ModifyShape modifyShape = new ModifyShape();
                    modifyShape.showDialog();
                }
                if (Command.getCommandId(menuItem) == 92) {
                    CutShape cutShape = new CutShape();
                    cutShape.showDialog();
                }
                if (Command.getCommandId(menuItem) == 93) {
                    ConnectCurves connectCurves = new ConnectCurves();
                    connectCurves.showDialog();
                }
                if (Command.getCommandId(menuItem) == 91) {
                    ExtendCurve extendCurve = new ExtendCurve();
                    extendCurve.showDialog();
                }
                if (Command.getCommandId(menuItem) == 94) {
                    combine = new Combine();
                    combine.combine();
                }
                if (Command.getCommandId(menuItem) == 95) {
                    combine = new Combine();
                    combine.breakCombine();
                }
                drawPanel.repaint("ExecCommand");
                break;
            }
            case 110: {
                JCheckBoxMenuItem checkBox;
                String commandName = Command.getCommandString(110);
                String str_no_direction = Command.getCommandString(113);
                String str_xy_direction = Command.getCommandString(114);
                ButtonOfPulldownMenu button = (ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                JMenu menu = button.getMenu();
                JCheckBoxMenuItem check_no_direction = (JCheckBoxMenuItem)button.getMenuItem(menu, str_no_direction);
                JCheckBoxMenuItem check_xy_direction = (JCheckBoxMenuItem)button.getMenuItem(menu, str_xy_direction);
                Object[] object = command.getParams();
                String menuItem = (String)object[0];
                ActionEvent e = (ActionEvent)object[1];
                if (Command.getCommandId(menuItem) == 111) {
                    checkBox = (JCheckBoxMenuItem)e.getSource();
                    DrawParameters.AUTO_ALIGN = checkBox.getState();
                }
                if (Command.getCommandId(menuItem) == 112) {
                    checkBox = (JCheckBoxMenuItem)e.getSource();
                    DrawParameters.ENABLE_CONNECTOR = checkBox.getState();
                }
                if (Command.getCommandId(menuItem) == 113 && (checkBox = (JCheckBoxMenuItem)e.getSource()).getState()) {
                    DrawParameters.AUTO_TRACKING_OPTION = 113;
                }
                if (Command.getCommandId(menuItem) == 114 && (checkBox = (JCheckBoxMenuItem)e.getSource()).getState()) {
                    DrawParameters.AUTO_TRACKING_OPTION = 114;
                }
                if (Command.getCommandId(menuItem) == 118) {
                    checkBox = (JCheckBoxMenuItem)e.getSource();
                    DrawParameters.ENABLE_HIGHLIGHTING = checkBox.getState();
                }
                if (Command.getCommandId(menuItem) == 119) {
                    checkBox = (JCheckBoxMenuItem)e.getSource();
                    if (checkBox.getState()) {
                        DrawParameters.DRAW_NODE_POINTS = true;
                        DrawParameters.DRAW_CHARACTERISTIC_POINTS = false;
                    } else {
                        DrawParameters.DRAW_NODE_POINTS = false;
                    }
                }
                drawPanel.repaint("ExecCommand.Util");
                break;
            }
            case 120: {
                ShapeContainer container = (ShapeContainer)params[1];
                DialogOfShapeFormat dialog = new DialogOfShapeFormat();
                dialog.showDialog(container);
                break;
            }
            case 121: {
                Point point = (Point)params[0];
                DialogOfDrawPanel dialog = new DialogOfDrawPanel();
                dialog.showDialog(point);
                break;
            }
            case 130: 
            case 131: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                String family = menuStyle.getFontFamily();
                if (family.equals("") || family.equals(" ")) break;
                FontStyle fontStyle = new FontStyle();
                fontStyle.setFontFamily(family);
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 132: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setFontSize(menuStyle.getFontSize());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 133: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setBold(menuStyle.getBold());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 134: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setItalic(menuStyle.getItalic());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 135: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setUnderLine(menuStyle.getUnderLine());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 136: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setSuperScript(menuStyle.getSuperScript());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.subscript");
                break;
            }
            case 137: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setSuperScript(menuStyle.getSuperScript());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.superscript");
                break;
            }
            case 138: {
                FontStyle menuStyle = FontStyle.getFontStyleFromMenu();
                FontStyle fontStyle = new FontStyle();
                fontStyle.setFontColor(menuStyle.getFontColor());
                this.execUtil.setFontStyle(fontStyle);
                drawPanel.repaint("ExecCommand.Font");
                break;
            }
            case 140: {
                Insets insets = null;
                if (params[0] != null) {
                    insets = (Insets)params[0];
                }
                int textAlign = -1;
                if (params[1] != null) {
                    textAlign = (Integer)params[1];
                }
                double lineSpace = -1.0;
                if (params[2] != null) {
                    lineSpace = (Double)params[2];
                }
                this.execUtil.setTextBoxLayout(insets, textAlign, lineSpace);
                break;
            }
            case 142: {
                String parm = (String)params[0];
                int argId = Command.getCommandId(parm);
                int textAlign = 0;
                if (argId == 143) {
                    textAlign = 0;
                }
                if (argId == 144) {
                    textAlign = 1;
                }
                if (argId == 145) {
                    textAlign = 2;
                }
                this.execUtil.setTextBoxLayout(null, textAlign, -1.0);
                drawPanel.repaint("ExecCommand.Text_Align");
                break;
            }
            case 150: {
                Object[] object = command.getParams();
                Color color = null;
                String objectType = object[0].getClass().getSimpleName();
                if (objectType.equals("Color")) {
                    color = (Color)object[0];
                }
                if (objectType.equals("String") && object.equals("no fill")) {
                    color = null;
                }
                containerManager.undoSetupStart();
                ShapeContainer[] containers8 = containerManager.getSelectedContainers();
                int size = 0;
                if (containers8 != null) {
                    size = containers8.length;
                }
                for (int i = 0; i < size; ++i) {
                    containers8[i].setFillColor(color);
                    containers8[i].setChangeCode(7);
                }
                containerManager.undoSetupEnd();
                drawPanel.repaint("ExecCommand.fillColor");
                break;
            }
            case 151: {
                Object[] object = command.getParams();
                Color color = null;
                String objectType = object[0].getClass().getSimpleName();
                if (objectType.equals("Color")) {
                    color = (Color)object[0];
                }
                if (objectType.equals("String") && object.equals("no line")) {
                    color = null;
                }
                containerManager.undoSetupStart();
                ShapeContainer[] containers9 = containerManager.getSelectedContainers();
                if (debug > 0) {
                    this.printShapeIds("** ExecCommand LINE_COLOR", containers9);
                }
                int size = 0;
                if (containers9 != null) {
                    size = containers9.length;
                }
                for (int i = 0; i < size; ++i) {
                    containers9[i].setLineColor(color);
                    containers9[i].setChangeCode(7);
                }
                containerManager.undoSetupEnd();
                drawPanel.repaint("ExecCommand.LineColor");
                break;
            }
            case 152: {
                Object[] object = command.getParams();
                String lineWidth = (String)object[0];
                containerManager.undoSetupStart();
                ShapeContainer[] containers10 = containerManager.getSelectedContainers();
                int size = 0;
                if (containers10 != null) {
                    size = containers10.length;
                }
                for (int i = 0; i < size; ++i) {
                    containers10[i].setLineWidth(lineWidth);
                    containers10[i].setChangeCode(7);
                }
                containerManager.undoSetupEnd();
                drawPanel.repaint("ExecCommand.LineWidth");
                break;
            }
            case 153: {
                Object[] object = command.getParams();
                String dashedStyle = (String)object[0];
                containerManager.undoSetupStart();
                ShapeContainer[] containers11 = containerManager.getSelectedContainers();
                int size = 0;
                if (containers11 != null) {
                    size = containers11.length;
                }
                for (int i = 0; i < size; ++i) {
                    containers11[i].setLineStroke(dashedStyle);
                    containers11[i].setChangeCode(7);
                }
                containerManager.undoSetupEnd();
                drawPanel.repaint("ExecCommand.LineStroks");
                break;
            }
            case 154: {
                Object[] object = command.getParams();
                String arrowStyle = (String)object[0];
                containerManager.undoSetupStart();
                ShapeContainer[] containers12 = containerManager.getSelectedContainers();
                int size = 0;
                if (containers12 != null) {
                    size = containers12.length;
                }
                for (int i = 0; i < size; ++i) {
                    containers12[i].setArrowStyle(arrowStyle);
                    containers12[i].setChangeCode(7);
                }
                containerManager.undoSetupEnd();
                drawPanel.repaint("ExecCommand.Arrow");
                break;
            }
            case 160: {
                String parm = (String)params[0];
                int argId = Command.getCommandId(parm);
                int id = 0;
                if (argId == 161) {
                    id = 0;
                }
                if (argId == 162) {
                    id = 1;
                }
                if (argId == 163) {
                    id = 2;
                }
                if (argId == 164) {
                    id = 3;
                }
                this.execUtil.moveZorder(id);
                break;
            }
            case 170: {
                String parm = (String)params[0];
                int argId = Command.getCommandId(parm);
                int id = 0;
                if (argId == 172) {
                    id = 1;
                }
                if (argId == 173) {
                    id = 2;
                }
                if (argId == 174) {
                    id = 3;
                }
                if (argId == 175) {
                    id = 4;
                }
                if (argId == 176) {
                    id = 5;
                }
                this.execUtil.align(id);
                break;
            }
            case 180: {
                containers = containerManager.getSelectedContainers();
                if (containers.length <= 1) {
                    return;
                }
                containerManager.group(containers);
                break;
            }
            case 181: {
                containers = containerManager.getSelectedContainers();
                containerManager.unGroup(containers);
                break;
            }
            case 185: {
                DialogOfZoom zoom = new DialogOfZoom();
                zoom.showDialog();
                break;
            }
            case 186: {
                ViewUtil viewUtil = ObjectTable.getViewUtil("");
                ViewUtil.zoom((Double)params[0]);
                break;
            }
            case 191: {
                JCheckBoxMenuItem check;
                JMenu menu;
                ButtonOfPulldownMenu button;
                String checkBox;
                String commandName;
                Object[] object = command.getParams();
                String menuItem = (String)object[0];
                ActionEvent e = (ActionEvent)object[1];
                if (Command.getCommandId(menuItem) == 192) {
                    GeometricTest geometricTest = new GeometricTest();
                    geometricTest.showDialog();
                }
                if (Command.getCommandId(menuItem) == 193) {
                    commandName = Command.getCommandString(191);
                    checkBox = Command.getCommandString(193);
                    button = (ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    menu = button.getMenu();
                    check = (JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_BOUNDINGBOX = false;
                    if (check.isSelected()) {
                        DrawParameters.DRAW_BOUNDINGBOX = true;
                    }
                }
                if (Command.getCommandId(menuItem) == 194) {
                    commandName = Command.getCommandString(191);
                    checkBox = Command.getCommandString(194);
                    button = (ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    menu = button.getMenu();
                    check = (JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_CHARACTERISTIC_POINTS = false;
                    if (check.isSelected()) {
                        DrawParameters.DRAW_CHARACTERISTIC_POINTS = true;
                        DrawParameters.DRAW_NODE_POINTS = false;
                    }
                }
                if (Command.getCommandId(menuItem) == 195) {
                    commandName = Command.getCommandString(191);
                    checkBox = Command.getCommandString(195);
                    button = (ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    menu = button.getMenu();
                    check = (JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_TEXTLAYOUT = false;
                    if (check.isSelected()) {
                        DrawParameters.DRAW_TEXTLAYOUT = true;
                    }
                }
                if (Command.getCommandId(menuItem) == 196) {
                    if (debug > 0) {
                        System.out.println("** Unselectable Areas");
                    }
                    commandName = Command.getCommandString(191);
                    checkBox = Command.getCommandString(196);
                    button = (ButtonOfPulldownMenu)menuUtil.getMenuComponent(commandName);
                    menu = button.getMenu();
                    check = (JCheckBoxMenuItem)button.getMenuItem(menu, checkBox);
                    DrawParameters.DRAW_UNSELECTABLEAREA = false;
                    if (check.isSelected()) {
                        DrawParameters.DRAW_UNSELECTABLEAREA = true;
                    }
                }
                if (Command.getCommandId(menuItem) == 197) {
                    if (debug > 0) {
                        System.out.println("** ConnectionLSTest");
                    }
                    ConnectionLSTest connectionLSTest = new ConnectionLSTest();
                    connectionLSTest.showDialog();
                }
                drawPanel.repaint("ExecCommand.test");
                break;
            }
            default: {
                System.err.println("*** Error; ExecCommand, not implemented command, command " + command.toString());
            }
        }
        drawPanel.repaint("ExecCommand.end of exec method");
        this.setPreviousCommandId(commandId);
        this.setCurrentCommandId(-1);
        menuUtil.resetSelectedMenuComponents();
        containers = containerManager.getAllSigleShapeContainers(true);
    }

    public int getCurrentCommandId() {
        return this.currentCommandId;
    }

    public void setCurrentCommandId(int commandId) {
        this.currentCommandId = commandId;
    }

    public int getPreviousCommandId() {
        return this.previousCommandId;
    }

    public void setPreviousCommandId(int commandId) {
        this.previousCommandId = commandId;
    }

    public Point2D getClickedPoint() {
        return this.clickedPoint;
    }

    public void clearClickedPoint() {
        this.clickedPoint = null;
    }

    public void printShapeIds(String title, ShapeContainer[] containers) {
        int size = containers.length;
        String str = title + "\n";
        for (int i = 0; i < size; ++i) {
            str = i > 0 ? str + ", " : str + "  ";
            str = str + "container[" + i + "]=" + containers[i].getShapeId();
        }
        System.out.println(str);
    }
}

