/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import javax.swing.JTabbedPane;
import shape.ShapeContainer;
import textBox.TextBox;
import util.ContainerManager;

public class ListenerPanel
extends DrawPanel
implements KeyListener,
MouseListener,
InputMethodListener,
InputMethodRequests {
    ContainerManager containerManager = null;
    int idNumber = 0;
    int debug = 0;

    public ListenerPanel() {
        this.enableInputMethods(true);
        this.addInputMethodListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.requestFocus();
    }

    public String getMouseListenersInfo() {
        String str = "";
        MouseListener[] mouseListeners = this.getMouseListeners();
        str = mouseListeners.length == 0 ? "MouseListener=null" : "ListenerPanel MouseListener list";
        for (int i = 0; i < mouseListeners.length; ++i) {
            str = str + "\n  --  " + mouseListeners[i].toString();
        }
        return str;
    }

    public void printMouseListeners(String title) {
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length == 0) {
            System.out.println(title + " MouseListener=null");
        } else {
            System.out.println(title);
        }
        for (int i = 0; i < mouseListeners.length; ++i) {
            System.out.println("  --  " + mouseListeners[i]);
        }
    }

    public boolean isMouseListener(MouseListener listener) {
        MouseListener[] mouseLS = this.getMouseListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseLS.length; ++i) {
            if (!listener.equals(mouseLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    public boolean isMouseMotionListener(MouseMotionListener listener) {
        MouseMotionListener[] mouseMotionLS = this.getMouseMotionListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseMotionLS.length; ++i) {
            if (!listener.equals(mouseMotionLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    public boolean isMouseListener(String listenerClassName) {
        MouseListener[] mouseLS = this.getMouseListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseLS.length; ++i) {
            String className = mouseLS[i].getClass().getSimpleName();
            if (!listenerClassName.equals(className)) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    public boolean isMouseMotionListener(String listenerClassName) {
        MouseMotionListener[] mouseMotionLS = this.getMouseMotionListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseMotionLS.length; ++i) {
            String className = mouseMotionLS[i].getClass().getSimpleName();
            if (!listenerClassName.equals(className)) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this.containerManager = ObjectTable.getContainerManager("");
        this.requestFocus();
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (this.debug > 0) {
            System.out.println("++ ListenerPanel keyTyped   keyChar=" + keyChar + ", Hex=" + Integer.toHexString(keyChar) + ", keyCode=" + keyCode);
        }
        if ((keyChar < ' ' || keyChar == '\u007f') && keyChar != '\n') {
            JTabbedPane tabbedPane = ObjectTable.getTabbedPane("Listenerpanel.keyTyped");
            tabbedPane.setSelectedIndex(1);
            return;
        }
        ShapeContainer shapeContainer = this.containerManager.getEditableTextBox();
        if (shapeContainer != null && shapeContainer.getTextBox() != null) {
            TextBox textBox = shapeContainer.getTextBox();
            textBox.keyTyped(keyChar);
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (this.debug > 0) {
            System.out.println("++ ListenerPanel keyPressed   keyChar=" + keyChar + ", Hex=" + Integer.toHexString(keyChar) + ", keyCode=" + keyCode);
        }
        if (keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40) {
            this.containerManager = ObjectTable.getContainerManager("");
            ShapeContainer shapeContainer = this.containerManager.getEditableTextBox();
            if (shapeContainer != null && shapeContainer.getTextBox() != null) {
                TextBox textBox = shapeContainer.getTextBox();
                textBox.keyPressed(keyCode);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.containerManager = ObjectTable.getContainerManager("");
        ShapeContainer container = this.containerManager.getEditableTextBox();
        if (container != null && container.getTextBox() != null) {
            TextBox textBox = container.getTextBox();
            textBox.inputMethodTextChanged(event);
        }
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public int getCommittedTextLength() {
        return 0;
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        Rectangle rect = null;
        ShapeContainer container = this.containerManager.getEditableTextBox();
        if (container != null && container.getTextBox() != null) {
            TextBox textBox = container.getTextBox();
            rect = textBox.getTextLocation();
            Point location = this.getLocationOnScreen();
            rect.translate(location.x, location.y);
        }
        return rect;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.enableInputMethods(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        this.enableInputMethods(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

