/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.CurvePT;
import geomExtension.GeneralCurve2DE;
import geomExtension.Matrix2D;
import geomExtension.Segment2D;
import geomExtension.SerializableCurve2D;
import geomExtension.SerializableSegment2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import util.Util;

public abstract class Curve2D {
    Segment2D[] segments = null;
    GeneralPath generalPath = null;
    boolean closed = false;
    Vector workVector = new Vector();
    public static final double eps = 1.0E-5;
    public static final double largeNumber = 100000.0;
    public static final double closedTolerance = 3.0;
    public static final int Path2D_WIND = 0;
    int debug = 0;

    public Curve2D() {
    }

    public Curve2D(Segment2D[] segments) {
        this.setData(segments);
    }

    public void setData(Segment2D[] segments) {
        this.segments = segments;
        this.generalPath = new GeneralPath(0);
        Point2D startP = segments[0].getP(0.0);
        Point2D endP = segments[segments.length - 1].getP(1.0);
        double dist = Vector2D.dist(startP, endP);
        this.closed = false;
        if (dist < 3.0) {
            this.closed = true;
        }
        for (int i = 0; i < segments.length; ++i) {
            Shape shape = segments[i].getShape();
            this.generalPath.append(shape, true);
        }
        if (this.closed) {
            this.generalPath.closePath();
        }
    }

    public abstract int getType2DE();

    public Shape getShape() {
        return this.generalPath;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getNumOfSegments() {
        int size = 0;
        if (this.segments != null) {
            size = this.segments.length;
        }
        return size;
    }

    public Segment2D[] getSegment2Ds() {
        return this.segments;
    }

    public Segment2D getSegment2D(int index) {
        if (index < 0 || index > this.segments.length - 1) {
            System.err.println("*** Error Curve2D.getSegment2D ; index out of range; index=" + index);
            return null;
        }
        return this.segments[index];
    }

    public int getNumOfSubPaths() {
        if (this.getType2DE() == 56) {
            GeneralCurve2DE curve = (GeneralCurve2DE)this;
            return curve.getNumOfSubPaths();
        }
        return 1;
    }

    public Curve2D[] getSubPaths() {
        if (this.getType2DE() == 56) {
            GeneralCurve2DE curve = (GeneralCurve2DE)this;
            return curve.getSubPaths();
        }
        Curve2D[] subPaths = new Curve2D[]{this};
        return subPaths;
    }

    public Point2D getP(double t) {
        int it = (int)t;
        if (it < 0) {
            it = 0;
        }
        if (it >= this.segments.length) {
            it = this.segments.length - 1;
        }
        if (this.segments[it].getType() == 0 && it > 0) {
            --it;
        }
        Segment2D segment = this.segments[it];
        return segment.getP(t - (double)it);
    }

    public Vector2D getTangent(double t) {
        int it = (int)t;
        if (it < 0) {
            it = 0;
        }
        if (it >= this.segments.length) {
            it = this.segments.length - 1;
        }
        if (this.segments[it].getType() == 0 && it > 0) {
            --it;
        }
        return this.segments[it].getTangent(t - (double)it);
    }

    public Vector2D gettangentDerivative(double t) {
        int it = (int)t;
        if (it < 0) {
            it = 0;
        }
        if (it > this.segments.length - 1) {
            it = this.segments.length - 1;
        }
        if (this.segments[it].getType() == 0 && it > 0) {
            --it;
        }
        return this.segments[it].getTangentDerivative(t - (double)it);
    }

    public Point2D[] getEndPoints() {
        Point2D[] endPoints = new Point2D[2];
        int numseg = this.getNumOfSegments();
        endPoints[0] = this.getP(0.0);
        endPoints[1] = this.getP(numseg);
        return endPoints;
    }

    public int getCloseEndpointIndex(Point2D point) {
        Point2D[] endPoints = new Point2D[2];
        int numseg = this.getNumOfSegments();
        endPoints[0] = this.getP(0.0);
        endPoints[1] = this.getP(numseg);
        double d0 = Vector2D.dist(point, endPoints[0]);
        double d1 = Vector2D.dist(point, endPoints[1]);
        if (this.isClosed()) {
            return -1;
        }
        int index = 0;
        if (d0 > d1) {
            index = numseg;
        }
        return index;
    }

    public Point2D[] getNodePoints() {
        int numseg = this.getNumOfSegments();
        Point2D[] points = new Point2D[numseg + 1];
        for (int i = 0; i <= numseg; ++i) {
            points[i] = this.getP(i);
        }
        return points;
    }

    public CurvePT[] getCharacteristicPoints() {
        this.workVector.clear();
        int numseg = this.getNumOfSegments();
        boolean closed = this.isClosed();
        double delta = 0.5;
        if (closed && numseg == 1) {
            delta = 0.25;
        }
        for (double tc = 0.0; tc <= (double)numseg; tc += delta) {
            CurvePT curvePT = new CurvePT(tc, this.getP(tc), this);
            this.workVector.add(curvePT);
        }
        int size = this.workVector.size();
        CurvePT[] curvePTs = new CurvePT[size];
        for (int i = 0; i < size; ++i) {
            curvePTs[i] = (CurvePT)this.workVector.get(i);
        }
        return curvePTs;
    }

    public Point2D[] getSamplingPTs(double pitch) {
        Point2D[] points = new Point2D[]{};
        CurvePT[] curvePTs = this.getSamplingCurvePTs(pitch);
        int size = 0;
        if (curvePTs != null) {
            size = curvePTs.length;
        }
        points = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            points[i] = curvePTs[i].getP();
        }
        return points;
    }

    public CurvePT[] getSamplingCurvePTs(double pitch) {
        CurvePT[] curvePTs = new CurvePT[]{};
        int numSeg = this.getNumOfSegments();
        this.workVector.clear();
        for (int it = 0; it < numSeg; ++it) {
            Segment2D segment = this.getSegment2D(it);
            if (segment.getType() == 0) continue;
            double length = segment.getSegmentLength(0.0, 1.0);
            int div = (int)(length / pitch);
            if (div - div / 2 * 2 > 0) {
                ++div;
            }
            double delta = 1.0 / (double)div;
            double t = 0.0;
            int iEnd = div;
            if (it == numSeg - 1) {
                iEnd = div + 1;
            }
            for (int i = 0; i < iEnd; ++i) {
                Point2D point = segment.getP(t);
                CurvePT curvePT = new CurvePT(t + (double)it, point);
                this.workVector.add(curvePT);
                t += delta;
            }
        }
        if (this.workVector.size() == 0) {
            return null;
        }
        curvePTs = new CurvePT[this.workVector.size()];
        for (int i = 0; i < this.workVector.size(); ++i) {
            curvePTs[i] = (CurvePT)this.workVector.get(i);
        }
        if (this.debug > 0) {
            String str = "Curve2D getSamplingCurvePTs";
            for (int i = 0; i < this.workVector.size(); ++i) {
                curvePTs[i] = (CurvePT)this.workVector.get(i);
                str = str + "\n  curvePTs[" + i + "]: t=" + Util.Num(curvePTs[i].getParameter()) + ", PT=" + Util.Pt(curvePTs[i].getP());
            }
            System.out.println(str);
        }
        return curvePTs;
    }

    public double getCurveLength(double t1, double t2) {
        int numSeg = this.getNumOfSegments();
        if (t1 < 0.0 || t1 > (double)numSeg || t2 < 0.0 || t2 > (double)numSeg) {
            System.out.println("*** Warning SegmentedCurve2D ; parameter out og range; t1, t2=" + t1 + "," + t2);
            if (t1 < 0.0) {
                t1 = 0.0;
            }
            if (t1 > (double)numSeg) {
                t1 = numSeg;
            }
            if (t2 < 0.0) {
                t2 = 0.0;
            }
            if (t2 > (double)numSeg) {
                t2 = numSeg;
            }
        }
        int it1 = (int)t1;
        int it2 = (int)t2;
        double length = 0.0;
        for (int i = it1; i <= it2; ++i) {
            double ts = 0.0;
            double te = 1.0;
            if (i == it1) {
                ts = t1 - (double)it1;
            }
            if (i == it2) {
                te = t2 - (double)it2;
            }
            if (!(te - ts > 1.0E-5)) continue;
            Segment2D segment2D = this.getSegment2D(i);
            length += segment2D.getSegmentLength(ts, te);
        }
        return length;
    }

    public Rectangle2D getBoundingBox() {
        double xmin;
        double ymin = xmin = 10000.0;
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < this.segments.length; ++i) {
            Rectangle2D box;
            if (this.segments[i].getType() == 0 || (box = this.segments[i].getBoundingBox()) == null) continue;
            double x = box.getX();
            double y = box.getY();
            double w = box.getWidth();
            double h = box.getHeight();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x + w > xmax) {
                xmax = x + w;
            }
            if (!(y + h > ymax)) continue;
            ymax = y + h;
        }
        Rectangle2D.Double maxBoundingBox = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return maxBoundingBox;
    }

    public Rectangle2D getBoundingBox(double t1, double t2) {
        double Xmin;
        if (this.segments == null) {
            return null;
        }
        double Ymin = Xmin = Math.pow(10.0, 5.0);
        double Xmax = -Xmin;
        double Ymax = -Ymin;
        int it1 = (int)t1;
        int it2 = (int)t2;
        for (int it = it1; it <= it2; ++it) {
            Rectangle2D box;
            double ts = 0.0;
            double te = 1.0;
            if (it == it1) {
                ts = t1 - (double)it;
            }
            if (it == it2) {
                te = t2 - (double)it;
            }
            if (te - ts < 1.0E-5 || this.getSegment2D(it).getType() == 0 || (box = this.getSegment2D(it).getBoundingBox(ts, te)) == null) continue;
            if (box.getX() < Xmin) {
                Xmin = box.getX();
            }
            if (box.getY() < Ymin) {
                Ymin = box.getY();
            }
            if (box.getX() + box.getWidth() > Xmax) {
                Xmax = box.getX() + box.getWidth();
            }
            if (!(box.getY() + box.getHeight() > Ymax)) continue;
            Ymax = box.getY() + box.getHeight();
        }
        return new Rectangle2D.Double(Xmin, Ymin, Xmax - Xmin, Ymax - Ymin);
    }

    public SerializableCurve2D getSerializableCurve2D() {
        SerializableCurve2D sdata = new SerializableCurve2D();
        sdata.type = this.getType2DE();
        Segment2D[] segments = this.getSegment2Ds();
        int numSeg = this.getNumOfSegments();
        SerializableSegment2D[] serializableSegments = new SerializableSegment2D[numSeg];
        for (int i = 0; i < numSeg; ++i) {
            serializableSegments[i] = segments[i].getSerializableSegment2D();
        }
        sdata.setSegments(serializableSegments);
        return sdata;
    }

    public void setSerializableCurve2D(SerializableCurve2D sdata) {
        SerializableSegment2D[] data = sdata.serializableSegments;
        int size = data.length;
        Segment2D[] segments = new Segment2D[size];
        for (int i = 0; i < size; ++i) {
            segments[i] = new Segment2D(data[i].type, data[i].shape, data[i].affineTransform);
        }
        this.setData(segments);
    }

    public GeneralCurve2DE convertToGeneralCurve2DE() {
        int numseg = this.getNumOfSegments();
        Segment2D[] segments = new Segment2D[numseg];
        for (int i = 0; i < numseg; ++i) {
            segments[i] = (Segment2D)this.getSegment2D(i).clone();
        }
        GeneralCurve2DE generalcurve = new GeneralCurve2DE(segments);
        return generalcurve;
    }

    public GeneralCurve2DE getExtendedCurve2DE(double ext) {
        Segment2D newSeg;
        if (this.isClosed()) {
            return null;
        }
        int numseg = this.getNumOfSegments();
        Segment2D[] newSegments = new Segment2D[numseg + 2];
        for (int i = 0; i < numseg; ++i) {
            newSegments[i + 1] = (Segment2D)this.getSegment2D(i).clone();
        }
        Vector2D p = new Vector2D(this.getP(0.0));
        Vector2D Tvec = this.getTangent(0.0);
        Tvec = Vector2D.multiply(-ext, Vector2D.unitVector(Tvec));
        Vector2D pExt = Vector2D.add(p, Tvec);
        Line2D.Double line = new Line2D.Double(pExt.getX(), pExt.getY(), p.getX(), p.getY());
        newSegments[0] = newSeg = new Segment2D(1, line);
        p = new Vector2D(this.getP(numseg));
        Tvec = this.getTangent(numseg);
        Tvec = Vector2D.multiply(ext, Vector2D.unitVector(Tvec));
        pExt = Vector2D.add(p, Tvec);
        line = new Line2D.Double(p.getX(), p.getY(), pExt.getX(), pExt.getY());
        newSegments[numseg + 1] = newSeg = new Segment2D(1, line);
        GeneralCurve2DE generalcurve = new GeneralCurve2DE(newSegments);
        return generalcurve;
    }

    public void reverse() {
        int numseg = this.getNumOfSegments();
        Segment2D[] newSegments = new Segment2D[numseg];
        for (int i = 0; i < numseg; ++i) {
            Segment2D segment = (Segment2D)this.getSegment2D(numseg - 1 - i).clone();
            newSegments[i] = segment.reverseSegment();
        }
        this.setData(newSegments);
    }

    public void transform(Matrix2D M) {
        int numseg = this.getNumOfSegments();
        Segment2D[] newSegments = new Segment2D[numseg];
        for (int i = 0; i < numseg; ++i) {
            newSegments[i] = this.getSegment2D(i).transformSegment(M);
        }
        this.setData(newSegments);
    }

    public abstract Object clone();

    public abstract String toString();

    public String toPathString() {
        double[] coordinates = new double[6];
        GeneralPath path = this.generalPath;
        String str = "";
        PathIterator pi = path.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(coordinates);
            switch (type) {
                case 0: {
                    str = str + "   move to  " + Util.Num(coordinates[0]) + ", " + Util.Num(coordinates[1]) + "\n";
                    break;
                }
                case 1: {
                    str = str + "   line to  " + Util.Num(coordinates[0]) + ", " + Util.Num(coordinates[1]) + "\n";
                    break;
                }
                case 2: {
                    str = str + "   quadratic to  " + Util.Num(coordinates[0]) + ", " + Util.Num(coordinates[1]) + ", " + Util.Num(coordinates[2]) + ", " + Util.Num(coordinates[3]) + "\n";
                    break;
                }
                case 3: {
                    str = str + "   cubic to  " + Util.Num(coordinates[0]) + ", " + Util.Num(coordinates[1]) + ", " + Util.Num(coordinates[2]) + ", " + Util.Num(coordinates[3]) + ", " + Util.Num(coordinates[4]) + ", " + Util.Num(coordinates[5]) + "\n";
                    break;
                }
                case 4: {
                    str = str + "   close\n";
                    break;
                }
            }
            pi.next();
        }
        return str;
    }
}

