/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.Curve2D;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.NumberFormat;

public class Rectangle2DE
extends Curve2D {
    public Rectangle2DE(Segment2D[] segments) {
        super(segments);
    }

    public Rectangle2DE(double x, double y, double width, double height) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[4];
        this.segments[0] = new Segment2D(1, new Line2D.Double(x, y, x, y + height));
        this.segments[1] = new Segment2D(1, new Line2D.Double(x, y + height, x + width, y + height));
        this.segments[2] = new Segment2D(1, new Line2D.Double(x + width, y + height, x + width, y));
        this.segments[3] = new Segment2D(1, new Line2D.Double(x + width, y, x, y));
        for (int i = 0; i < 4; ++i) {
            Shape shape = this.segments[i].getShape();
            this.generalPath.append(shape, true);
        }
        this.generalPath.closePath();
        this.closed = true;
    }

    @Override
    public int getType2DE() {
        return 43;
    }

    public double getX() {
        return this.segments[0].getP(0.0).getX();
    }

    public double getY() {
        return this.segments[0].getP(0.0).getY();
    }

    public double getWidth() {
        double width = Vector2D.dist(this.segments[1].getP(0.0), this.segments[1].getP(1.0));
        return width;
    }

    public double getHeight() {
        double height = Vector2D.dist(this.segments[0].getP(0.0), this.segments[0].getP(1.0));
        return height;
    }

    @Override
    public Object clone() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return new Rectangle2DE(x, y, w, h);
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        String str = "";
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        str = str + "Rectangle x,y=" + nf.format(x) + "," + nf.format(y) + ", width,height=" + nf.format(w) + "," + nf.format(h);
        return str;
    }
}

