/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.FergusonCurve2D;
import geomExtension.Matrix2D;
import geomExtension.SerializableSegment2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import util.Util;

public class Segment2D {
    int type = 0;
    private Shape shape = null;
    private AffineTransform affineTransform = null;
    public static final int MOVETO = 0;
    public static final int LINE = 1;
    public static final int ARC = 2;
    public static final int CUBIC = 3;
    public static final int QUAD = 4;
    public static final String[] codeStr = new String[]{"MOVETO", "LINE", "ARC", "CUBIC", "QUAD"};
    double pai = Math.PI;
    double largeNumber = 100000.0;
    double eps4 = 1.0E-4;
    int debug = 0;

    public Segment2D(int type, Shape shape) {
        this.type = type;
        this.shape = shape;
        this.affineTransform = null;
    }

    public Segment2D(int type, Shape shape, AffineTransform affineTransform) {
        this.type = type;
        this.shape = shape;
        this.affineTransform = affineTransform;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAffineTransform() {
        return this.affineTransform != null;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public Shape getShape() {
        Shape shape = this.shape;
        if (this.type == 2 && this.affineTransform != null) {
            shape = this.affineTransform.createTransformedShape(this.shape);
        }
        return shape;
    }

    public Shape getAwtGeom() {
        return this.shape;
    }

    public Point2D getP(double t) {
        Point2D Q1;
        Shape curve;
        if (t < -this.eps4) {
            t = 0.0;
        }
        if (t > 1.0 + this.eps4) {
            t = 1.0;
        }
        double X = 0.0;
        double Y = 0.0;
        if (this.type == 0) {
            System.out.println("*** ERROR Segment2D.getP, MOVETO segment, return null");
            return null;
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            X = t * (line.getX2() - line.getX1()) + line.getX1();
            Y = t * (line.getY2() - line.getY1()) + line.getY1();
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double x = arc.getX();
            double y = arc.getY();
            double w = arc.getWidth();
            double h = arc.getHeight();
            double angle = (arc.getAngleStart() + t * arc.getAngleExtent()) * this.pai / 180.0;
            X = 0.5 * w * Math.cos(angle) + x + 0.5 * w;
            Y = -0.5 * h * Math.sin(angle) + y + 0.5 * h;
            if (this.affineTransform != null) {
                double[] matrix = new double[6];
                this.affineTransform.getMatrix(matrix);
                x = X;
                y = Y;
                X = matrix[0] * x + matrix[2] * y + matrix[4];
                Y = matrix[1] * x + matrix[3] * y + matrix[5];
            }
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Point2D Q0 = ((CubicCurve2D)curve).getP1();
            Q1 = ((CubicCurve2D)curve).getCtrlP1();
            Point2D Q2 = ((CubicCurve2D)curve).getCtrlP2();
            Point2D Q3 = ((CubicCurve2D)curve).getP2();
            double X0 = (1.0 - t) * (1.0 - t) * (1.0 - t);
            double X1 = 3.0 * (1.0 - t) * (1.0 - t) * t;
            double X2 = 3.0 * (1.0 - t) * t * t;
            double X3 = t * t * t;
            X = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX() + X3 * Q3.getX();
            Y = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY() + X3 * Q3.getY();
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Point2D Q0 = ((QuadCurve2D)curve).getP1();
            Q1 = ((QuadCurve2D)curve).getCtrlPt();
            Point2D Q2 = ((QuadCurve2D)curve).getP2();
            double X0 = (1.0 - t) * (1.0 - t);
            double X1 = 2.0 * (1.0 - t) * t;
            double X2 = t * t;
            X = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX();
            Y = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY();
        }
        Point2D.Double P = new Point2D.Double(X, Y);
        return P;
    }

    public Vector2D getTangent(double t) {
        Point2D Q1;
        Shape curve;
        double Ty;
        double Tx;
        if (t < -this.eps4) {
            t = 0.0;
        }
        if (t > 1.0 + this.eps4) {
            t = 1.0;
        }
        Vector2D tangent = null;
        if (this.type == 0) {
            System.out.println("*** ERROR Segment2D.getTangent, MOVETO segment, return null");
            return null;
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            tangent = Vector2D.sub(line.getP2(), line.getP1());
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double x = arc.getX();
            double y = arc.getY();
            double w = arc.getWidth();
            double h = arc.getHeight();
            double coeff = arc.getAngleExtent() * this.pai / 180.0;
            double angle = coeff * t + arc.getAngleStart() * this.pai / 180.0;
            Tx = -0.5 * w * coeff * Math.sin(angle);
            Ty = -0.5 * h * coeff * Math.cos(angle);
            if (this.affineTransform != null) {
                double[] matrix = new double[6];
                this.affineTransform.getMatrix(matrix);
                x = Tx;
                y = Ty;
                Tx = matrix[0] * x + matrix[2] * y;
                Ty = matrix[1] * x + matrix[3] * y;
            }
            tangent = new Vector2D(Tx, Ty);
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Point2D Q0 = ((CubicCurve2D)curve).getP1();
            Q1 = ((CubicCurve2D)curve).getCtrlP1();
            Point2D Q2 = ((CubicCurve2D)curve).getCtrlP2();
            Point2D Q3 = ((CubicCurve2D)curve).getP2();
            double X0 = -3.0 * (1.0 - t) * (1.0 - t);
            double X1 = 3.0 * (1.0 - t) * (1.0 - 3.0 * t);
            double X2 = 3.0 * (2.0 - 3.0 * t) * t;
            double X3 = 3.0 * t * t;
            Tx = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX() + X3 * Q3.getX();
            Ty = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY() + X3 * Q3.getY();
            tangent = new Vector2D(Tx, Ty);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Point2D Q0 = ((QuadCurve2D)curve).getP1();
            Q1 = ((QuadCurve2D)curve).getCtrlPt();
            Point2D Q2 = ((QuadCurve2D)curve).getP2();
            double X0 = -2.0 * (1.0 - t);
            double X1 = 2.0 * (1.0 - 2.0 * t);
            double X2 = 2.0 * t;
            double Tx2 = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX();
            double Ty2 = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY();
            tangent = new Vector2D(Tx2, Ty2);
        }
        return tangent;
    }

    public Vector2D getTangentDerivative(double t) {
        Point2D Q1;
        Shape curve;
        double DTy;
        double DTx;
        if (t < -this.eps4) {
            t = 0.0;
        }
        if (t > 1.0 + this.eps4) {
            t = 1.0;
        }
        Vector2D derivative = null;
        if (this.type == 0) {
            System.out.println("*** ERROR Segment2D.getTangentDerivative, MOVETO segment, return null");
            return null;
        }
        if (this.type == 1) {
            derivative = new Vector2D(0.0, 0.0);
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double x = arc.getX();
            double y = arc.getY();
            double w = arc.getWidth();
            double h = arc.getHeight();
            double coeff = arc.getAngleExtent() * this.pai / 180.0;
            double angle = coeff * t + arc.getAngleStart() * this.pai / 180.0;
            DTx = -0.5 * w * coeff * coeff * Math.cos(angle);
            DTy = 0.5 * h * coeff * coeff * Math.sin(angle);
            if (this.affineTransform != null) {
                double[] matrix = new double[6];
                this.affineTransform.getMatrix(matrix);
                x = DTx;
                y = DTy;
                DTx = matrix[0] * x + matrix[2] * y;
                DTy = matrix[1] * x + matrix[3] * y;
            }
            derivative = new Vector2D(DTx, DTy);
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Point2D Q0 = ((CubicCurve2D)curve).getP1();
            Q1 = ((CubicCurve2D)curve).getCtrlP1();
            Point2D Q2 = ((CubicCurve2D)curve).getCtrlP2();
            Point2D Q3 = ((CubicCurve2D)curve).getP2();
            double X0 = 6.0 * (1.0 - t);
            double X1 = -6.0 * (2.0 - 3.0 * t);
            double X2 = 6.0 * (1.0 - 3.0 * t);
            double X3 = 6.0 * t;
            DTx = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX() + X3 * Q3.getX();
            DTy = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY() + X3 * Q3.getY();
            derivative = new Vector2D(DTx, DTy);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Point2D Q0 = ((QuadCurve2D)curve).getP1();
            Q1 = ((QuadCurve2D)curve).getCtrlPt();
            Point2D Q2 = ((QuadCurve2D)curve).getP2();
            double X0 = 2.0;
            double X1 = -4.0;
            double X2 = 2.0;
            double DTx2 = X0 * Q0.getX() + X1 * Q1.getX() + X2 * Q2.getX();
            double DTy2 = X0 * Q0.getY() + X1 * Q1.getY() + X2 * Q2.getY();
            derivative = new Vector2D(DTx2, DTy2);
        }
        return derivative;
    }

    public double getSegmentLength(double t1, double t2) {
        int i;
        Shape curve;
        double length = 0.0;
        if (this.type == 0) {
            return 0.0;
        }
        if (this.type == 1) {
            length = Vector2D.dist(new Vector2D(this.getP(t1)), new Vector2D(this.getP(t2)));
        }
        if (this.type == 2) {
            double anglePich;
            Arc2D arc = (Arc2D)this.shape;
            double angleExtent = arc.getAngleExtent();
            int div = (int)(angleExtent / (anglePich = 3.0));
            if (div < 1) {
                div = 1;
            }
            double delta = (t2 - t1) / (double)div;
            double t = t1;
            Vector2D p1 = new Vector2D(this.getP(t1));
            for (int i2 = 0; i2 < div; ++i2) {
                Vector2D p2 = new Vector2D(this.getP(t + delta));
                length += Vector2D.dist(p1, p2);
                t += delta;
                p1 = (Vector2D)p2.clone();
            }
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Vector2D[] Q = new Vector2D[]{new Vector2D(((CubicCurve2D)curve).getP1()), new Vector2D(((CubicCurve2D)curve).getCtrlP1()), new Vector2D(((CubicCurve2D)curve).getCtrlP2()), new Vector2D(((CubicCurve2D)curve).getP2())};
            for (i = 0; i < 3; ++i) {
                length += Vector2D.dist(Q[i], Q[i + 1]);
            }
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Vector2D[] Q = new Vector2D[]{new Vector2D(((QuadCurve2D)curve).getP1()), new Vector2D(((QuadCurve2D)curve).getCtrlPt()), new Vector2D(((QuadCurve2D)curve).getP2())};
            for (i = 0; i < 2; ++i) {
                length += Vector2D.dist(Q[i], Q[i + 1]);
            }
        }
        return length;
    }

    public Rectangle2D getBoundingBox() {
        double y;
        double x;
        int j;
        Point2D[] Q;
        Shape curve;
        Segment2D segment;
        int i;
        double ymax;
        double xmax;
        double ymin;
        double xmin;
        double dlt;
        int div;
        Rectangle2D.Double box = null;
        if (this.type == 0) {
            System.out.println("*** ERROR Segment2D.getBoundingBox, MOVETO segment, return null");
            return null;
        }
        if (this.type == 1 || this.type == 2) {
            Shape shape = this.getShape();
            return shape.getBounds2D();
        }
        if (this.type == 3) {
            div = 4;
            dlt = 1.0 / (double)div;
            ymin = xmin = 10000.0;
            xmax = -xmin;
            ymax = -xmin;
            for (i = 0; i < div; ++i) {
                segment = this.trimSegment(dlt * (double)i, dlt * (double)(i + 1));
                curve = (CubicCurve2D)segment.shape;
                Q = new Point2D[]{((CubicCurve2D)curve).getP1(), ((CubicCurve2D)curve).getCtrlP1(), ((CubicCurve2D)curve).getCtrlP2(), ((CubicCurve2D)curve).getP2()};
                for (j = 0; j < 4; ++j) {
                    x = Q[j].getX();
                    y = Q[j].getY();
                    if (x < xmin) {
                        xmin = x;
                    }
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    }
                    if (!(y > ymax)) continue;
                    ymax = y;
                }
            }
            box = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        if (this.type == 4) {
            div = 4;
            dlt = 1.0 / (double)div;
            ymin = xmin = 10000.0;
            xmax = -xmin;
            ymax = -xmin;
            for (i = 0; i < div; ++i) {
                segment = this.trimSegment(dlt * (double)i, dlt * (double)(i + 1));
                curve = (QuadCurve2D)segment.shape;
                Q = new Point2D[]{((QuadCurve2D)curve).getP1(), ((QuadCurve2D)curve).getCtrlPt(), ((QuadCurve2D)curve).getP2()};
                for (j = 0; j < 3; ++j) {
                    x = Q[j].getX();
                    y = Q[j].getY();
                    if (x < xmin) {
                        xmin = x;
                    }
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    }
                    if (!(y > ymax)) continue;
                    ymax = y;
                }
            }
            box = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return box;
    }

    public Rectangle2D getBoundingBox(double t1, double t2) {
        if (t1 < -this.eps4) {
            System.err.println("*** Error in Segment2D.getBoundingBox: t1 parameter out of bound, t1=" + t1);
            t1 = 0.0;
        }
        if (t2 > 1.0 + this.eps4) {
            System.err.println("*** Error in Segment2D.getBoundingBox: t2 out of bound, t2=" + t2);
            t2 = 1.0;
        }
        Segment2D trimmedSegment = this.trimSegment(t1, t2);
        return trimmedSegment.getBoundingBox();
    }

    public Segment2D resizeSegment(Rectangle2D oldBox, Rectangle2D newBox) {
        Shape curve;
        if (this.debug > 0) {
            System.out.println("++Segment2D.resizeSegment oldBox=" + Util.Rect(oldBox) + ", newBox=" + Util.Rect(newBox));
        }
        double x = oldBox.getX();
        double y = oldBox.getY();
        double w = oldBox.getWidth();
        double h = oldBox.getHeight();
        double X = newBox.getX();
        double Y = newBox.getY();
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (w > 0.0) {
            scaleX = newBox.getWidth() / w;
        }
        if (h > 0.0) {
            scaleY = newBox.getHeight() / h;
        }
        Segment2D newSegment = null;
        if (this.type == 0) {
            newSegment = new Segment2D(this.type, null, null);
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.getShape();
            double x0 = scaleX * (line.getP1().getX() - x) + X;
            double y0 = scaleY * (line.getP1().getY() - y) + Y;
            double x1 = scaleX * (line.getP2().getX() - x) + X;
            double y1 = scaleY * (line.getP2().getY() - y) + Y;
            Line2D.Double newLine = new Line2D.Double(x0, y0, x1, y1);
            newSegment = new Segment2D(1, newLine);
        }
        if (this.type == 2) {
            if (this.affineTransform == null) {
                Arc2D arc = (Arc2D)this.shape;
                double start = arc.getAngleStart();
                double extent = arc.getAngleExtent();
                double x0 = scaleX * (arc.getX() - x) + X;
                double y0 = scaleY * (arc.getY() - y) + Y;
                Arc2D.Double newArc = new Arc2D.Double(x0, y0, scaleX * arc.getWidth(), scaleY * arc.getHeight(), start, extent, 0);
                newSegment = new Segment2D(2, newArc);
            } else {
                Matrix2D matrix = Matrix2D.getResizeMatrix(oldBox, newBox);
                Matrix2D oldMatrix = new Matrix2D();
                oldMatrix.setAffineTransform(this.affineTransform);
                Matrix2D newMatrix = Matrix2D.multMatrix(matrix, oldMatrix);
                AffineTransform newAffine = newMatrix.getAffineTransform();
                newSegment = new Segment2D(2, this.shape, newAffine);
            }
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.getShape();
            Point2D[] Q = new Point2D[]{((CubicCurve2D)curve).getP1(), ((CubicCurve2D)curve).getCtrlP1(), ((CubicCurve2D)curve).getCtrlP2(), ((CubicCurve2D)curve).getP2()};
            for (int i = 0; i < 4; ++i) {
                Q[i].setLocation(scaleX * (Q[i].getX() - x) + X, scaleY * (Q[i].getY() - y) + Y);
            }
            CubicCurve2D.Double newCurve = new CubicCurve2D.Double(Q[0].getX(), Q[0].getY(), Q[1].getX(), Q[1].getY(), Q[2].getX(), Q[2].getY(), Q[3].getX(), Q[3].getY());
            newSegment = new Segment2D(3, newCurve);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.getShape();
            Point2D[] Q = new Point2D[]{((QuadCurve2D)curve).getP1(), ((QuadCurve2D)curve).getCtrlPt(), ((QuadCurve2D)curve).getP2()};
            for (int i = 0; i < 3; ++i) {
                Q[i].setLocation(scaleX * (Q[i].getX() - x) + X, scaleY * (Q[i].getY() - y) + Y);
            }
            QuadCurve2D.Double newCurve = new QuadCurve2D.Double(Q[0].getX(), Q[0].getY(), Q[1].getX(), Q[1].getY(), Q[2].getX(), Q[2].getY());
            newSegment = new Segment2D(4, newCurve);
        }
        if (this.debug > 0) {
            System.out.println("++Segment2D.resizeSegment curve2D=" + this.toString());
        }
        return newSegment;
    }

    public Segment2D trimSegment(double t1, double t2) {
        Vector2D DP1;
        Vector2D[] Q;
        Segment2D subSegment = null;
        if (t1 < 0.0 || t1 > 1.0 || t2 < 0.0 || t2 > 1.0) {
            System.out.println("Segment2D.subSegment t1 or t2 out of bound: t1=" + t1 + ", t2=" + t2);
        }
        if (this.type == 0) {
            subSegment = new Segment2D(this.type, null, null);
        }
        if (this.type == 1) {
            Point2D P1 = this.getP(t1);
            Point2D P2 = this.getP(t2);
            Line2D.Double line = new Line2D.Double(P1, P2);
            subSegment = new Segment2D(1, line, null);
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double x = arc.getX();
            double y = arc.getY();
            double w = arc.getWidth();
            double h = arc.getHeight();
            double start = arc.getAngleStart();
            double extent = arc.getAngleExtent();
            Arc2D.Double subArc = new Arc2D.Double(x, y, w, h, start + extent * t1, extent * (t2 - t1), 0);
            subSegment = this.affineTransform == null ? new Segment2D(2, subArc, null) : new Segment2D(2, subArc, (AffineTransform)this.affineTransform.clone());
        }
        if (this.type == 3) {
            Q = new Vector2D[4];
            Q[0] = new Vector2D(this.getP(t1));
            Q[3] = new Vector2D(this.getP(t2));
            double interval = t2 - t1;
            Vector2D DP0 = Vector2D.multiply(interval, this.getTangent(t1));
            DP1 = Vector2D.multiply(interval, this.getTangent(t2));
            DP0 = Vector2D.multiply(0.3333333333333333, DP0);
            Q[1] = Vector2D.add(Q[0], DP0);
            DP1 = Vector2D.multiply(0.3333333333333333, DP1);
            Q[2] = Vector2D.sub(Q[3], DP1);
            CubicCurve2D.Double curve = new CubicCurve2D.Double(Q[0].getX(), Q[0].getY(), Q[1].getX(), Q[1].getY(), Q[2].getX(), Q[2].getY(), Q[3].getX(), Q[3].getY());
            subSegment = new Segment2D(3, curve, null);
        }
        if (this.type == 4) {
            Q = new Vector2D[3];
            Q[0] = new Vector2D(this.getP(t1));
            Q[2] = new Vector2D(this.getP(t2));
            double interval = t2 - t1;
            Vector2D DP0 = Vector2D.multiply(interval, this.getTangent(t1));
            DP1 = Vector2D.multiply(interval, this.getTangent(t2));
            DP0 = Vector2D.multiply(0.5, DP0);
            Q[1] = Vector2D.add(Q[0], DP0);
            DP1 = Vector2D.multiply(0.5, DP1);
            Vector2D Q1 = Vector2D.sub(Q[2], DP1);
            QuadCurve2D.Double curve = new QuadCurve2D.Double(Q[0].getX(), Q[0].getY(), Q[1].getX(), Q[1].getY(), Q[2].getX(), Q[2].getY());
            subSegment = new Segment2D(4, curve, null);
            double error = Vector2D.dist(Q[1], Q1);
            if (error > this.eps4) {
                System.err.println("*** ERROR Segment2D.trimSegment QuadCurve2D error=" + error);
            }
        }
        return subSegment;
    }

    public FergusonCurve2D getFergusonCurve() {
        FergusonCurve2D fergusonCurve = null;
        if (this.type == 0) {
            System.out.println("*** ERROR Segment2D.trimSegment, MOVETO segment, return null");
            return null;
        }
        if (this.getType() == 1 || this.getType() == 3) {
            Point2D[] P = new Point2D[2];
            Vector2D[] Tin = new Vector2D[2];
            Vector2D[] Tout = new Vector2D[2];
            double t = 0.0;
            for (int i = 0; i <= 1; ++i) {
                P[i] = this.getP(i);
                Tin[i] = this.getTangent(i);
                Tout[i] = this.getTangent(i);
            }
            fergusonCurve = new FergusonCurve2D(P, Tin, Tout);
        }
        if (this.getType() == 2) {
            int i;
            double h;
            double w;
            double minR;
            double anglePitch;
            double segmentPitch;
            Arc2D arc = (Arc2D)this.shape;
            double segmentLength = this.getSegmentLength(0.0, 1.0);
            int div = (int)(segmentLength / (segmentPitch = (anglePitch = 0.3490658503988659) * (minR = 0.5 * Math.min(w = arc.getWidth(), h = arc.getHeight()))));
            if (div == 0) {
                div = 1;
            }
            System.out.println("** Segment2D.convertArcToCubic segmentPich=" + Util.Num(segmentPitch) + ", division=" + div);
            double dt = 1.0 / (double)div;
            Point2D[] P = new Point2D[div + 1];
            Vector2D[] Tin = new Vector2D[div + 1];
            Vector2D[] Tout = new Vector2D[div + 1];
            double t = 0.0;
            for (i = 0; i <= div; ++i) {
                P[i] = this.getP(t);
                Tin[i] = Vector2D.multiply(dt, this.getTangent(t));
                Tout[i] = (Vector2D)Tin[i].clone();
                t += dt;
            }
            fergusonCurve = new FergusonCurve2D();
            for (i = 0; i < div; ++i) {
                Vector2D[] optimizedTangents = FergusonCurve2D.getOptimizedTangents(P[i], P[i + 1], Tout[i], Tin[i + 1]);
                Tout[i] = optimizedTangents[0];
                Tin[i + 1] = optimizedTangents[1];
            }
            fergusonCurve = new FergusonCurve2D(P, Tin, Tout);
        }
        return fergusonCurve;
    }

    public Segment2D transformSegment(Matrix2D M) {
        Point2D[] newQ;
        Point2D[] Q;
        Shape curve;
        Segment2D newSegment = null;
        if (this.type == 0) {
            newSegment = new Segment2D(this.type, null, null);
            return newSegment;
        }
        if (this.type == 1) {
            Point2D P1 = this.getP(0.0);
            Point2D P2 = this.getP(1.0);
            Point2D newP1 = Matrix2D.transForm(M, P1);
            Point2D newP2 = Matrix2D.transForm(M, P2);
            Line2D.Double newLine = new Line2D.Double(newP1, newP2);
            newSegment = new Segment2D(1, newLine);
        }
        if (this.type == 2) {
            if (this.affineTransform == null) {
                this.affineTransform = new AffineTransform();
            }
            Matrix2D oldMatrix = new Matrix2D();
            oldMatrix.setAffineTransform(this.affineTransform);
            Matrix2D newMatrix = Matrix2D.multMatrix(M, oldMatrix);
            AffineTransform newAffine = newMatrix.getAffineTransform();
            newSegment = new Segment2D(2, this.shape, newAffine);
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Q = new Point2D[]{((CubicCurve2D)curve).getP1(), ((CubicCurve2D)curve).getCtrlP1(), ((CubicCurve2D)curve).getCtrlP2(), ((CubicCurve2D)curve).getP2()};
            newQ = new Point2D[4];
            for (int i = 0; i < 4; ++i) {
                newQ[i] = Matrix2D.transForm(M, Q[i]);
            }
            CubicCurve2D.Double newCurve = new CubicCurve2D.Double(newQ[0].getX(), newQ[0].getY(), newQ[1].getX(), newQ[1].getY(), newQ[2].getX(), newQ[2].getY(), newQ[3].getX(), newQ[3].getY());
            newSegment = new Segment2D(3, newCurve);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Q = new Point2D[]{((QuadCurve2D)curve).getP1(), ((QuadCurve2D)curve).getCtrlPt(), ((QuadCurve2D)curve).getP2()};
            newQ = new Point2D[3];
            for (int i = 0; i < 3; ++i) {
                newQ[i] = Matrix2D.transForm(M, Q[i]);
            }
            QuadCurve2D.Double newCurve = new QuadCurve2D.Double(newQ[0].getX(), newQ[0].getY(), newQ[1].getX(), newQ[1].getY(), newQ[2].getX(), newQ[2].getY());
            newSegment = new Segment2D(4, newCurve);
        }
        return newSegment;
    }

    public Segment2D reverseSegment() {
        Point2D Q1;
        Point2D Q0;
        Shape curve;
        Segment2D newSegment = null;
        if (this.type == 0) {
            newSegment = new Segment2D(this.type, null, null);
            return newSegment;
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            Line2D.Double newLine = new Line2D.Double(line.getP2(), line.getP1());
            newSegment = new Segment2D(1, newLine);
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double angleStart = arc.getAngleStart();
            double angleExtent = arc.getAngleExtent();
            Arc2D.Double newArc = new Arc2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), angleStart + angleExtent, -angleExtent, 0);
            newSegment = new Segment2D(2, newArc, this.affineTransform);
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Q0 = ((CubicCurve2D)curve).getP1();
            Q1 = ((CubicCurve2D)curve).getCtrlP1();
            Point2D Q2 = ((CubicCurve2D)curve).getCtrlP2();
            Point2D Q3 = ((CubicCurve2D)curve).getP2();
            CubicCurve2D.Double newCubic = new CubicCurve2D.Double(Q3.getX(), Q3.getY(), Q2.getX(), Q2.getY(), Q1.getX(), Q1.getY(), Q0.getX(), Q0.getY());
            newSegment = new Segment2D(3, newCubic);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Q0 = ((QuadCurve2D)curve).getP1();
            Q1 = ((QuadCurve2D)curve).getCtrlPt();
            Point2D Q2 = ((QuadCurve2D)curve).getP2();
            QuadCurve2D.Double newCurve = new QuadCurve2D.Double(Q2.getX(), Q2.getY(), Q1.getX(), Q1.getY(), Q0.getX(), Q0.getY());
            newSegment = new Segment2D(4, newCurve);
        }
        return newSegment;
    }

    public Segment2D moveSegmentEndPT(int index, Point2D newPT) {
        Segment2D newSegment = null;
        if (this.type == 0) {
            newSegment = new Segment2D(this.type, null, null);
            return newSegment;
        }
        if (this.type == 1) {
            Line2D.Double newLine = null;
            Line2D line = (Line2D)this.getShape();
            newLine = index == 0 ? new Line2D.Double(newPT, line.getP2()) : new Line2D.Double(line.getP1(), newPT);
            newSegment = new Segment2D(1, newLine);
        }
        if (this.type == 2) {
            Point2D anchorP = null;
            Point2D movingP = null;
            if (index == 0) {
                movingP = this.getP(0.0);
                anchorP = this.getP(1.0);
            } else {
                movingP = this.getP(1.0);
                anchorP = this.getP(0.0);
            }
            if (Vector2D.dist(anchorP, movingP) < this.eps4) {
                return (Segment2D)this.clone();
            }
            Vector2D r0 = Vector2D.sub(movingP, anchorP);
            Vector2D r = Vector2D.sub(newPT, anchorP);
            Matrix2D rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
            newSegment = this.transformSegment(rotationMatrix);
        }
        if (this.type == 3) {
            FergusonCurve2D fergusonCurve = this.getFergusonCurve();
            fergusonCurve.movePoint(index, newPT);
            CubicCurve2D newCurve = fergusonCurve.getCubicCurve2D(0);
            newSegment = new Segment2D(3, newCurve);
        }
        if (this.type == 4) {
            QuadCurve2D.Double newCurve = null;
            QuadCurve2D curve = (QuadCurve2D)this.getShape();
            Point2D Q0 = curve.getP1();
            Point2D Q1 = curve.getCtrlPt();
            Point2D Q2 = curve.getP2();
            newCurve = index == 0 ? new QuadCurve2D.Double(newPT.getX(), newPT.getY(), Q1.getX(), Q1.getY(), Q2.getX(), Q2.getY()) : new QuadCurve2D.Double(Q0.getX(), Q0.getY(), Q1.getX(), Q1.getY(), newPT.getX(), newPT.getY());
            newSegment = new Segment2D(4, newCurve);
        }
        return newSegment;
    }

    public Segment2D moveSegmentTangent(int index, Vector2D newTangent) {
        Segment2D newSegment = null;
        if (this.type == 3) {
            FergusonCurve2D fergusonCurve = this.getFergusonCurve();
            int inout = 1;
            if (index == 1) {
                inout = 0;
            }
            fergusonCurve.moveTangent(index, inout, newTangent);
            CubicCurve2D newCubic = fergusonCurve.getCubicCurve2D(0);
            newSegment = new Segment2D(3, newCubic);
        } else {
            newSegment = (Segment2D)this.clone();
        }
        return newSegment;
    }

    public Object clone() {
        Shape newCurve;
        Shape curve;
        Segment2D newSegment = null;
        if (this.type == 0) {
            newSegment = new Segment2D(this.type, null, null);
            return newSegment;
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            Line2D newLine = (Line2D)line.clone();
            newSegment = new Segment2D(this.type, newLine, null);
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            Arc2D newArc = (Arc2D)arc.clone();
            newSegment = this.affineTransform == null ? new Segment2D(2, newArc, null) : new Segment2D(2, newArc, (AffineTransform)this.affineTransform.clone());
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            newCurve = (CubicCurve2D)((CubicCurve2D)curve).clone();
            newSegment = new Segment2D(this.type, newCurve, null);
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            newCurve = (QuadCurve2D)((QuadCurve2D)curve).clone();
            newSegment = new Segment2D(this.type, newCurve, null);
        }
        return newSegment;
    }

    public String toString() {
        Point2D Q1;
        Shape curve;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (this.type == 0) {
            str = "MoveTo";
        }
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            str = "LINE, x1,y1=" + Util.Num(line.getX1()) + ", " + Util.Num(line.getY1()) + ", x2,y2=" + Util.Num(line.getX2()) + ", " + Util.Num(line.getY2());
            if (Math.abs(line.getY1() - line.getY2()) < 0.001) {
                str = str + ",  x-line";
            }
            if (Math.abs(line.getX1() - line.getX2()) < 0.001) {
                str = str + ",  y-line";
            }
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            double x = arc.getX();
            double y = arc.getY();
            double w = arc.getWidth();
            double h = arc.getHeight();
            double angleStart = arc.getAngleStart();
            double angleEnd = angleStart + arc.getAngleExtent();
            double angleExtent = arc.getAngleExtent();
            double pai = Math.PI;
            double x1 = 0.5 * w * Math.cos(angleStart * pai / 180.0) + x + w / 2.0;
            double y1 = 0.5 * h * Math.sin(-angleStart * pai / 180.0) + y + h / 2.0;
            double x2 = 0.5 * w * Math.cos(angleEnd * pai / 180.0) + x + w / 2.0;
            double y2 = 0.5 * h * Math.sin(-angleEnd * pai / 180.0) + y + h / 2.0;
            Point2D p0 = this.getP(0.0);
            Point2D p1 = this.getP(1.0);
            String affineStr = ", AffineTransform";
            AffineTransform affine = this.affineTransform;
            if (affine == null) {
                affineStr = affineStr + "=null";
            } else {
                double[] elm = new double[6];
                affine.getMatrix(elm);
                affineStr = affineStr + "; m00=" + Util.Num(elm[0]) + ", m01=" + Util.Num(elm[2]) + ", m02=" + Util.Num(elm[4]) + ", m10=" + Util.Num(elm[1]) + ", m11=" + Util.Num(elm[3]) + ", m12=" + Util.Num(elm[5]);
            }
            str = str + "ARC, startP=" + Util.Pt(p0) + ", endP=" + Util.Pt(p1);
            str = str + ", x,y,w,h=" + Util.Num(x) + ", " + Util.Num(y) + ", " + Util.Num(w) + ", " + Util.Num(h);
            str = str + ", angleStart=" + Util.Num(angleStart) + ", angleEnd=" + Util.Num(angleEnd) + ", angleExtent=" + Util.Num(angleExtent);
            str = str + affineStr;
        }
        if (this.type == 3) {
            curve = (CubicCurve2D)this.shape;
            Point2D Q0 = ((CubicCurve2D)curve).getP1();
            Q1 = ((CubicCurve2D)curve).getCtrlP1();
            Point2D Q2 = ((CubicCurve2D)curve).getCtrlP2();
            Point2D Q3 = ((CubicCurve2D)curve).getP2();
            str = str + "CUBIC, P1=" + Util.Num(Q0.getX()) + "," + Util.Num(Q0.getY()) + ", P2=" + Util.Num(Q3.getX()) + "," + Util.Num(Q3.getY()) + ", CtrlP1=" + Util.Num(Q1.getX()) + "," + Util.Num(Q1.getY()) + ", CtrlP2=" + Util.Num(Q2.getX()) + "," + Util.Num(Q2.getY());
        }
        if (this.type == 4) {
            curve = (QuadCurve2D)this.shape;
            Point2D Q0 = ((QuadCurve2D)curve).getP1();
            Q1 = ((QuadCurve2D)curve).getCtrlPt();
            Point2D Q2 = ((QuadCurve2D)curve).getP2();
            str = str + "CUBIC, P1=" + Util.Num(Q0.getX()) + "," + Util.Num(Q0.getY()) + ", P2=" + Util.Num(Q2.getX()) + "," + Util.Num(Q2.getY()) + ", CtrlPt=" + Util.Num(Q1.getX()) + "," + Util.Num(Q1.getY());
        }
        return str;
    }

    public SerializableSegment2D getSerializableSegment2D() {
        SerializableSegment2D data = new SerializableSegment2D(this.type, this.shape, this.affineTransform);
        return data;
    }
}

