/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import menu.ColorChooserAction;
import menu.DrawImageIcon;
import menu.MenuConstants;
import menu.MenuUtil;

public class ButtonOfColorChooser
extends JButton {
    ColorChooserAction action = new ColorChooserAction(this);
    public static int debug = 0;

    public ButtonOfColorChooser(String commandName, String tip) {
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        this.setText(" " + commandName + " ");
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public ButtonOfColorChooser(String commandName, boolean setText, ImageIcon imageIcon, String tip) {
        super(imageIcon);
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        if (setText) {
            this.setText(commandName);
        }
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public void setStandardButtonStyle() {
        BevelBorder raisedBorder = new BevelBorder(0);
        this.setBorder(raisedBorder);
        this.setIconTextGap(0);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        this.setFont(MenuConstants.MenuFont);
        this.setBackground(null);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
    }

    public static JButton createColorChooserButton(String commandName, int width, String tip) {
        ButtonOfColorChooser button = new ButtonOfColorChooser(commandName, tip);
        if (width <= 0) {
            TextLayout textlayout = new TextLayout(commandName, MenuConstants.MenuFont, new FontRenderContext(null, false, false));
            int textWidth = (int)textlayout.getAdvance() + 5;
            button.setPreferredSize(new Dimension(textWidth, 22));
        } else {
            button.setPreferredSize(new Dimension(width, 22));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static JButton createColorChooserButton(String commandName, boolean setText, String imageName, String tip) {
        ButtonOfColorChooser button = null;
        if (imageName == null || imageName.equals("")) {
            button = new ButtonOfColorChooser(commandName, tip);
            TextLayout textlayout = new TextLayout(commandName, MenuConstants.MenuFont, new FontRenderContext(null, false, false));
            int textWidth = (int)textlayout.getAdvance() + 5;
            button.setPreferredSize(new Dimension(textWidth, 22));
        } else {
            ImageIcon icon = DrawImageIcon.get(imageName, 20, 20);
            button = new ButtonOfColorChooser(commandName, setText, icon, tip);
            button.setPreferredSize(new Dimension(22, 22));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}

