/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import menu.ButtonOfColorChooser;
import menu.DrawImageIcon;
import menu.JMenuEx;
import menu.MenuConstants;
import menu.MenuUtil;
import menu.PulldownMenuAction;

public class ButtonOfPulldownMenu
extends JMenuBar {
    JMenu menu = null;
    PulldownMenuAction menuAction = new PulldownMenuAction(this);
    public static int debug = 0;

    public ButtonOfPulldownMenu(String commandName, String tip) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu = new JMenuEx();
        this.add(this.menu);
        this.menu.setName(commandName);
        this.menu.setActionCommand(commandName);
        this.menu.addActionListener(this.menuAction);
        this.menu.setText(commandName);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public ButtonOfPulldownMenu(String commandName, ImageIcon imageIcon, String tip) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu = new JMenu();
        this.menu.setName(commandName);
        this.menu.setActionCommand(commandName);
        this.menu.addActionListener(this.menuAction);
        this.add(this.menu);
        if (imageIcon != null) {
            this.menu.setIcon(imageIcon);
        }
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public void setStandardButtonStyle() {
        BevelBorder raisedBorder = new BevelBorder(0);
        this.menu.setBorder(raisedBorder);
        this.menu.setFont(MenuConstants.MenuFont);
        this.menu.setIconTextGap(0);
        this.menu.setOpaque(true);
        Color backGround = new Color(14543091);
        this.menu.setBackground(backGround);
        this.menu.setForeground(Color.black);
    }

    public void setSelected(boolean selected) {
        this.menu.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this.menu.isSelected();
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setMenuItems(String[] menuItemNames, ImageIcon[] imageIcons, String[] accelerators) {
        int acceleratorWidth = 24;
        int textWidthMax = 0;
        int textHeightMax = 0;
        for (int i = 0; i < menuItemNames.length; ++i) {
            Dimension textSize = this.getTextLayoutSize(menuItemNames[i], MenuConstants.MenuItemFont);
            int textWidth = (int)textSize.getWidth();
            int textHeight = (int)textSize.getHeight();
            if (accelerators != null && !accelerators[i].equals("")) {
                textWidth += acceleratorWidth;
            }
            if (textWidth > textWidthMax) {
                textWidthMax = textWidth;
            }
            if (textHeight <= textHeightMax) continue;
            textHeightMax = textHeight;
        }
        int marginWidth = 32;
        int marginHeight = 6;
        for (int i = 0; i < menuItemNames.length; ++i) {
            JMenuItem menuItem = new JMenuItem();
            if (accelerators != null && !accelerators[i].equals("")) {
                KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
                menuItem.setAccelerator(stroke);
            }
            int imageWidth = 0;
            int imageHeight = 0;
            int menuItemWidth = 0;
            if (imageIcons[i] != null) {
                menuItem.setLayout(new FlowLayout(0, 0, 0));
                JLabel textLabel = new JLabel(" " + menuItemNames[i] + " ");
                textLabel.setPreferredSize(new Dimension(textWidthMax + marginWidth, textHeightMax + marginHeight));
                menuItem.add(textLabel);
                menuItemWidth += textWidthMax + marginWidth;
                Image image = imageIcons[i].getImage();
                imageWidth = image.getWidth(null);
                imageHeight = image.getHeight(null);
                JLabel imageLabel = new JLabel(imageIcons[i]);
                imageLabel.setPreferredSize(new Dimension(imageWidth, imageHeight));
                menuItem.add(imageLabel);
                menuItemWidth += imageWidth + marginWidth;
            } else {
                menuItem.setText(menuItemNames[i]);
                menuItemWidth += textWidthMax + marginWidth;
            }
            int menuItemHeight = textHeightMax + marginHeight;
            menuItem.setPreferredSize(new Dimension(menuItemWidth, menuItemHeight));
            menuItem.setActionCommand(menuItemNames[i]);
            menuItem.addActionListener(this.menuAction);
            menuItem.setName(menuItemNames[i]);
            this.menu.add(menuItem);
        }
    }

    private Dimension getTextLayoutSize(String text, Font font) {
        TextLayout textlayout = new TextLayout(text, font, new FontRenderContext(null, false, false));
        int textWidth = (int)textlayout.getAdvance();
        int textHeight = (int)(textlayout.getAscent() + textlayout.getDescent());
        return new Dimension(textWidth, textHeight);
    }

    public void setSelectedMenuItem(String menuItemName) {
        if (debug > 0) {
            System.out.println("** ButtonOfPullDownMenu.selectedMenuItem menuItemName=" + menuItemName);
        }
        BevelBorder loweredBorder = new BevelBorder(1);
        Component[] components = this.menu.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem menuItem = (JMenuItem)components[i];
            menuItem.setBackground(null);
            menuItem.setBorder(null);
            String name = menuItem.getName();
            if (!Command.compareStrings(name, menuItemName)) continue;
            menuItem.setBackground(Color.WHITE);
            menuItem.setBorder(loweredBorder);
        }
    }

    public JMenuItem getMenuItem(JMenu menu, String menuItemName) {
        AbstractButton menuItem = null;
        Component[] components = menu.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem item;
            String name;
            JMenu subMenu;
            JMenuItem item2;
            String type = components[i].getClass().getSimpleName();
            if (type.equals("JMenu") && (item2 = this.getMenuItem(subMenu = (JMenu)components[i], menuItemName)) != null) {
                menuItem = item2;
                break;
            }
            if (type.equals("JMenuItem") && Command.compareStrings(name = (item = (JMenuItem)components[i]).getName(), menuItemName)) {
                menuItem = item;
                break;
            }
            if (!type.equals("JCheckBoxMenuItem") || !Command.compareStrings(name = (item = (JCheckBoxMenuItem)components[i]).getName(), menuItemName)) continue;
            menuItem = item;
            break;
        }
        if (debug > 0) {
            System.out.println("  --> ButtonOfPullDownMenu.getMenuItem " + menuItemName + ", return menuItem=" + menuItem.getActionCommand());
        }
        return menuItem;
    }

    public static ButtonOfPulldownMenu createPageButton(int width) {
        String tip = "page";
        String commandName = Command.getCommandLowerString(4);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        button.setPreferredSize(new Dimension(width, 22));
        String[] menuItemNames = new String[]{"next page", "previous page", "last page", "top page", "insert new page", "delete page", "page setup"};
        String[] imageName = new String[]{"", "", "", "", "", "", ""};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.menu.setPreferredSize(new Dimension(width, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createEditButton(int width) {
        String tip = "edit";
        String commandName = Command.getCommandLowerString(20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        button.setPreferredSize(new Dimension(width, 22));
        String[] menuItemNames = new String[]{"cut", "copy", "paste", "select all"};
        String[] imageName = new String[]{"", "", "", "", ""};
        String[] accelerators = new String[]{"ctrl X", "ctrl C", "ctrl V", "ctrl A"};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, accelerators);
        button.menu.setPreferredSize(new Dimension(width, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createAuxShapeButton(int width) {
        String tip = "create auxiliary shape";
        String commandName = Command.getCommandLowerString(60);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu = button.getMenu();
        button.setPreferredSize(new Dimension(width, 22));
        String[] menuItemNames = new String[]{"center line", "line bisector", "angle bisector"};
        String[] imageName = new String[]{"", "", "", "", "", "", "", "", "", ""};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        menu.setPreferredSize(new Dimension(width, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createShapeUtilButton(int width) {
        String tip = "shape utility";
        String commandName = Command.getCommandLowerString(85);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu = button.getMenu();
        button.setPreferredSize(new Dimension(width, 22));
        String[] menuItemNames = new String[]{"shape format", "draw panel information", "add textbox", "delete textbox", "translate", "rotate", "flip", "modify shape", "cut shape", "connect curves", "combine", "break"};
        String[] imageName = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        menu.insertSeparator(2);
        menu.insertSeparator(5);
        menu.insertSeparator(9);
        menu.insertSeparator(13);
        menu.setPreferredSize(new Dimension(width, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createSettingButton(int width) {
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        String commandName = Command.getCommandLowerString(110);
        String tip = "draw assistant mark or shape";
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setName(commandName);
        JMenu menu = button.getMenu();
        button.setPreferredSize(new Dimension(width, 22));
        PulldownMenuAction action = new PulldownMenuAction(button);
        String[] actionCommands = new String[3];
        commandName = Command.getCommandLowerString(111);
        JCheckBoxMenuItem autoAlignCheckBox = new JCheckBoxMenuItem(commandName);
        autoAlignCheckBox.addActionListener(action);
        actionCommands[0] = commandName;
        autoAlignCheckBox.setName(actionCommands[0]);
        autoAlignCheckBox.setActionCommand(actionCommands[0]);
        autoAlignCheckBox.setSelected(true);
        menu.add(autoAlignCheckBox);
        commandName = Command.getCommandLowerString(112);
        JCheckBoxMenuItem connectorCheckBox = new JCheckBoxMenuItem("enable connector");
        connectorCheckBox.addActionListener(action);
        actionCommands[0] = Command.getCommandLowerString(112);
        connectorCheckBox.setName(actionCommands[0]);
        connectorCheckBox.setActionCommand(actionCommands[0]);
        connectorCheckBox.setSelected(true);
        menu.add(connectorCheckBox);
        JMenu connectorDirItem = new JMenu("auto tracking option of connectors");
        actionCommands[0] = Command.getCommandLowerString(113);
        actionCommands[1] = Command.getCommandLowerString(114);
        JCheckBoxMenuItem noDir = new JCheckBoxMenuItem("free direction");
        JCheckBoxMenuItem xyDir = new JCheckBoxMenuItem("keep x/y direction");
        xyDir.setSelected(true);
        noDir.setName(actionCommands[0]);
        xyDir.setName(actionCommands[1]);
        noDir.setActionCommand(actionCommands[0]);
        xyDir.setActionCommand(actionCommands[1]);
        noDir.addActionListener(action);
        xyDir.addActionListener(action);
        ButtonGroup group = new ButtonGroup();
        group.add(noDir);
        group.add(xyDir);
        ((Container)connectorDirItem).add(noDir);
        ((Container)connectorDirItem).add(xyDir);
        menu.add(connectorDirItem);
        actionCommands[0] = Command.getCommandLowerString(118);
        JCheckBoxMenuItem highlightingCheckBox = new JCheckBoxMenuItem(actionCommands[0]);
        highlightingCheckBox.addActionListener(action);
        highlightingCheckBox.setName(actionCommands[0]);
        highlightingCheckBox.setActionCommand(actionCommands[0]);
        highlightingCheckBox.setSelected(true);
        menu.add(highlightingCheckBox);
        actionCommands[0] = Command.getCommandLowerString(119);
        JCheckBoxMenuItem nodeCheckBox = new JCheckBoxMenuItem(actionCommands[0]);
        nodeCheckBox.addActionListener(action);
        nodeCheckBox.setName(actionCommands[0]);
        nodeCheckBox.setActionCommand(actionCommands[0]);
        menu.add(nodeCheckBox);
        menu.setPreferredSize(new Dimension(width, 22));
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
            String target = Command.getCommandLowerString(114);
            menuUtil.getChildComponent(button, target, "JCheckBoxMenuItem");
        }
        return button;
    }

    public static ButtonOfPulldownMenu createTextAlignButton() {
        String commandName = Command.getCommandLowerString(142);
        String buttonImage = "text_align_left32T.png";
        String tip = "text_align";
        String[] menuItemNames = new String[]{"text align left", "text align center", "text align right"};
        String[] imageName = new String[]{"text_align_left32T.png", "text_align_center32T.png", "text_align_right32T.png"};
        ImageIcon buttonIcon = DrawImageIcon.get(buttonImage, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        button.setPreferredSize(new Dimension(22, 22));
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 20, 20);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createFillColorChooserButton(boolean icon) {
        String commandName = Command.getCommandLowerString(150);
        String buttonImage = "fill_color32T.png";
        String tip = "fill color";
        ImageIcon buttonIcon = DrawImageIcon.get(buttonImage, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setPreferredSize(new Dimension(64, 22));
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
            button.setPreferredSize(new Dimension(22, 22));
        }
        JMenuItem noFillItem = new JMenuItem("no fill");
        noFillItem.setActionCommand("no fill");
        noFillItem.setName(commandName);
        noFillItem.addActionListener(button.menuAction);
        button.menu.add(noFillItem);
        JMenuItem fillColorItem = new JMenuItem();
        fillColorItem.setLayout(new FlowLayout(0, 0, 0));
        JButton colorChooser = ButtonOfColorChooser.createColorChooserButton("fill color", 64, "fill color");
        fillColorItem.add(colorChooser);
        fillColorItem.setPreferredSize(new Dimension(72, 24));
        button.menu.add(fillColorItem);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        return button;
    }

    public static ButtonOfPulldownMenu createLineColorChooserButton(boolean icon) {
        String commandName = Command.getCommandLowerString(151);
        String buttonImage = "line_color32T.png";
        String tip = "line color";
        ImageIcon buttonIcon = DrawImageIcon.get(buttonImage, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        button.setPreferredSize(new Dimension(64, 22));
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
            button.setPreferredSize(new Dimension(22, 22));
        }
        JMenuItem noLineItem = new JMenuItem("no line");
        noLineItem.setActionCommand("no line");
        noLineItem.setName("no line");
        noLineItem.addActionListener(button.menuAction);
        button.getMenu().add(noLineItem);
        JMenuItem lineColorItem = new JMenuItem("line color");
        lineColorItem.setLayout(new FlowLayout(0, 0, 0));
        lineColorItem.setName("line color");
        JButton colorChooser = ButtonOfColorChooser.createColorChooserButton("line color", 64, "line color");
        lineColorItem.add(colorChooser);
        lineColorItem.setPreferredSize(new Dimension(72, 24));
        button.getMenu().add(lineColorItem);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createLineWidthButton(boolean icon) {
        String commandName = Command.getCommandLowerString(152);
        String imageFilePath = "line_style32T.png";
        String tip = "line width";
        String[] imageName = new String[]{"line0.5pt.png", "line1.0pt.png", "line1.5pt.png", "line2.0pt.png", "line2.5pt.png", "line3.0pt.png", "line4.0pt.png", "line5.0pt.png", "line6.0pt.png"};
        String[] menuItemNames = new String[]{"0.5 pt", "1.0 pt", "1.5 pt", "2.0 pt", "2.5 pt", "3.0 pt", "4.0 pt", "5.0 pt", "6.0 pt"};
        ImageIcon buttonIcon = DrawImageIcon.get(imageFilePath, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        }
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createLineStrokeButton(boolean icon) {
        String commandName = Command.getCommandLowerString(153);
        String imageFilePath = "dashed_style32T.png";
        String tip = "line stroke";
        String[] imageName = new String[]{"dashed_style_solid.png", "dashed_style_roundedDot.png", "dashed_style_squareDot.png", "dashed_style_dash.png", "dashed_style_dashDot.png", "dashed_style_dashDotDot.png"};
        String[] menuItemNames = new String[]{"solid", "roundedDot", "squareDot", "dash", "dashDot", "dashDotDot"};
        ImageIcon buttonIcon = DrawImageIcon.get(imageFilePath, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        }
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createArrowStyleButton(boolean icon) {
        String commandName = Command.getCommandLowerString(154);
        String imageFilePath = "arrow_style32T.png";
        String tip = "arrow style";
        String[] imageName = new String[]{"arrow_style1.png", "arrow_style2.png", "arrow_style3.png", "arrow_style4.png", "arrow_style5.png", "arrow_style6.png", "arrow_style7.png"};
        String[] menuItemNames = new String[]{"arrow style 1", "arrow style 2", "arrow style 3", "arrow style 4", "arrow style 5", "arrow style 6", "arrow style 7"};
        ImageIcon buttonIcon = DrawImageIcon.get(imageFilePath, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        }
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createZorderButton(boolean icon) {
        String commandName = Command.getCommandLowerString(160);
        String imageFilePath = "move_to_front32T.png";
        String tip = "depth position";
        String[] menuItemNames = new String[]{"move to front", "move to back", "move forward", "move backward"};
        String[] imageName = new String[]{"move_to_front32T.png", "move_to_back32T.png", "move_forward32T.png", "move_backward32T.png"};
        ImageIcon buttonIcon = DrawImageIcon.get(imageFilePath, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        }
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 20, 20);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createAlignButton(boolean icon) {
        String commandName = Command.getCommandLowerString(170);
        String imageFilePath = "align_left32T.png";
        String tip = "align";
        String[] menuItemNames = new String[]{"align_left", "align_center", "align_right", "align_top", "align_middle", "align_bottom"};
        String[] imageName = new String[]{"align_left32T.png", "align_center32T.png", "align_right32T.png", "align_top32T.png", "align_middle32T.png", "align_bottom32T.png"};
        ImageIcon buttonIcon = DrawImageIcon.get(imageFilePath, 20, 20);
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, tip);
        if (icon) {
            button = new ButtonOfPulldownMenu(commandName, buttonIcon, tip);
        }
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 20, 20);
        }
        button.setMenuItems(menuItemNames, itemIcons, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfPulldownMenu createTestButton(int width) {
        String commandName = Command.getCommandLowerString(191);
        String[] actionCommands = new String[3];
        JMenuItem[] menuItems = new JMenuItem[3];
        ButtonOfPulldownMenu button = new ButtonOfPulldownMenu(commandName, commandName);
        JMenu menu = button.getMenu();
        PulldownMenuAction action = new PulldownMenuAction(button);
        JMenuItem geomItem = new JMenuItem("geometric test  ");
        actionCommands[0] = Command.getCommandLowerString(192);
        geomItem.setName(actionCommands[0]);
        geomItem.setActionCommand(actionCommands[0]);
        geomItem.addActionListener(action);
        menu.add(geomItem);
        JCheckBoxMenuItem boxItem = new JCheckBoxMenuItem("draw bounding box");
        actionCommands[0] = Command.getCommandLowerString(193);
        boxItem.setName(actionCommands[0]);
        boxItem.setActionCommand(actionCommands[0]);
        boxItem.addActionListener(action);
        menu.add(boxItem);
        JCheckBoxMenuItem charItem = new JCheckBoxMenuItem("draw characteristic points");
        actionCommands[0] = Command.getCommandLowerString(194);
        charItem.setName(actionCommands[0]);
        charItem.setActionCommand(actionCommands[0]);
        charItem.addActionListener(action);
        menu.add(charItem);
        JCheckBoxMenuItem layoutItem = new JCheckBoxMenuItem("draw textLayout bound");
        actionCommands[0] = Command.getCommandLowerString(195);
        layoutItem.setName(actionCommands[0]);
        layoutItem.setActionCommand(actionCommands[0]);
        layoutItem.addActionListener(action);
        menu.add(layoutItem);
        JCheckBoxMenuItem unselectableItem = new JCheckBoxMenuItem("draw unselectable areas");
        actionCommands[0] = Command.getCommandLowerString(196);
        unselectableItem.setName(actionCommands[0]);
        unselectableItem.setActionCommand(actionCommands[0]);
        unselectableItem.addActionListener(action);
        JMenuItem connectionItem = new JMenuItem("draw Connection mark");
        actionCommands[0] = Command.getCommandLowerString(197);
        connectionItem.setName(actionCommands[0]);
        connectionItem.setActionCommand(actionCommands[0]);
        connectionItem.addActionListener(action);
        button.getMenu().setPreferredSize(new Dimension(width, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}

