/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ListenerPanel;
import DrawTop.ObjectTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import menu.DialogOfDrawPanelAction;
import menu.DialogOfDrawPanelListener;
import menu.DialogOfShapeFormat;
import menu.MenuConstants;
import menu.MenuUtil;
import shape.ShapeContainer;
import util.ContainerManager;

public class DialogOfDrawPanel
extends JDialog {
    DialogOfDrawPanelAction action = null;
    JScrollPane shapeScrollPane;
    JScrollPane listenerScrollPane;
    Dimension dialogDimension = new Dimension(500, 300);

    public DialogOfDrawPanel() {
        super((Frame)ObjectTable.getDrawMain(), "Draw Panel Information");
        this.setName("DialogOfDrawPanel");
        this.action = new DialogOfDrawPanelAction(this);
        this.addWindowListener(this.action);
    }

    @Override
    public void setTitle(String str) {
        this.setTitle(str);
    }

    public void showDialog(Point mousePosition) {
        DialogOfDrawPanelListener DialogListener = new DialogOfDrawPanelListener(this);
        this.addComponentListener(DialogListener);
        Window owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)mousePosition.getX(), owner.getY() + (int)mousePosition.getY());
        this.setLocation(pos);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        contentPane.add((Component)tabbedPane, "Center");
        JPanel shapeInformationPanel = this.createShapeInfoPanel();
        JPanel listenerInformationPanel = this.createListenerInfoPanel();
        tabbedPane.add("shapes information", shapeInformationPanel);
        tabbedPane.add("listeners information", listenerInformationPanel);
        this.setPreferredSize(this.dialogDimension);
        this.pack();
        this.setVisible(true);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        DialogOfShapeFormat dialog = (DialogOfShapeFormat)menuUtil.getMenuComponent("DialogOfDrawPanel");
        if (dialog != null) {
            dialog.removeDialog();
        }
        menuUtil.setMenuComponent(this);
    }

    protected void removeDialog() {
        this.setVisible(false);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    protected void setScrollViewPosition() {
        this.shapeScrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.listenerScrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    private JPanel createShapeInfoPanel() {
        JScrollPane scrollPane;
        JPanel basePanel = new JPanel();
        JPanel informationPanel = new JPanel();
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Shapes information");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        informationPanel.setBorder(frameBorder);
        GridLayout inforMationPanelLayout = new GridLayout(1, 2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        informationPanel.setLayout(inforMationPanelLayout);
        JTextArea textArea = new JTextArea();
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ArrayList containerList = containerManager.getContainerList();
        String info = "";
        int size = containerList.size();
        if (size == 0) {
            info = info + "No containers";
        } else {
            info = info + "containers list";
            for (int i = 0; i < size; ++i) {
                ShapeContainer container = (ShapeContainer)containerList.get(i);
                info = info + "\n\n ** container[" + i + "] : " + container.toString();
            }
        }
        textArea.setText(info);
        this.shapeScrollPane = scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = new JViewport();
        scrollPane.setViewport(viewport);
        viewport.setView(textArea);
        viewport.setViewPosition(new Point(0, 0));
        informationPanel.add(scrollPane);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(informationPanel);
        box.add(Box.createVerticalStrut(5));
        return basePanel;
    }

    private JPanel createListenerInfoPanel() {
        JScrollPane scrollPane;
        JPanel basePanel = new JPanel();
        JPanel informationPanel = new JPanel();
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Listeners information");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        informationPanel.setBorder(frameBorder);
        GridLayout inforMationPanelLayout = new GridLayout(1, 2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        informationPanel.setLayout(inforMationPanelLayout);
        JTextArea textArea = new JTextArea();
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("");
        String str = listenerPanel.getMouseListenersInfo();
        textArea.setText(str);
        this.listenerScrollPane = scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = new JViewport();
        scrollPane.setViewport(viewport);
        viewport.setView(textArea);
        viewport.setViewPosition(new Point(0, 0));
        informationPanel.add(scrollPane);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(informationPanel);
        box.add(Box.createVerticalStrut(5));
        return basePanel;
    }

    public JScrollPane getShapeScrollPane() {
        return this.shapeScrollPane;
    }

    public JScrollPane getListenerScrollPane() {
        return this.listenerScrollPane;
    }
}

