/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import menu.DrawImageIcon;
import menu.MenuConstants;
import menu.MenuUtil;
import menu.PageSetupAction;

public class DialogOfPageSetup
extends JDialog {
    PageSetupAction action = null;
    SpinnerListModel pageSizeSpinnerModel;
    JRadioButton landscapeButton;
    JRadioButton portraitButton;

    public DialogOfPageSetup() {
        super((Frame)ObjectTable.getDrawMain(), "Page Setup");
        this.setName("DialogOfPageSetup");
        this.action = new PageSetupAction(this);
        this.addWindowListener(this.action);
    }

    public void showDialog() {
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        DialogOfPageSetup dialog = (DialogOfPageSetup)menuUtil.getMenuComponent("DialogOfPageSetup");
        if (dialog != null) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "page setup dialog is already opened", "", 0);
            return;
        }
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 20, owner.getY() + 90);
        this.setLocation(centerP);
        JPanel pagePanel = this.createPagePanel();
        Container contentPane = this.getContentPane();
        contentPane.add(pagePanel);
        this.pack();
        this.setVisible(true);
        menuUtil.setMenuComponent(this);
    }

    private JPanel createPagePanel() {
        JPanel pagePanel = new JPanel();
        GridLayout pagePanelLayout = new GridLayout(3, 1);
        pagePanelLayout.setHgap(20);
        pagePanelLayout.setVgap(5);
        pagePanel.setLayout(pagePanelLayout);
        Border border = BorderFactory.createEtchedBorder(1);
        JPanel pageSizePanel = new JPanel();
        pageSizePanel.setFont(MenuConstants.MenuFont);
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Page sized for:");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        pageSizePanel.setBorder(frameBorder);
        Object[] pageSizes = new String[9];
        int stringlength = 0;
        for (int i = 0; i <= 8; ++i) {
            Dimension dimension = DrawParameters.SheetSizesMM[i];
            dimension = new Dimension((int)dimension.getHeight(), (int)dimension.getWidth());
            pageSizes[i] = DrawParameters.SheetSizeString[8 - i] + " ( " + (int)dimension.getWidth() + "x" + (int)dimension.getHeight() + " mm )";
            if (((String)pageSizes[i]).length() <= stringlength) continue;
            stringlength = ((String)pageSizes[i]).length();
        }
        this.pageSizeSpinnerModel = new SpinnerListModel(pageSizes);
        JSpinner spinner = new JSpinner(this.pageSizeSpinnerModel);
        spinner.setFont(MenuConstants.MenuFont);
        spinner.setBorder(border);
        String currentSize = DrawParameters.SheetSizeString[DrawParameters.SheetSize];
        int iSave = 0;
        for (int i = 0; i <= 8; ++i) {
            if (!((String)pageSizes[i]).startsWith(currentSize)) continue;
            iSave = i;
            break;
        }
        spinner.setValue(pageSizes[iSave]);
        pageSizePanel.add(spinner);
        JPanel orientationPanel = new JPanel();
        orientationPanel.setLayout(new BoxLayout(orientationPanel, 0));
        frameBorder = BorderFactory.createTitledBorder("Orientation");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        orientationPanel.setBorder(frameBorder);
        JLabel orientationLabel = new JLabel("Orientation:");
        orientationLabel.setFont(MenuConstants.MenuFont);
        orientationLabel.setBorder(border);
        JLabel orientationImageLabel = new JLabel();
        ImageIcon imageIcon = DrawImageIcon.get("text_box32T.png", 24, 24);
        orientationImageLabel.setIcon(imageIcon);
        pagePanel.add(pageSizePanel);
        pagePanel.add(orientationPanel);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 1));
        this.landscapeButton = new JRadioButton("Landscape");
        this.portraitButton = new JRadioButton("Portrait");
        this.landscapeButton.setFont(MenuConstants.MenuFont);
        this.portraitButton.setFont(MenuConstants.MenuFont);
        ButtonGroup group = new ButtonGroup();
        group.add(this.landscapeButton);
        group.add(this.portraitButton);
        if (DrawParameters.SheetOrientation == 0) {
            this.landscapeButton.setSelected(true);
        } else {
            this.portraitButton.setSelected(true);
        }
        radioButtonPanel.add(this.landscapeButton);
        radioButtonPanel.add(this.portraitButton);
        orientationPanel.add(orientationImageLabel);
        orientationPanel.add(radioButtonPanel);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setActionCommand("OK");
        cancelButton.setActionCommand("Cancel");
        okButton.addActionListener(this.action);
        cancelButton.addActionListener(this.action);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        pagePanel.add(buttonPanel);
        return pagePanel;
    }
}

