/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import menu.DialogOfPageLayout;
import shape.ShapeContainer;
import shape.ShapeElementUtil;
import util.ContainerManager;
import util.PageManager;
import util.ViewData;

class PagePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    DialogOfPageLayout dialog = null;
    int xNumOfFrames = 0;
    int yNumOfFrames = 0;
    private Rectangle2D[] pageFrameRects = null;
    int selectedPage = 0;
    int gapIndex = -1;
    final Dimension gap = new Dimension(20, 20);
    public static int debug = 0;

    public PagePanel(DialogOfPageLayout dialog) {
        this.dialog = dialog;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Line2D.Double line;
        double lineY;
        double lineX;
        this.setPageLayout();
        Graphics2D g2 = (Graphics2D)g;
        Rectangle viewRect = this.dialog.getScrollPane().getViewport().getViewRect();
        Shape currentClip = g2.getClip();
        Stroke currentStroke = g2.getStroke();
        g2.setClip(viewRect);
        Dimension pagePanelSize = this.getPagePanelSize();
        Rectangle2D.Double panelRect = new Rectangle2D.Double(0.0, 0.0, pagePanelSize.getWidth(), pagePanelSize.getHeight());
        g2.setColor(Color.WHITE);
        g2.fill(panelRect);
        g2.setColor(Color.BLACK);
        if (this.selectedPage >= 1) {
            Rectangle2D enlargedRect = ShapeElementUtil.getEnlargedRectangle(this.pageFrameRects[this.selectedPage - 1], 3.0, 3.0);
            BasicStroke defaultStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
            g2.setStroke(defaultStroke);
            g2.draw(enlargedRect);
        }
        double delta = 0.5 * this.gap.getWidth();
        double lineW = this.getPageFrameSize().getWidth();
        double lineH = this.getPageFrameSize().getHeight();
        BasicStroke defaultStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
        g2.setStroke(defaultStroke);
        if (this.gapIndex >= 1 && this.gapIndex <= this.pageFrameRects.length) {
            lineX = this.pageFrameRects[this.gapIndex - 1].getX();
            lineY = this.pageFrameRects[this.gapIndex - 1].getY();
            line = new Line2D.Double(lineX + lineW + delta, lineY, lineX + lineW + delta, lineY + lineH);
            g2.draw(line);
        }
        if (this.gapIndex >= 0 && this.gapIndex < this.pageFrameRects.length) {
            lineX = this.pageFrameRects[this.gapIndex].getX();
            lineY = this.pageFrameRects[this.gapIndex].getY();
            line = new Line2D.Double(lineX - delta, lineY, lineX - delta, lineY + lineH);
            g2.draw(line);
        }
        double X = this.gap.getWidth();
        double Y = this.gap.getHeight();
        for (int pageIndex = 1; pageIndex <= this.pageFrameRects.length; ++pageIndex) {
            g2.setStroke(currentStroke);
            g2.draw(this.pageFrameRects[pageIndex - 1]);
            this.drawPage(g, pageIndex, this.pageFrameRects[pageIndex - 1]);
            X += this.pageFrameRects[pageIndex - 1].getWidth() + this.gap.getWidth();
            if (pageIndex - pageIndex / this.xNumOfFrames * this.xNumOfFrames != 0) continue;
            Y += this.pageFrameRects[pageIndex - 1].getHeight() + this.gap.getHeight();
            X = this.gap.getWidth();
        }
        g2.setClip(currentClip);
    }

    public void setPageLayout() {
        Dimension pageFrameSize = this.getPageFrameSize();
        JScrollPane scrollpane = this.dialog.getScrollPane();
        Dimension scrollSize = scrollpane.getPreferredSize();
        Insets scrollInsets = new Insets(30, 4, 4, 4);
        Dimension displayAreaSize = new Dimension((int)(scrollSize.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right), (int)(scrollSize.getWidth() - (double)scrollInsets.top - (double)scrollInsets.bottom));
        this.xNumOfFrames = (int)(displayAreaSize.getWidth() / (pageFrameSize.getWidth() + this.gap.getWidth()));
        PageManager pageManager = ObjectTable.getPageManager("PagePanel");
        int numOfPages = pageManager.getPageList().size();
        this.yNumOfFrames = numOfPages / this.xNumOfFrames;
        if (numOfPages - this.yNumOfFrames * this.xNumOfFrames > 0) {
            ++this.yNumOfFrames;
        }
        if (debug > 0) {
            System.out.println(" -- PagePanel displayAreaSize=" + displayAreaSize + ", num of pages=" + numOfPages + ", pageFrameSize=" + pageFrameSize + ", x-num of sheets=" + this.xNumOfFrames + ", y-num of sheets=" + this.yNumOfFrames);
        }
        this.setPreferredSize(this.getPagePanelSize());
        this.setBackground(Color.WHITE);
        this.pageFrameRects = this.getPageFrameRects();
        this.revalidate();
    }

    private Dimension getPageFrameSize() {
        Dimension A4SizeMM = DrawParameters.A4_Size;
        double PixelPerMM = 3.7795275590551185;
        double Ratio = 0.125;
        Dimension pageSize = new Dimension((int)(A4SizeMM.getHeight() * PixelPerMM * Ratio), (int)(A4SizeMM.getWidth() * PixelPerMM * Ratio));
        return pageSize;
    }

    private Dimension getPagePanelSize() {
        Dimension scrollPaneSize = this.dialog.getScrollPane().getPreferredSize();
        Dimension scrollBarSize = this.dialog.getScrollPane().getVerticalScrollBar().getSize();
        Insets insets = this.dialog.getScrollPane().getInsets();
        int width = (int)(scrollPaneSize.getWidth() - (double)insets.left - (double)insets.right - scrollBarSize.getWidth());
        Dimension pageFrameSize = this.getPageFrameSize();
        int height = (int)((double)this.yNumOfFrames * (pageFrameSize.getHeight() + this.gap.getHeight()) + this.gap.getHeight());
        Dimension size = new Dimension(width, height);
        return size;
    }

    private Rectangle2D[] getPageFrameRects() {
        PageManager pageManager = ObjectTable.getPageManager("PagePanel");
        int numOfPages = pageManager.getPageList().size();
        Rectangle2D[] rectangles = new Rectangle2D[numOfPages];
        double X = this.gap.getWidth();
        double Y = this.gap.getHeight();
        Dimension pageFrameSize = this.getPageFrameSize();
        double width = pageFrameSize.getWidth();
        double height = pageFrameSize.getHeight();
        for (int pageIndex = 1; pageIndex <= numOfPages; ++pageIndex) {
            rectangles[pageIndex - 1] = new Rectangle2D.Double(X, Y, width, height);
            X += width + this.gap.getWidth();
            if (pageIndex - pageIndex / this.xNumOfFrames * this.xNumOfFrames != 0) continue;
            Y += height + this.gap.getHeight();
            X = this.gap.getWidth();
        }
        return rectangles;
    }

    private void drawPage(Graphics g, int pageIndex, Rectangle2D rect) {
        PageManager pageManager = ObjectTable.getPageManager();
        ArrayList list = pageManager.getContainerList(pageIndex);
        ViewData viewData = pageManager.getViewData(pageIndex);
        ContainerManager containerManager = new ContainerManager();
        containerManager.setContainerList(list);
        double scale = this.getScale(viewData, rect);
        if (debug > 0) {
            System.out.println(" -- DrawPage pageIndex=" + pageIndex + ", rect=" + rect + ", scale=" + scale);
        }
        Graphics2D g2 = (Graphics2D)g;
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        g2.translate(rect.getX(), rect.getY());
        int orientation = viewData.getSheetOrientation();
        if (orientation == 1) {
            g2.translate(0.0, rect.getHeight());
            g2.rotate(-1.5707963267948966);
        }
        g2.scale(scale, scale);
        ShapeContainer[] containers = containerManager.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].drawShape(g);
        }
        g2.setTransform(currentTransform);
        String pageStr = "page-" + pageIndex;
        g2.drawString(pageStr, (int)(rect.getX() + rect.getWidth() / 2.0 - 15.0), (int)(rect.getY() + rect.getHeight() + 12.0));
        g2.setColor(currentColor);
    }

    private double getScale(ViewData viewData, Rectangle2D rect) {
        int sheetSize = viewData.getSheetSize();
        Dimension sheetDimensionMM = DrawParameters.SheetSizesMM[sheetSize];
        sheetDimensionMM = new Dimension((int)sheetDimensionMM.getHeight(), (int)sheetDimensionMM.getWidth());
        double pixelPerMM = 3.7795275590551185;
        Dimension sheetDimension = new Dimension((int)(sheetDimensionMM.getWidth() * pixelPerMM), (int)(sheetDimensionMM.getHeight() * pixelPerMM));
        double width = rect.getWidth();
        double scale = width / sheetDimension.getWidth();
        return scale;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double Y;
        double X = e.getX();
        Point2D.Double startPoint = new Point2D.Double(X, Y = (double)e.getY());
        int index = this.ptInside(startPoint);
        this.selectedPage = index > 0 ? index : 0;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double X = e.getX();
        double Y = e.getY();
        Point2D.Double currentPoint = new Point2D.Double(X, Y);
        this.gapIndex = this.getNearestGap(currentPoint);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double X = e.getX();
        double Y = e.getY();
        Point2D.Double endPoint = new Point2D.Double(X, Y);
        this.gapIndex = this.getNearestGap(endPoint);
        PageManager pageManager = ObjectTable.getPageManager("PagePanel");
        if (debug > 0) {
            System.out.println("mouseReleased  this.selectedPage=" + this.selectedPage + ", this.gapIndex=" + this.gapIndex);
        }
        if (this.selectedPage >= 1 && this.gapIndex >= 0) {
            pageManager.movePage(this.selectedPage, this.gapIndex + 1);
        }
        this.selectedPage = 0;
        this.gapIndex = -1;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int ptInside(Point2D point) {
        int index = -1;
        for (int i = 1; i <= this.pageFrameRects.length; ++i) {
            if (!this.pageFrameRects[i - 1].contains(point)) continue;
            index = i;
        }
        return index;
    }

    public int getNearestGap(Point2D point) {
        int page = -1;
        int side = -1;
        double distMin = Math.pow(10.0, 4.0);
        double X = point.getX();
        double Y = point.getY();
        for (int i = 1; i <= this.pageFrameRects.length; ++i) {
            double x = this.pageFrameRects[i - 1].getX();
            double y = this.pageFrameRects[i - 1].getY();
            double w = this.pageFrameRects[i - 1].getWidth();
            double h = this.pageFrameRects[i - 1].getHeight();
            if (Y < y || Y > y + h) continue;
            double dist1 = Math.abs(X - x);
            double dist2 = Math.abs(X - x - w);
            if (dist1 < distMin) {
                distMin = dist1;
                page = i;
                side = 0;
            }
            if (!(dist2 < distMin)) continue;
            distMin = dist2;
            page = i;
            side = 1;
        }
        int gapIndex = -1;
        if (page > 0 && side == 0) {
            gapIndex = page - 1;
        }
        if (page > 0 && side == 1) {
            gapIndex = page;
        }
        if (debug > 0) {
            System.out.println("  -- nearest gap=" + gapIndex + ", X,Y=" + X + "," + Y);
        }
        return gapIndex;
    }
}

