/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import menu.DrawImageIcon;
import menu.MenuConstants;
import menu.MenuUtil;
import menu.PopupMenuAction;
import shape.ShapeContainer;

public class PopupPulldownMenu
extends JPopupMenu {
    PopupMenuAction menuAction = new PopupMenuAction(this);
    public Point2D point = null;
    public ShapeContainer container = null;
    static int debug = 0;

    public PopupPulldownMenu(String commandName, String[] menuItemNames, ImageIcon[] icons, String[] accelerators) {
        this.setName(commandName);
        this.setMenuItems(menuItemNames, icons, accelerators);
    }

    public void setMenuItems(String[] menuItemNames, ImageIcon[] imageIcons, String[] accelerators) {
        int acceleratorWidth = 24;
        int textWidthMax = 0;
        int textHeightMax = 0;
        for (int i = 0; i < menuItemNames.length; ++i) {
            Dimension textSize = this.getTextLayoutSize(menuItemNames[i], MenuConstants.MenuItemFont);
            int textWidth = (int)textSize.getWidth();
            int textHeight = (int)textSize.getHeight();
            if (accelerators != null && !accelerators[i].equals("")) {
                textWidth += acceleratorWidth;
            }
            if (textWidth > textWidthMax) {
                textWidthMax = textWidth;
            }
            if (textHeight <= textHeightMax) continue;
            textHeightMax = textHeight;
        }
        int marginWidth = 32;
        int marginHeight = 6;
        for (int i = 0; i < menuItemNames.length; ++i) {
            JMenuItem menuItem = new JMenuItem();
            if (accelerators != null && !accelerators[i].equals("")) {
                KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
                menuItem.setAccelerator(stroke);
            }
            int imageWidth = 0;
            int imageHeight = 0;
            int menuItemWidth = 0;
            if (imageIcons[i] != null) {
                menuItem.setLayout(new FlowLayout(0, 0, 0));
                JLabel textLabel = new JLabel(" " + menuItemNames[i] + " ");
                textLabel.setPreferredSize(new Dimension(textWidthMax + marginWidth, textHeightMax + marginHeight));
                menuItem.add(textLabel);
                menuItemWidth += textWidthMax + marginWidth;
                Image image = imageIcons[i].getImage();
                imageWidth = image.getWidth(null);
                imageHeight = image.getHeight(null);
                JLabel imageLabel = new JLabel(imageIcons[i]);
                imageLabel.setPreferredSize(new Dimension(imageWidth, imageHeight));
                menuItem.add(imageLabel);
                menuItemWidth += imageWidth + marginWidth;
            } else {
                menuItem.setText(menuItemNames[i]);
                menuItemWidth += textWidthMax + marginWidth;
            }
            int menuItemHeight = textHeightMax + marginHeight;
            menuItem.setPreferredSize(new Dimension(menuItemWidth, menuItemHeight));
            menuItem.setFont(MenuConstants.MenuItemFont);
            String command = Command.getCommandString(menuItemNames[i]);
            if (command.equals("")) {
                System.err.println("** Error PopupPulldownMenu.setMenuItems  command=" + menuItemNames[i] + " not found");
            } else {
                menuItem.setActionCommand(command);
            }
            menuItem.addActionListener(this.menuAction);
            menuItem.setName(menuItemNames[i]);
            this.add(menuItem);
        }
    }

    private Dimension getTextLayoutSize(String text, Font font) {
        TextLayout textlayout = new TextLayout(text, font, new FontRenderContext(null, false, false));
        int textWidth = (int)textlayout.getAdvance();
        int textHeight = (int)(textlayout.getAscent() + textlayout.getDescent());
        return new Dimension(textWidth, textHeight);
    }

    public JMenuItem getMenuItem(String menuItemName) {
        String name;
        Component[] components = this.getComponents();
        JMenuItem menuItem = null;
        for (int i = 0; i < components.length && !Command.compareStrings(menuItemName, name = (menuItem = (JMenuItem)components[i]).getName()); ++i) {
        }
        if (menuItem == null) {
            System.err.println("*** Error Pulldown.getMenuItem: specified name not found, name=" + menuItemName);
        }
        return menuItem;
    }

    public void setEnableToAllMenuItems() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem menuItem = (JMenuItem)components[i];
            menuItem.setEnabled(true);
        }
    }

    public void show(Point2D point, ShapeContainer container) {
        this.point = point;
        this.container = container;
        double scale = DrawParameters.Scale;
        int ix = (int)(scale * point.getX());
        int iy = (int)(scale * point.getY());
        this.show(ObjectTable.getDrawPanel(), ix, iy);
        if (debug > 0) {
            System.out.println("** PopupPulldownMenu.show ShapeContainer=" + this.container.getShapeId() + ", ix=" + ix + ", iy=" + iy);
        }
    }

    public static void createDrawPanelPopupMenu() {
        String commandName = Command.getCommandString(200);
        String[] imageName = new String[]{"", ""};
        String[] menuItemNames = new String[]{"paste", "draw panel information"};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
    }

    public static void createSingleShapePopupMenu() {
        String commandName = Command.getCommandString(201);
        String[] imageName = new String[]{"", "", "", "", "", "", ""};
        String[] menuItemNames = new String[]{"cut", "copy", "delete", "add text box", "delete text box", "modify shape", "shape format"};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
    }

    public static void createGroupShapePopupMenu() {
        String commandName = Command.getCommandString(202);
        String[] imageName = new String[]{"", "", "", ""};
        String[] menuItemNames = new String[]{"cut", "copy", "delete", "shape format"};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
    }

    public static void createTextBoxPopupMenu() {
        String commandName = Command.getCommandString(203);
        String[] imageName = new String[]{"", "", "", "", ""};
        String[] menuItemNames = new String[]{"cut", "copy", "delete", "paste"};
        ImageIcon[] itemIcons = new ImageIcon[menuItemNames.length];
        for (int i = 0; i < menuItemNames.length; ++i) {
            itemIcons[i] = null;
            if (imageName[i].equals("")) continue;
            itemIcons[i] = DrawImageIcon.get(imageName[i], 64, 10);
        }
        PopupPulldownMenu popupMenu = new PopupPulldownMenu(commandName, menuItemNames, itemIcons, null);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(popupMenu);
    }
}

