/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.CubicCurve2DE;
import geomExtension.FergusonCurve2D;
import geomExtension.Matrix2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import shape.DiscreteAngledLine;
import shape.SegmentModifier;
import shape.ShapeElement;
import shape.ShapeElementUtil;

public class CubicCurveElement
extends ShapeElement {
    @Override
    public int getTypeE() {
        return 55;
    }

    @Override
    public String getShapeIdString() {
        return "CubicCurve";
    }

    @Override
    public Rectangle2D createTextArea() {
        if (!this.isClosed()) {
            return null;
        }
        Shape shape = this.getShape();
        double sqrt2 = Math.sqrt(2.0);
        Rectangle2D textArea = ShapeElementUtil.getInscribedBox(shape, false);
        return textArea;
    }

    @Override
    public SegmentModifier[] getSegmentModifiers() {
        SegmentModifier[] modifiers = new SegmentModifier[]{};
        return modifiers;
    }

    @Override
    public Point2D[] getModifierPTs() {
        Point2D[] PTs = new Point2D[]{};
        return PTs;
    }

    @Override
    public void create(Rectangle2D boundingBox) {
    }

    @Override
    public void create(Point2D startPoint, Point2D currentPoint) {
    }

    @Override
    public void create(Point2D[] points) {
        if (points.length >= 2) {
            FergusonCurve2D furgusonCurve = FergusonCurve2D.createNaturalSpline(points);
            this.curve2D = furgusonCurve.getCubicCurve2DE();
        }
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D currentPoint) {
        if (ctrl >= 3) {
            return;
        }
        this.getShapeContainer().setChangeCode(4);
        Point2D newPT = currentPoint;
        Point2D oldPT = oldPoint;
        if (ctrl > 0) {
            newPT = DiscreteAngledLine.getControlledPT(0.0, 90.0, oldPoint, newPT);
            oldPT = DiscreteAngledLine.getControlledPT(0.0, 90.0, oldPoint, oldPT);
        }
        CubicCurve2DE cubicCurve = (CubicCurve2DE)this.curve2D;
        Point2D[] Q = cubicCurve.getCtrlPoints();
        int size = 0;
        if (Q != null) {
            size = Q.length;
        }
        Point2D[] newQ = new Point2D[size];
        Point2D anchorP = null;
        int numseg = this.curve2D.getNumOfSegments();
        anchorP = movePtIndex == 0 ? this.curve2D.getP(numseg) : this.curve2D.getP(0.0);
        Vector2D r0 = Vector2D.sub(oldPT, anchorP);
        Vector2D r = Vector2D.sub(newPT, anchorP);
        Matrix2D rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
        for (int i = 0; i < size; ++i) {
            newQ[i] = Matrix2D.transForm(rotationMatrix, Q[i]);
        }
        cubicCurve.setData(newQ);
    }

    @Override
    public void modify(int ctrl, Point2D oldPoint, Point2D currentPoint) {
    }

    @Override
    public void modifyPoint(Point2D point, String command) {
    }

    @Override
    public Object clone() {
        CubicCurveElement shapeElement = new CubicCurveElement();
        CubicCurve2DE curve = (CubicCurve2DE)this.curve2D.clone();
        shapeElement.setCurve2D(curve);
        return shapeElement;
    }

    @Override
    public String toString() {
        String str = "";
        if (this.curve2D == null) {
            str = str + "CubicCurve: not defined";
            return str;
        }
        return this.curve2D.toString();
    }
}

